/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.tds.SybTimestamp;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class DateObject {
    private static final String ZEROS = "0000000000";
    private int _nanos = 0;
    private Calendar _calendar = null;

    public DateObject() throws SQLException {
        this.init(null, null);
    }

    public DateObject(Object object) throws SQLException {
        this.init(object, null);
    }

    public DateObject(Object object, Calendar calendar) throws SQLException {
        this.init(object, calendar);
    }

    public DateObject(Calendar calendar) throws SQLException {
        this.init(null, calendar);
    }

    public String format(boolean bl) {
        int n = 0;
        String string = String.valueOf(this._calendar.get(1)) + "-";
        n = this._calendar.get(2) + 1;
        string = String.valueOf(string) + (n < 10 ? "0" : "") + n + "-";
        n = this._calendar.get(5);
        string = String.valueOf(string) + (n < 10 ? "0" : "") + n + " ";
        n = this._calendar.get(11);
        string = String.valueOf(string) + (n < 10 ? "0" : "") + n + ":";
        n = this._calendar.get(12);
        string = String.valueOf(string) + (n < 10 ? "0" : "") + n + ":";
        n = this._calendar.get(13);
        string = String.valueOf(string) + (n < 10 ? "0" : "") + n;
        if (bl) {
            String string2 = null;
            if (this._nanos == 0) {
                string2 = "0";
            } else {
                string2 = Integer.toString(this._nanos);
                if (string2.length() < 9) {
                    string2 = String.valueOf(ZEROS.substring(0, 9 - string2.length())) + string2;
                }
                char[] cArray = new char[string2.length()];
                string2.getChars(0, string2.length(), cArray, 0);
                int n2 = 8;
                while (cArray[n2] == '0') {
                    --n2;
                }
                string2 = new String(cArray, 0, n2 + 1);
            }
            string = String.valueOf(string) + "." + string2;
        }
        return string;
    }

    public Calendar getCalendar() {
        return this._calendar;
    }

    public int getNanos() {
        return this._nanos;
    }

    private void init(Object object, Calendar calendar) throws SQLException {
        Calendar calendar2 = null;
        calendar2 = calendar != null ? (Calendar)calendar.clone() : Calendar.getInstance();
        if (object != null) {
            this._calendar = Convert.objectToCalendar(object, calendar2);
            if (object instanceof Timestamp) {
                this._nanos = ((Timestamp)object).getNanos();
            }
        } else {
            this._calendar = calendar2;
            this._calendar.clear();
        }
    }

    public void setNanos(int n) {
        this._nanos = n;
    }

    public String toString() {
        String string = this.format(true);
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            int n2 = n + 4;
            if (n2 > string.length()) {
                n2 = string.length();
            }
            string = string.substring(0, n2);
        }
        return string;
    }

    public SybTimestamp toSybTimestamp() {
        return new SybTimestamp(this._calendar.get(1) - 1900, this._calendar.get(2), this._calendar.get(5), this._calendar.get(11), this._calendar.get(12), this._calendar.get(13), this._nanos);
    }
}

