/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import junit.framework.Assert;
import org.junit.Test;

public class BucketLoggingTest
extends TestBase {
    @Test
    public void testNormalSetBucketLogging() {
        String sourceBucket = "normal-set-bucket-logging-source";
        String targetBucket = "normal-set-bucket-logging-target";
        String targetPrefix = "normal-set-bucket-logging-prefix";
        try {
            try {
                secondClient.createBucket("normal-set-bucket-logging-source");
                secondClient.createBucket("normal-set-bucket-logging-target");
                SetBucketLoggingRequest request = new SetBucketLoggingRequest("normal-set-bucket-logging-source");
                request.setTargetBucket("normal-set-bucket-logging-target");
                request.setTargetPrefix("normal-set-bucket-logging-prefix");
                secondClient.setBucketLogging(request);
                BucketLoggingResult result = secondClient.getBucketLogging("normal-set-bucket-logging-source");
                Assert.assertEquals((String)"normal-set-bucket-logging-target", (String)result.getTargetBucket());
                Assert.assertEquals((String)"normal-set-bucket-logging-prefix", (String)result.getTargetPrefix());
                secondClient.deleteBucketLogging("normal-set-bucket-logging-source");
                request.setTargetBucket("normal-set-bucket-logging-source");
                request.setTargetPrefix("normal-set-bucket-logging-prefix");
                secondClient.setBucketLogging(request);
                TestUtils.waitForCacheExpiration(5);
                result = secondClient.getBucketLogging("normal-set-bucket-logging-source");
                Assert.assertEquals((String)"normal-set-bucket-logging-source", (String)result.getTargetBucket());
                Assert.assertEquals((String)"normal-set-bucket-logging-prefix", (String)result.getTargetPrefix());
                secondClient.deleteBucketLogging("normal-set-bucket-logging-source");
                request.setTargetBucket("normal-set-bucket-logging-target");
                request.setTargetPrefix(null);
                secondClient.setBucketLogging(request);
                result = secondClient.getBucketLogging("normal-set-bucket-logging-source");
                Assert.assertEquals((String)"normal-set-bucket-logging-target", (String)result.getTargetBucket());
                Assert.assertTrue((boolean)result.getTargetPrefix().isEmpty());
                secondClient.deleteBucketLogging("normal-set-bucket-logging-source");
                request.setTargetBucket(null);
                request.setTargetPrefix(null);
                secondClient.setBucketLogging(request);
                result = secondClient.getBucketLogging("normal-set-bucket-logging-source");
                Assert.assertTrue((result.getTargetBucket() == null ? 1 : 0) != 0);
                Assert.assertTrue((result.getTargetPrefix() == null ? 1 : 0) != 0);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("normal-set-bucket-logging-source");
                secondClient.deleteBucket("normal-set-bucket-logging-target");
            }
        }
        finally {
            secondClient.deleteBucket("normal-set-bucket-logging-source");
            secondClient.deleteBucket("normal-set-bucket-logging-target");
        }
    }

    @Test
    public void testUnormalSetBucketLogging() {
        String sourceBucket = "unormal-set-bucket-logging-source";
        String targetBucket = "unormal-set-bucket-logging-target";
        String targetPrefix = "unormal-set-bucket-logging-prefix";
        try {
            secondClient.createBucket("unormal-set-bucket-logging-source");
            secondClient.createBucket("unormal-set-bucket-logging-target");
            String nonexistentSourceBucket = "nonexistent-source-bucket";
            try {
                SetBucketLoggingRequest request = new SetBucketLoggingRequest("nonexistent-source-bucket");
                request.setTargetBucket("unormal-set-bucket-logging-target");
                request.setTargetPrefix("unormal-set-bucket-logging-prefix");
                secondClient.setBucketLogging(request);
                Assert.fail((String)"Set bucket logging should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
            }
            String nonexistentTargetBucket = "nonexistent-target-bucket";
            try {
                SetBucketLoggingRequest request = new SetBucketLoggingRequest("unormal-set-bucket-logging-source");
                request.setTargetBucket("nonexistent-target-bucket");
                request.setTargetPrefix("unormal-set-bucket-logging-prefix");
                secondClient.setBucketLogging(request);
                Assert.fail((String)"Set bucket logging should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"InvalidTargetBucketForLogging", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("put bucket log requester is not target bucket owner."));
            }
            String targetBucketWithDiffLocation = "target-bucket-with-diff-location";
            try {
                try {
                    defaultClient.createBucket("target-bucket-with-diff-location");
                    SetBucketLoggingRequest request = new SetBucketLoggingRequest("unormal-set-bucket-logging-source");
                    request.setTargetBucket("target-bucket-with-diff-location");
                    request.setTargetPrefix("unormal-set-bucket-logging-prefix");
                    secondClient.setBucketLogging(request);
                    Assert.fail((String)"Set bucket logging should not be successful");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"InvalidTargetBucketForLogging", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("put bucket log requester is not target bucket owner."));
                    defaultClient.deleteBucket("target-bucket-with-diff-location");
                }
            }
            finally {
                defaultClient.deleteBucket("target-bucket-with-diff-location");
            }
        }
        finally {
            secondClient.deleteBucket("unormal-set-bucket-logging-source");
            secondClient.deleteBucket("unormal-set-bucket-logging-target");
        }
    }

    @Test
    public void testUnormalGetBucketLogging() {
        String nonexistentBucket = "unormal-get-bucket-logging";
        try {
            secondClient.getBucketLogging("unormal-get-bucket-logging");
            Assert.fail((String)"Get bucket logging should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.getBucketLogging("oss");
            Assert.fail((String)"Get bucket logging should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketWithoutLoggingRule = "bucket-without-logging-rule";
        try {
            try {
                secondClient.createBucket("bucket-without-logging-rule");
                BucketLoggingResult result = secondClient.getBucketLogging("bucket-without-logging-rule");
                Assert.assertTrue((result.getTargetBucket() == null ? 1 : 0) != 0);
                Assert.assertTrue((result.getTargetPrefix() == null ? 1 : 0) != 0);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("bucket-without-logging-rule");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-without-logging-rule");
        }
    }

    @Test
    public void testUnormalDeleteBucketLogging() {
        String nonexistentBucket = "unormal-delete-bucket-logging";
        try {
            secondClient.deleteBucketLogging("unormal-delete-bucket-logging");
            Assert.fail((String)"Delete bucket logging should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
        String bucketWithoutOwnership = "oss";
        try {
            secondClient.deleteBucketLogging("oss");
            Assert.fail((String)"Delete bucket logging should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("AccessDenied"));
        }
        String bucketWithoutLoggingRule = "bucket-without-logging-rule";
        try {
            try {
                secondClient.createBucket("bucket-without-logging-rule");
                secondClient.deleteBucketLogging("bucket-without-logging-rule");
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                secondClient.deleteBucket("bucket-without-logging-rule");
            }
        }
        finally {
            secondClient.deleteBucket("bucket-without-logging-rule");
        }
    }
}

