/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.comm.DefaultServiceClient;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.utils.ResourceUtils;
import com.aliyun.oss.utils.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class ServiceClientTest {
    static ClientException createRetryableException() {
        return new ClientException(null, "ConnectionTimeout", "requestid", null);
    }

    @Test
    public void testRetryWillSucceed() throws Exception {
        int MAX_RETRIES = 3;
        ClientConfiguration config = new ClientConfiguration();
        config.setMaxErrorRetry(3);
        int maxFailures = 3;
        long skipBeforeSend = 3L;
        String content = "Let's retry!";
        byte[] contentBytes = content.getBytes("utf-8");
        ByteArrayInputStream contentStream = new ByteArrayInputStream(contentBytes);
        contentStream.skip(3L);
        RequestMessage request = new RequestMessage();
        request.setEndpoint(new URI("http://localhost"));
        request.setMethod(HttpMethod.GET);
        request.setContent(contentStream);
        request.setContentLength((long)contentBytes.length - 3L);
        ExecutionContext context = new ExecutionContext();
        ClientException exceptionToThrow = ServiceClientTest.createRetryableException();
        ServiceClientImpl client = new ServiceClientImpl(config, maxFailures, exceptionToThrow, 200, content.substring(3));
        client.sendRequest(request, context);
        Assert.assertEquals((long)4L, (long)client.getRequestAttempts());
    }

    @Test
    public void testRetryWillFail() throws Exception {
        this.retryButFail(3);
    }

    @Test
    public void testNoRetry() throws Exception {
        this.retryButFail(0);
    }

    private void retryButFail(int maxRetries) throws UnsupportedEncodingException, URISyntaxException, ServiceException {
        ClientConfiguration config = new ClientConfiguration();
        config.setMaxErrorRetry(maxRetries);
        int maxFailures = 4;
        String content = "Let's retry!";
        byte[] contentBytes = content.getBytes("utf-8");
        ByteArrayInputStream contentStream = new ByteArrayInputStream(contentBytes);
        RequestMessage request = new RequestMessage();
        request.setEndpoint(new URI("http://localhost"));
        request.setMethod(HttpMethod.GET);
        request.setContent(contentStream);
        request.setContentLength(contentBytes.length);
        ExecutionContext context = new ExecutionContext();
        ClientException exceptionToThrown = ServiceClientTest.createRetryableException();
        ServiceClientImpl client = new ServiceClientImpl(config, maxFailures, exceptionToThrown, 200, content);
        try {
            client.sendRequest(request, context);
            Assert.fail((String)"ClientException has not been thrown.");
        }
        catch (ClientException e) {
            Assert.assertEquals((Object)exceptionToThrown, (Object)e);
            Assert.assertEquals((long)(maxRetries + 1), (long)client.getRequestAttempts());
        }
    }

    @Test
    public void testRetryWithServiceException() throws Exception {
        ClientConfiguration config = new ClientConfiguration();
        config.setMaxErrorRetry(1);
        int maxFailures = 0;
        String content = "Let's retry!";
        byte[] contentBytes = content.getBytes("utf-8");
        ByteArrayInputStream contentStream = new ByteArrayInputStream(contentBytes);
        RequestMessage request = new RequestMessage();
        request.setEndpoint(new URI("http://localhost"));
        request.setMethod(HttpMethod.GET);
        request.setContent(contentStream);
        request.setContentLength(contentBytes.length);
        ExecutionContext context = new ExecutionContext();
        context.getResponseHandlers().add(new ResponseHandler(){

            @Override
            public void handle(ResponseMessage responseData) throws ServiceException, ClientException {
                throw new ServiceException();
            }
        });
        ServiceClientImpl client = new ServiceClientImpl(config, maxFailures, null, 500, content);
        try {
            client.sendRequest(request, context);
            Assert.fail((String)"ServiceException has not been thrown.");
        }
        catch (ServiceException e) {
            Assert.assertEquals((long)2L, (long)client.getRequestAttempts());
        }
    }

    @Test
    public void testRetryWithNoneMarkSupportedStream() throws Exception {
        String filename = ResourceUtils.getTestFilename("oss/listBucket.xml");
        File file = new File(filename);
        FileInputStream contentStream = new FileInputStream(file);
        RequestMessage request = new RequestMessage();
        request.setEndpoint(new URI("http://localhost"));
        request.setMethod(HttpMethod.GET);
        request.setContent(contentStream);
        request.setContentLength(file.length());
        ExecutionContext context = new ExecutionContext();
        ClientException exceptionToThrown = ServiceClientTest.createRetryableException();
        String content = "";
        FileInputStream contentStream2 = new FileInputStream(file);
        try {
            content = StreamUtils.readContent(contentStream2, "utf-8");
        }
        finally {
            ((InputStream)contentStream2).close();
        }
        ServiceClientImpl client = new ServiceClientImpl(new ClientConfiguration(), 3, exceptionToThrown, 400, content);
        try {
            client.sendRequest(request, context);
            Assert.fail((String)"ClientException has not been thrown.");
        }
        catch (ClientException e) {
            Assert.assertEquals((Object)exceptionToThrown, (Object)e);
            Assert.assertEquals((long)1L, (long)client.getRequestAttempts());
        }
    }

    static class ServiceClientImpl
    extends DefaultServiceClient {
        private int requestAttemps = 0;
        private int maxFailureCount;
        private int statusCode;
        private ClientException exceptionToThrow;
        private String expectedContent;

        public int getRequestAttempts() {
            return this.requestAttemps;
        }

        protected ServiceClientImpl(ClientConfiguration config, int maxFailureCount, ClientException exceptionToThrow, int statusCode, String expectedContent) {
            super(config);
            this.maxFailureCount = maxFailureCount;
            this.exceptionToThrow = exceptionToThrow;
            this.expectedContent = expectedContent;
            this.statusCode = statusCode;
        }

        @Override
        public ResponseMessage sendRequestCore(ServiceClient.Request request, ExecutionContext context) throws IOException {
            if (this.expectedContent != null) {
                Assert.assertTrue((request.getContent() != null ? 1 : 0) != 0);
                Assert.assertEquals((Object)this.expectedContent, (Object)StreamUtils.readContent(request.getContent(), "utf-8"));
            }
            if (++this.requestAttemps <= this.maxFailureCount) {
                throw this.exceptionToThrow;
            }
            ResponseMessage response = new ResponseMessage(null);
            response.setStatusCode(this.statusCode);
            return response;
        }
    }
}

