/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.util.HTMLParameterParser;
import org.htmlparser.util.HTMLParserException;
import org.htmlparser.util.HTMLTagParser;

public class HTMLTag
extends HTMLNode {
    public static final String TAGNAME = "$<TAGNAME>$";
    public static final int TAG_BEFORE_PARSING_STATE = 1;
    public static final int TAG_BEGIN_PARSING_STATE = 2;
    public static final int TAG_FINISHED_PARSING_STATE = 3;
    public static final int TAG_ILLEGAL_STATE = 4;
    public static final int TAG_IGNORE_DATA_STATE = 5;
    public static final int TAG_IGNORE_BEGIN_TAG_STATE = 6;
    private static boolean encounteredQuery;
    private static Vector strictTags;
    private static HTMLParameterParser paramParser;
    private static HTMLTagParser tagParser;
    StringBuffer tagContents = new StringBuffer();
    protected Hashtable parsed = null;
    protected HTMLTagScanner thisScanner = null;
    private String tagLine;
    private boolean endOfLineCharState;
    protected static HashSet mBreakTags;
    int nLine;

    public HTMLTag(int tagBegin, int tagEnd, String tagContents, String tagLine) {
        super(tagBegin, tagEnd);
        this.tagContents.append(tagContents);
        this.tagLine = tagLine;
        this.endOfLineCharState = false;
        this.nLine = -1;
    }

    public HTMLTag(int tagBegin, int tagEnd, String tagContents, String tagLine, int _nLine) {
        super(tagBegin, tagEnd);
        this.tagContents.append(tagContents);
        this.tagLine = tagLine;
        this.endOfLineCharState = false;
        this.nLine = _nLine;
    }

    public void append(char ch) {
        this.tagContents.append(ch);
    }

    public void append(String ch) {
        this.tagContents.append(ch);
    }

    public static HTMLTag find(HTMLReader reader, String input, int position) {
        return tagParser.find(reader, input, position);
    }

    public Hashtable parseParameters() {
        return paramParser.parseParameters(this);
    }

    public String getParameter(String name) {
        return (String)this.getParsed().get(name.toUpperCase());
    }

    public Hashtable getParsed() {
        if (this.parsed == null) {
            this.parsed = this.parseParameters();
        }
        return this.parsed;
    }

    public static Vector getStrictTags() {
        return strictTags;
    }

    public String getTagName() {
        if (this.parsed == null) {
            this.parsed = this.parseParameters();
        }
        return (String)this.parsed.get(TAGNAME);
    }

    public String getTagLine() {
        return this.tagLine;
    }

    public String getText() {
        return this.tagContents.toString();
    }

    public HTMLTagScanner getThisScanner() {
        return this.thisScanner;
    }

    public boolean isEndOfLineCharState() {
        return this.endOfLineCharState;
    }

    public static String extractWord(String s) {
        String word = "";
        boolean parse = true;
        for (int i = 0; i < s.length() && parse; ++i) {
            char ch = s.charAt(i);
            if (ch == ' ' || ch == '\r' || ch == '\n' || ch == '=') {
                parse = false;
                continue;
            }
            word = String.valueOf(String.valueOf(word)).concat(String.valueOf(String.valueOf(ch)));
        }
        word = word.toUpperCase();
        return word;
    }

    public HTMLNode scan(Hashtable scanners, String url, HTMLReader reader) throws HTMLParserException {
        if (this.tagContents.length() == 0) {
            return this;
        }
        try {
            boolean found = false;
            HTMLTag retVal = null;
            String firstWord = HTMLTag.extractWord(this.tagContents.toString());
            HTMLTagScanner scanner = (HTMLTagScanner)scanners.get(firstWord);
            if (scanner != null && scanner.evaluate(this.tagContents.toString(), reader.getPreviousOpenScanner())) {
                found = true;
                reader.setPreviousOpenScanner(scanner);
                retVal = scanner.createScannedNode(this, url, reader, this.tagLine);
                reader.setPreviousOpenScanner(null);
            }
            if (!found) {
                HTMLTag hTMLTag = this;
                return hTMLTag;
            }
            HTMLTag hTMLTag = retVal;
            return hTMLTag;
        }
        catch (Exception e) {
            String errorMsg = this.tagContents != null ? this.tagContents.toString() : "null";
            throw new HTMLParserException(String.valueOf(String.valueOf(new StringBuffer("HTMLTag.scan() : Error while scanning tag, tag contents = ").append(errorMsg).append(", tagLine = ").append(this.tagLine))), e);
        }
    }

    public void setEndOfLineCharState(boolean newEndOfLineCharState) {
        this.endOfLineCharState = newEndOfLineCharState;
    }

    public void setParsed(Hashtable parsed) {
        this.parsed = parsed;
    }

    public static void setStrictTags(Vector strictTags) {
        HTMLTag.strictTags = strictTags;
    }

    public void setTagBegin(int tagBegin) {
        this.nodeBegin = tagBegin;
    }

    public void setTagEnd(int tagEnd) {
        this.nodeEnd = tagEnd;
    }

    public void setTagLine(String newTagLine) {
        this.tagLine = newTagLine;
    }

    public void setText(String text) {
        this.tagContents = new StringBuffer(text);
    }

    public void setThisScanner(HTMLTagScanner scanner) {
        this.thisScanner = scanner;
    }

    public String toPlainTextString() {
        return "";
    }

    public String toHTML() {
        if (this.endOfLineCharState) {
            return String.valueOf(String.valueOf(new StringBuffer("<").append(this.tagContents.toString()).append(">").append(HTMLNode.lineSeparator)));
        }
        return String.valueOf(String.valueOf(new StringBuffer("<").append(this.tagContents.toString()).append(">")));
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("Begin Tag : ").append(this.tagContents.toString()).append("; begins at : ").append(this.elementBegin()).append("; ends at : ").append(this.elementEnd())));
    }

    public static void setTagParser(HTMLTagParser tagParser) {
        HTMLTag.tagParser = tagParser;
    }

    public boolean breaksFlow() {
        return mBreakTags.contains(this.getText().toUpperCase());
    }

    public void collectInto(Vector collectionVector, String filter) {
        if (this.thisScanner != null && this.thisScanner.getFilter() == filter) {
            collectionVector.add(this);
        }
    }

    public int getLine() {
        return this.nLine;
    }

    public void setAttribute(String _sName, String _sValue) {
        Hashtable hAttribute = this.getParsed();
        hAttribute.put(_sName.toUpperCase(), _sValue);
    }

    public void removeAttribute(String _sName) {
        if (_sName == null || _sName.trim().length() <= 0) {
            return;
        }
        String sName = _sName.trim().toUpperCase();
        if (sName.equals(TAGNAME)) {
            return;
        }
        Hashtable hAttribute = this.getParsed();
        hAttribute.remove(sName);
    }

    public String getAttributeValue(String _sName) {
        Hashtable hAttribute = this.getParsed();
        String sValue = (String)hAttribute.get(_sName.toUpperCase());
        return sValue;
    }

    public String toStrictHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(String.valueOf(new StringBuffer("<").append(this.getTagName()).append(" "))));
        int i = 0;
        Enumeration e = this.parsed.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ++i;
            if (key == TAGNAME) continue;
            String value = this.getParameter(key);
            sb.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(key))).append("=\"").append(value).append("\""))));
            if (i >= this.parsed.size()) continue;
            sb.append(" ");
        }
        sb.append(">");
        return sb.toString();
    }

    static {
        TAGNAME = TAGNAME;
        TAG_BEFORE_PARSING_STATE = 1;
        TAG_BEGIN_PARSING_STATE = 2;
        TAG_FINISHED_PARSING_STATE = 3;
        TAG_ILLEGAL_STATE = 4;
        TAG_IGNORE_DATA_STATE = 5;
        TAG_IGNORE_BEGIN_TAG_STATE = 6;
        encounteredQuery = false;
        strictTags = null;
        paramParser = new HTMLParameterParser();
        mBreakTags = new HashSet(30);
        mBreakTags.add("BLOCKQUOTE");
        mBreakTags.add("BODY");
        mBreakTags.add("BR");
        mBreakTags.add("CENTER");
        mBreakTags.add("DD");
        mBreakTags.add("DIR");
        mBreakTags.add("DIV");
        mBreakTags.add("DL");
        mBreakTags.add("DT");
        mBreakTags.add("FORM");
        mBreakTags.add("H1");
        mBreakTags.add("H2");
        mBreakTags.add("H3");
        mBreakTags.add("H4");
        mBreakTags.add("H5");
        mBreakTags.add("H6");
        mBreakTags.add("HEAD");
        mBreakTags.add("HR");
        mBreakTags.add("HTML");
        mBreakTags.add("ISINDEX");
        mBreakTags.add("LI");
        mBreakTags.add("MENU");
        mBreakTags.add("NOFRAMES");
        mBreakTags.add("OL");
        mBreakTags.add("P");
        mBreakTags.add("PRE");
        mBreakTags.add("TD");
        mBreakTags.add("TH");
        mBreakTags.add("TITLE");
        mBreakTags.add("UL");
    }
}

