/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Enumeration;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.tags.HTMLFrameTag;
import org.htmlparser.tags.HTMLTag;

public class HTMLFrameSetTag
extends HTMLTag {
    protected String frameURL;
    protected String frameName;
    protected Vector frames;

    public HTMLFrameSetTag(int frameSetBegin, int frameSetEnd, String frameSetContents, String tagLine, Vector frames) {
        super(frameSetBegin, frameSetEnd, frameSetContents, tagLine);
        this.frameURL = this.frameURL;
        this.frameName = this.frameName;
        this.frames = frames;
    }

    public HTMLFrameSetTag(int frameSetBegin, int frameSetEnd, String frameSetContents, String tagLine, Vector frames, int _nLine) {
        super(frameSetBegin, frameSetEnd, frameSetContents, tagLine, _nLine);
        this.frameURL = this.frameURL;
        this.frameName = this.frameName;
        this.frames = frames;
    }

    public String getFrameLocation() {
        return this.frameURL;
    }

    public String getFrameName() {
        return this.frameName;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("FRAME TAG : Image at ").append(this.frameURL).append("; begins at : ").append(this.elementBegin()).append("; ends at : ").append(this.elementEnd())));
    }

    public Vector getFrames() {
        return this.frames;
    }

    public HTMLFrameTag getFrame(String frameName) {
        boolean found = false;
        HTMLFrameTag frameTag = null;
        Enumeration e = this.frames.elements();
        while (e.hasMoreElements() && !found) {
            frameTag = (HTMLFrameTag)e.nextElement();
            if (!frameTag.getFrameName().toUpperCase().equals(frameName.toUpperCase())) continue;
            found = true;
        }
        if (found) {
            return frameTag;
        }
        return null;
    }

    public void setFrames(Vector frames) {
        this.frames = frames;
    }

    public String toHTML() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toHTML());
        HTMLNode node = null;
        HTMLFrameSetTag prevNode = this;
        Enumeration e = this.frames.elements();
        while (e.hasMoreElements()) {
            node = (HTMLNode)e.nextElement();
            if (prevNode.elementEnd() > node.elementBegin()) {
                sb.append(HTMLNode.lineSeparator);
            }
            sb.append(node.toHTML());
        }
        if (node != null && node.elementEnd() > this.elementEnd()) {
            sb.append(HTMLNode.lineSeparator);
        }
        sb.append("</FRAMESET>");
        return sb.toString();
    }
}

