/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.tags.HTMLInputTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.tags.HTMLTextareaTag;

public class HTMLFormTag
extends HTMLTag {
    public static final String POST = "POST";
    public static final String GET = "GET";
    protected String formURL;
    protected String formName;
    protected String formMethod;
    protected Vector formInputVector;
    protected Vector allNodesVector;
    private Vector textAreaVector;

    public HTMLFormTag(String formURL, String formName, String formMethod, int formBegin, int formEnd, String tagLine, Vector formInputVector, Vector textAreaVector, Vector allNodesVector) {
        super(formBegin, formEnd, "", tagLine);
        this.formURL = formURL;
        this.formName = formName;
        this.formMethod = formMethod;
        this.formInputVector = formInputVector;
        this.allNodesVector = allNodesVector;
        this.textAreaVector = textAreaVector;
    }

    public HTMLFormTag(String formURL, String formName, String formMethod, int formBegin, int formEnd, String tagLine, Vector formInputVector, Vector textAreaVector, Vector allNodesVector, int _nLine) {
        super(formBegin, formEnd, "", tagLine, _nLine);
        this.formURL = formURL;
        this.formName = formName;
        this.formMethod = formMethod;
        this.formInputVector = formInputVector;
        this.allNodesVector = allNodesVector;
        this.textAreaVector = textAreaVector;
    }

    public Vector getFormInputs() {
        return this.formInputVector;
    }

    public String getFormLocation() {
        return this.formURL;
    }

    public String getFormMethod() {
        if (this.formMethod == null) {
            this.formMethod = GET;
        }
        return this.formMethod;
    }

    public HTMLInputTag getInputTag(String name) {
        HTMLInputTag inputTag = null;
        boolean found = false;
        Enumeration e = this.formInputVector.elements();
        while (e.hasMoreElements() && !found) {
            inputTag = (HTMLInputTag)e.nextElement();
            String inputTagName = inputTag.getParameter("NAME");
            if (inputTagName == null || !inputTagName.equals(name)) continue;
            found = true;
        }
        if (found) {
            return inputTag;
        }
        return null;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormInputs(Vector formInputVector) {
        this.formInputVector = formInputVector;
    }

    public void setFormLocation(String formURL) {
        this.formURL = formURL;
    }

    public void setFormMethod(String formMethod) {
        this.formMethod = formMethod;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("FORM TAG : Form at ").append(this.formURL).append("; begins at : ").append(this.elementBegin()).append("; ends at : ").append(this.elementEnd())));
    }

    public Vector getAllNodesVector() {
        return this.allNodesVector;
    }

    public void setAllNodesVector(Vector allNodesVector) {
        this.allNodesVector = allNodesVector;
    }

    public String toHTML() {
        StringBuffer rawBuffer = new StringBuffer();
        HTMLNode prevNode = null;
        rawBuffer.append(String.valueOf(String.valueOf(new StringBuffer("<FORM METHOD=\"").append(this.formMethod).append("\" ACTION=\"").append(this.formURL).append("\""))));
        if (this.formName != null && this.formName.length() > 0) {
            rawBuffer.append(String.valueOf(String.valueOf(new StringBuffer(" NAME=\"").append(this.formName).append("\""))));
        }
        Enumeration e = this.allNodesVector.elements();
        HTMLNode node = (HTMLNode)e.nextElement();
        HTMLTag tag = (HTMLTag)node;
        Hashtable table = tag.getParsed();
        Enumeration en = table.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (key.equals("METHOD") || key.equals("ACTION") || key.equals("NAME") || key.equals("$<TAGNAME>$")) continue;
            String value = (String)table.get(key);
            rawBuffer.append(String.valueOf(String.valueOf(new StringBuffer(" ").append(key).append("=").append("\"").append(value).append("\""))));
        }
        rawBuffer.append(">");
        rawBuffer.append(HTMLNode.lineSeparator);
        while (e.hasMoreElements()) {
            node = (HTMLNode)e.nextElement();
            if (prevNode != null && prevNode.elementEnd() > node.elementBegin()) {
                rawBuffer.append(HTMLNode.lineSeparator);
            }
            rawBuffer.append(node.toHTML());
            prevNode = node;
        }
        return rawBuffer.toString();
    }

    public String toPlainTextString() {
        StringBuffer stringRepresentation = new StringBuffer();
        Enumeration e = this.getAllNodesVector().elements();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            stringRepresentation.append(node.toPlainTextString());
        }
        return stringRepresentation.toString();
    }

    public void collectInto(Vector collectionVector, String filter) {
        super.collectInto(collectionVector, filter);
        Enumeration e = this.allNodesVector.elements();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            node.collectInto(collectionVector, filter);
        }
    }

    public HTMLTextareaTag getTextAreaTag(String name) {
        HTMLTextareaTag textareaTag = null;
        boolean found = false;
        Enumeration e = this.textAreaVector.elements();
        while (e.hasMoreElements() && !found) {
            textareaTag = (HTMLTextareaTag)e.nextElement();
            String textAreaName = textareaTag.getParameter("NAME");
            if (textAreaName == null || !textAreaName.equals(name)) continue;
            found = true;
        }
        if (found) {
            return textareaTag;
        }
        return null;
    }

    public Vector searchFor(String searchString) {
        return this.searchFor(searchString, false);
    }

    public Vector searchFor(String searchString, boolean caseSensitive) {
        Vector<HTMLNode> foundVector = new Vector<HTMLNode>();
        if (!caseSensitive) {
            searchString = searchString.toUpperCase();
        }
        Enumeration e = this.allNodesVector.elements();
        while (e.hasMoreElements()) {
            HTMLNode node = (HTMLNode)e.nextElement();
            String nodeTextString = node.toPlainTextString();
            if (!caseSensitive) {
                nodeTextString = nodeTextString.toUpperCase();
            }
            if (nodeTextString.indexOf(searchString) == -1) continue;
            foundVector.addElement(node);
        }
        return foundVector;
    }

    public HTMLTag searchByName(String name) {
        HTMLTag tag = null;
        boolean found = false;
        Enumeration e = this.allNodesVector.elements();
        while (e.hasMoreElements() && !found) {
            String nameAttribute;
            HTMLNode node = (HTMLNode)e.nextElement();
            if (!(node instanceof HTMLTag) || (nameAttribute = (tag = (HTMLTag)node).getParameter("NAME")) == null || !nameAttribute.equals(name)) continue;
            found = true;
        }
        if (found) {
            return tag;
        }
        return null;
    }

    static {
        POST = POST;
        GET = GET;
    }
}

