/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.HTMLStringNode;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.tags.HTMLTitleTag;
import org.htmlparser.util.HTMLParserException;

public class HTMLTitleScanner
extends HTMLTagScanner {
    public HTMLTitleScanner(String filter) {
        super(filter);
    }

    public boolean evaluate(String s, HTMLTagScanner previousOpenScanner) {
        HTMLTagScanner.absorbLeadingBlanks(s);
        return s.toUpperCase().equals("TITLE") && previousOpenScanner == null;
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currLine) throws HTMLParserException {
        try {
            HTMLTitleTag titleTag;
            HTMLNode node;
            boolean endFlag = false;
            String title = "";
            HTMLEndTag endTag = null;
            Vector<HTMLNode> titleTagChildren = new Vector<HTMLNode>();
            do {
                if ((node = reader.readElement()) instanceof HTMLStringNode) {
                    title = ((HTMLStringNode)node).getText();
                }
                if (node instanceof HTMLEndTag) {
                    endTag = (HTMLEndTag)node;
                    String tmp = endTag.getText();
                    if (tmp.toUpperCase().equals("TITLE")) {
                        endFlag = true;
                        continue;
                    }
                    titleTagChildren.addElement(node);
                    continue;
                }
                titleTagChildren.addElement(node);
            } while (!endFlag && node != null);
            if (node == null && !endFlag) {
                throw new HTMLParserException(String.valueOf(String.valueOf(new StringBuffer("HTMLTitleScanner.scan(): Error while scanning title tag, went into a potential infinite loop, currentLine = ").append(currLine).append(", title so far = ").append(title))));
            }
            HTMLTitleTag hTMLTitleTag = titleTag = new HTMLTitleTag(tag.elementBegin(), endTag.elementEnd(), title, titleTagChildren, tag.getText(), tag.getTagLine(), tag.getLine());
            return hTMLTitleTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLTitleTagScanner.scan() : Error in scanning TitleTag, currentLine = ".concat(String.valueOf(String.valueOf(currLine))), e);
        }
    }

    public String[] getID() {
        String[] ids = new String[]{"TITLE"};
        return ids;
    }
}

