/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Hashtable;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLScriptTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;

public class HTMLScriptScanner
extends HTMLTagScanner {
    private String language;
    private String type;

    public HTMLScriptScanner() {
    }

    public HTMLScriptScanner(String filter) {
        super(filter);
    }

    public void extractLanguage(HTMLTag tag) {
        this.language = tag.getParameter("LANGUAGE");
        if (this.language == null) {
            this.language = "";
        }
    }

    public void extractType(HTMLTag tag) {
        this.type = tag.getParameter("TYPE");
        if (this.type == null) {
            this.type = "";
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getType() {
        return this.type;
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currentLine) throws HTMLParserException {
        try {
            this.extractLanguage(tag);
            this.extractType(tag);
            HTMLEndTag endTag = null;
            HTMLNode node = null;
            boolean endScriptFound = false;
            StringBuffer buff = new StringBuffer();
            Hashtable tempScanners = reader.getParser().getScanners();
            reader.getParser().flushScanners();
            HTMLNode prevNode = tag;
            do {
                if ((node = reader.readElement()) == null) {
                    endScriptFound = true;
                    break;
                }
                if (node instanceof HTMLEndTag) {
                    endTag = (HTMLEndTag)node;
                    if (!endTag.getText().toUpperCase().equals("SCRIPT")) continue;
                    endScriptFound = true;
                    continue;
                }
                if (prevNode != null && prevNode.elementEnd() > node.elementBegin()) {
                    buff.append(HTMLNode.getLineSeparator());
                }
                buff.append(node.toHTML());
                prevNode = node;
            } while (!endScriptFound && node != null);
            if (node == null && !endScriptFound) {
                throw new HTMLParserException(String.valueOf(String.valueOf(new StringBuffer("HTMLScriptScanner.scan() : Went into a potential infinite loop, could not create script tag.\nbuff contents so far ").append(buff.toString()).append(", currentLine= ").append(currentLine))));
            }
            HTMLScriptTag scriptTag = null;
            if (node != null) {
                scriptTag = new HTMLScriptTag(0, node.elementEnd(), tag.getText(), buff.toString(), this.language, this.type, currentLine, tag.getLine());
                reader.getParser().setScanners(tempScanners);
            } else {
                scriptTag = new HTMLScriptTag(0, tag.elementEnd(), tag.getText(), buff.toString(), this.language, this.type, currentLine, tag.getLine());
                reader.getParser().setScanners(tempScanners);
            }
            HTMLScriptTag hTMLScriptTag = scriptTag;
            return hTMLScriptTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLScriptScanner.scan() : Error while scanning a script tag, currentLine = ".concat(String.valueOf(String.valueOf(currentLine))), e);
        }
    }

    public void setLanguage(String newLanguage) {
        this.language = newLanguage;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String[] getID() {
        String[] ids = new String[]{"SCRIPT"};
        return ids;
    }
}

