/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Hashtable;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;
import org.htmlparser.HTMLStringNode;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLEndTag;
import org.htmlparser.tags.HTMLOptionTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLParserException;
import org.htmlparser.util.HTMLParserUtils;

public class HTMLOptionTagScanner
extends HTMLTagScanner {
    public HTMLOptionTagScanner() {
    }

    public HTMLOptionTagScanner(String pFilter) {
        super(pFilter);
    }

    public HTMLTag scan(HTMLTag pTag, String pUrl, HTMLReader pReader, String pCurrLine) throws HTMLParserException {
        try {
            HTMLEndTag lEndTag = null;
            HTMLNode lNode = null;
            HTMLNode lPrevNode = pTag;
            boolean endTagFound = false;
            StringBuffer lText = new StringBuffer("");
            Hashtable tempScanners = HTMLParserUtils.adjustScanners(pReader);
            do {
                if ((lNode = pReader.readElement()) instanceof HTMLEndTag) {
                    lEndTag = (HTMLEndTag)lNode;
                    String lEndTagString = lEndTag.getText().toUpperCase();
                    if (lEndTagString.equals("OPTION") || lEndTagString.equals("SELECT")) {
                        endTagFound = true;
                        if (lEndTagString.equals("SELECT")) {
                            lNode = lPrevNode;
                        }
                    }
                } else if (lNode instanceof HTMLStringNode) {
                    lText.append(lNode.toHTML());
                } else {
                    endTagFound = true;
                    lNode = lPrevNode;
                }
                lPrevNode = lNode;
            } while (!endTagFound);
            HTMLOptionTag lOptionTag = new HTMLOptionTag(0, lNode.elementEnd(), pTag.getText(), lText.toString(), pCurrLine, pTag.getLine());
            HTMLParserUtils.restoreScanners(pReader, tempScanners);
            HTMLOptionTag hTMLOptionTag = lOptionTag;
            return hTMLOptionTag;
        }
        catch (Exception e) {
            throw new HTMLParserException("HTMLOptionTagScanner.scan() : Error while scanning option tags, current line = ".concat(String.valueOf(String.valueOf(pCurrLine))), e);
        }
    }

    public String[] getID() {
        String[] ids = new String[]{"OPTION"};
        return ids;
    }
}

