/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import org.htmlparser.HTMLReader;
import org.htmlparser.scanners.HTMLTagScanner;
import org.htmlparser.tags.HTMLBaseHREFTag;
import org.htmlparser.tags.HTMLTag;
import org.htmlparser.util.HTMLLinkProcessor;
import org.htmlparser.util.HTMLParserException;

public class HTMLBaseHREFScanner
extends HTMLTagScanner {
    private HTMLLinkProcessor processor;

    public HTMLBaseHREFScanner() {
    }

    public HTMLBaseHREFScanner(String filter, HTMLLinkProcessor processor) {
        super(filter);
        this.processor = processor;
    }

    public HTMLTag scan(HTMLTag tag, String url, HTMLReader reader, String currLine) throws HTMLParserException {
        String baseUrl = tag.getParameter("HREF");
        String absoluteBaseUrl = "";
        if (baseUrl != null && baseUrl.length() > 0) {
            absoluteBaseUrl = this.removeLastSlash(baseUrl.trim());
            this.processor.setBaseUrl(absoluteBaseUrl);
        }
        return new HTMLBaseHREFTag(tag.elementBegin(), tag.elementEnd(), tag.getText(), absoluteBaseUrl, currLine, tag.getLine());
    }

    public String removeLastSlash(String baseUrl) {
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    public String[] getID() {
        String[] ids = new String[]{"BASE"};
        return ids;
    }
}

