/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications;

import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLParser;
import org.htmlparser.tags.HTMLLinkTag;
import org.htmlparser.util.HTMLEnumeration;
import org.htmlparser.util.HTMLParserException;

public class LinkExtractor {
    private String location;
    private HTMLParser parser;

    public LinkExtractor(String location) {
        this.location = location;
        try {
            this.parser = new HTMLParser(location);
            this.parser.registerScanners();
        }
        catch (HTMLParserException e) {
            e.printStackTrace();
        }
    }

    public void extractLinks() throws HTMLParserException {
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Parsing ").append(this.location).append(" for links..."))));
        HTMLEnumeration e = this.parser.elements();
        while (e.hasMoreNodes()) {
            HTMLNode node = e.nextHTMLNode();
            if (!(node instanceof HTMLLinkTag)) continue;
            HTMLLinkTag linkTag = (HTMLLinkTag)node;
            linkTag.print();
        }
    }

    public static void main(String[] args) {
        if (args.length < 0) {
            System.err.println("Syntax Error : Please provide the location(URL or file) to parse");
            System.exit(-1);
        }
        LinkExtractor linkExtractor = new LinkExtractor(args[0]);
        try {
            linkExtractor.extractLinks();
        }
        catch (HTMLParserException e) {
            e.printStackTrace();
        }
    }
}

