/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.util.Vector;
import org.htmlparser.HTMLNode;
import org.htmlparser.HTMLReader;

public class HTMLRemarkNode
extends HTMLNode {
    public static final String REMARK_NODE_FILTER = "-r";
    public static final int REMARK_NODE_BEFORE_PARSING_STATE = 0;
    public static final int REMARK_NODE_OPENING_ANGLE_BRACKET_STATE = 1;
    public static final int REMARK_NODE_EXCLAMATION_RECEIVED_STATE = 2;
    public static final int REMARK_NODE_FIRST_DASH_RECEIVED_STATE = 3;
    public static final int REMARK_NODE_ACCEPTING_STATE = 4;
    public static final int REMARK_NODE_CLOSING_FIRST_DASH_RECEIVED_STATE = 5;
    public static final int REMARK_NODE_CLOSING_SECOND_DASH_RECEIVED_STATE = 6;
    public static final int REMARK_NODE_ACCEPTED_STATE = 7;
    public static final int REMARK_NODE_ILLEGAL_STATE = 8;
    public static final int REMARK_NODE_FINISHED_PARSING_STATE = 2;
    String tagContents;
    int nLine;

    public HTMLRemarkNode(int tagBegin, int tagEnd, String tagContents) {
        super(tagBegin, tagEnd);
        this.tagContents = tagContents;
        this.nLine = -1;
    }

    public HTMLRemarkNode(int tagBegin, int tagEnd, String tagContents, int _nLine) {
        super(tagBegin, tagEnd);
        this.tagContents = tagContents;
        this.nLine = _nLine;
    }

    public static HTMLRemarkNode find(HTMLReader reader, String input, int position) {
        return HTMLRemarkNode.find(reader, input, position, reader.getLineCount() - 1);
    }

    public static HTMLRemarkNode find(HTMLReader reader, String input, int position, int _nLine) {
        int state = 0;
        StringBuffer tagContents = new StringBuffer();
        int tagBegin = 0;
        int tagEnd = 0;
        int inputLen = input.length();
        char prevChar = ' ';
        for (int i = position; i < inputLen && state < 7; ++i) {
            char ch = input.charAt(i);
            if (state == 6) {
                if (ch == '>') {
                    state = 7;
                    tagEnd = i;
                } else if (ch == '-') {
                    tagContents.append(prevChar);
                } else {
                    state = 4;
                    tagContents.append(prevChar);
                    tagContents.append(prevChar);
                }
            }
            if (state == 5) {
                if (ch == '-') {
                    state = 6;
                } else {
                    state = 4;
                    tagContents.append(prevChar);
                }
            }
            if (state == 4 && ch == '-') {
                state = 5;
            }
            if (state == 4) {
                tagContents.append(ch);
            }
            if (state == 3) {
                if (ch == '-') {
                    state = 4;
                    if (input.length() > i + 1 && input.charAt(i + 1) == '>') {
                        state = 7;
                        tagEnd = i + 1;
                    }
                } else {
                    state = 8;
                }
            }
            if (state == 2) {
                state = ch == '-' ? 3 : 8;
            }
            if (state == 1) {
                state = ch == '!' ? 2 : 8;
            }
            if (state == 0) {
                if (ch == '<') {
                    tagBegin = i;
                    state = 1;
                } else if (ch != ' ') {
                    state = 8;
                }
            }
            if (state >= 4 && state < 7 && i == input.length() - 1) {
                tagContents.append(HTMLNode.lineSeparator);
                while ((input = reader.getNextLine()) != null && input.length() == 0) {
                }
                inputLen = input != null ? input.length() : -1;
                i = -1;
            }
            if (state == 8) {
                return null;
            }
            prevChar = ch;
        }
        if (state == 7) {
            return new HTMLRemarkNode(tagBegin, tagEnd, tagContents.toString(), _nLine);
        }
        return null;
    }

    public int getLine() {
        return this.nLine;
    }

    public String getText() {
        return this.tagContents;
    }

    public String toPlainTextString() {
        return this.tagContents;
    }

    public String toHTML() {
        return String.valueOf(String.valueOf(new StringBuffer("<!--").append(this.tagContents.toString()).append("-->")));
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("Comment Tag : ").append(this.tagContents.toString()).append("; begins at : ").append(this.elementBegin()).append("; ends at : ").append(this.elementEnd()).append("\n")));
    }

    public void collectInto(Vector collectionVector, String filter) {
        if (filter == REMARK_NODE_FILTER) {
            collectionVector.add(this);
        }
    }

    static {
        REMARK_NODE_FILTER = REMARK_NODE_FILTER;
        REMARK_NODE_BEFORE_PARSING_STATE = 0;
        REMARK_NODE_OPENING_ANGLE_BRACKET_STATE = 1;
        REMARK_NODE_EXCLAMATION_RECEIVED_STATE = 2;
        REMARK_NODE_FIRST_DASH_RECEIVED_STATE = 3;
        REMARK_NODE_ACCEPTING_STATE = 4;
        REMARK_NODE_CLOSING_FIRST_DASH_RECEIVED_STATE = 5;
        REMARK_NODE_CLOSING_SECOND_DASH_RECEIVED_STATE = 6;
        REMARK_NODE_ACCEPTED_STATE = 7;
        REMARK_NODE_ILLEGAL_STATE = 8;
        REMARK_NODE_FINISHED_PARSING_STATE = 2;
    }
}

