/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.navigation;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.DebugTimer;
import com.trs.presentation.common.PageViewConstants;
import java.util.ArrayList;
import java.util.Hashtable;

public class TreeItem {
    private String m_sName;
    private String m_sId;
    private int m_nDepth;
    private String m_sToolTip;
    private String m_sHref;
    private TreeItem m_oParentItem;
    private boolean m_bHasChildren;
    private ArrayList m_arChildren;
    private int m_nIndex;
    private int m_nTreeIndex;
    public boolean m_bOpened = false;
    public int m_nType = 0;
    public boolean m_bChecked;
    public static Hashtable m_hTreeRes = new Hashtable(20);

    public TreeItem(int _nTreeId, String _sName, String _sId, String _sToolTip, String _sHref, TreeItem _oParentItem, boolean _bHasChildren) {
        this.m_nTreeIndex = _nTreeId;
        this.m_sName = _sName;
        this.m_sId = _sId;
        this.m_sToolTip = _sToolTip;
        this.m_sHref = _sHref;
        this.m_oParentItem = _oParentItem;
        this.m_bHasChildren = _bHasChildren;
        if (this.m_oParentItem != null) {
            this.m_oParentItem.addChild(this);
            this.m_nDepth = this.m_oParentItem.m_nDepth + 1;
            this.m_nIndex = this.m_oParentItem.m_arChildren.size() - 1;
        } else {
            this.m_nDepth = 0;
        }
    }

    public void addChild(TreeItem _oChildItem) {
        if (this.m_arChildren == null) {
            this.m_arChildren = new ArrayList();
        }
        this.m_arChildren.add(_oChildItem);
    }

    public void clear() {
        if (this.m_arChildren != null) {
            for (int i = 0; i < this.m_arChildren.size(); ++i) {
                ((TreeItem)this.m_arChildren.get(i)).clear();
            }
            this.m_arChildren.clear();
        }
        this.m_arChildren = null;
        this.m_oParentItem = null;
    }

    public boolean isLast() {
        if (this.m_oParentItem == null) {
            return false;
        }
        return this.m_nIndex == this.m_oParentItem.m_arChildren.size() - 1;
    }

    private String getItemSpanId() {
        return "i_Span" + this.m_nTreeIndex + "_" + this.m_sId;
    }

    private String getNodeFlagImgName() {
        return "j_img" + this.m_nTreeIndex + "_" + this.m_sId;
    }

    private String getNodeImgHTML() {
        int nMaxBufferSize = this.m_nDepth * 120 + 200;
        StringBuffer sbOffset = new StringBuffer(nMaxBufferSize);
        TreeItem oTRSItemTemp = this.m_oParentItem;
        String sTemp = "";
        for (int i = this.m_nDepth; i > 0; --i) {
            sTemp = oTRSItemTemp.isLast() ? "icon_e" : "icon_l";
            sbOffset.append("<img src=\"" + m_hTreeRes.get(sTemp) + "\" border=0 align=absbottom>");
            oTRSItemTemp = oTRSItemTemp.m_oParentItem;
        }
        if (!this.m_bHasChildren) {
            sbOffset.append("<img src=\"" + this.getIcon(true) + "\" border=0 align=absbottom>");
        }
        sbOffset.append("<a href='javascript:m_arTRSTrees[" + this.m_nTreeIndex + "].open(\"" + this.m_sId + "\");'  ><img src=\"" + this.getIcon(true) + "\" border=0 align=absbottom name=\"" + this.getNodeFlagImgName() + "\"></a>");
        return sbOffset.toString();
    }

    private String getIcon(boolean b_junction) {
        return (String)m_hTreeRes.get("icon_" + ((this.m_nDepth > 0 ? 0 : 32) + (this.m_bHasChildren ? 16 : 0) + (this.m_bHasChildren && this.m_bOpened ? 8 : 0) + (!b_junction ? 4 : 0) + (b_junction ? 2 : 0) + (b_junction && this.isLast() ? 1 : 0)));
    }

    private String getIcon() {
        return this.getIcon(false);
    }

    private String getItemDivId() {
        return "i_div" + this.m_nTreeIndex + "_" + this.m_sId;
    }

    private String getTypeHTML() {
        if (this.m_nType == 0 || this.m_nDepth <= 0) {
            return "";
        }
        if (this.m_nType == 1) {
            return "<input type=checkbox name=\"TRSTreeNode\" value=\"" + this.m_sId + "\" " + (this.m_bChecked ? "checked" : "") + " onclick='m_arTRSTrees[" + this.m_nTreeIndex + "].onClickCheckBox(this);'>";
        }
        if (this.m_nType == 2) {
            return "<input type=radio name=\"TRSTreeNode\" value=\"" + this.m_sId + "\" " + (this.m_bChecked ? "checked" : "") + " onclick='m_arTRSTrees[" + this.m_nTreeIndex + "].onClickRadio(this);'>";
        }
        return "";
    }

    private String getPublicEventHTML() {
        return "onmouseover='m_arTRSTrees[" + this.m_nTreeIndex + "].onMouseOver(\"" + this.m_sId + "\");' onmouseout='m_arTRSTrees[" + this.m_nTreeIndex + "].onMouseOut(\"" + this.m_sId + "\");'";
    }

    public String toHTML() {
        String sChildrenHTML = "";
        if (this.m_arChildren != null) {
            sChildrenHTML = sChildrenHTML + "\n";
            for (int i = 0; i < this.m_arChildren.size(); ++i) {
                sChildrenHTML = sChildrenHTML + ((TreeItem)this.m_arChildren.get(i)).toHTML();
            }
            sChildrenHTML = sChildrenHTML + "\n";
        }
        String sHtml = "<span id=\"" + this.getItemSpanId() + "\"><table cellpadding=0 cellspacing=0 border=0><tr><td nowrap>" + this.getNodeImgHTML() + "<img src=\"" + this.getIcon() + "\" border=0 align=absbottom name=i_img" + this.m_nTreeIndex + "_" + this.m_sId + "\" class=\"t" + this.m_nTreeIndex + "im\">" + this.getTypeHTML() + (this.m_sHref == null || this.m_sHref.length() == 0 ? "<a onclick=\"return false;\">" : "<a href=\"" + this.m_sHref + "\" target=\"" + m_hTreeRes.get("target") + "\"  onclick='return m_arTRSTrees[" + this.m_nTreeIndex + "].select(\"" + this.m_sId + "\");' ondblclick='m_arTRSTrees[" + this.m_nTreeIndex + "].open(\"" + this.m_sId + "\");' " + this.getPublicEventHTML() + " class=\"t" + this.m_nTreeIndex + "i\" id=\"i_txt" + this.m_nTreeIndex + "_" + this.m_sId + "\">") + this.m_sName + "</a></td></tr></table>\n" + (this.m_bHasChildren ? "<div id=\"" + this.getItemDivId() + "\" style=\"display:" + (this.m_bOpened ? "inline" : "none") + "\">" + sChildrenHTML + "</div>" : "") + "</span>";
        return sHtml;
    }

    public static String getRootHref(int _nSiteId, int _nOperType) throws WCMException {
        return PageViewConstants.getOperRootURL(_nOperType) + "?SiteId=" + _nSiteId;
    }

    public static String getNodeHref(int _nChannelId, int _nOperType) throws WCMException {
        return PageViewConstants.getOperRootURL(_nOperType) + "?ChannelId=" + _nChannelId;
    }

    public static void main(String[] args) {
        DebugTimer currTimer = new DebugTimer();
        currTimer.start();
        for (int i = 0; i < 1; ++i) {
            try {
                TreeItem aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label1", "WCM\u6f14\u793a\u7ad9\u70b9"), "S2", I18NMessage.get(TreeItem.class, "TreeItem.label2", "\u7ad9\u70b9[WCM\u6f14\u793a\u7ad9\u70b9]"), TreeItem.getRootHref(2, 1), null, true);
                aRootItem.m_bOpened = true;
                TreeItem aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label3", "\u6bcf\u65e5\u8981\u95fb"), "62", I18NMessage.get(TreeItem.class, "TreeItem.label4", "\u9891\u9053[\u6bcf\u65e5\u8981\u95fb]"), TreeItem.getNodeHref(62, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label5", "\u6eda\u52a8\u65b0\u95fb"), "32", I18NMessage.get(TreeItem.class, "TreeItem.label6", "\u9891\u9053[\u6eda\u52a8\u65b0\u95fb]"), TreeItem.getNodeHref(32, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label7", "\u6587\u7ae0\u63a8\u8350"), "66", I18NMessage.get(TreeItem.class, "TreeItem.label8", "\u9891\u9053[\u6587\u7ae0\u63a8\u8350]"), TreeItem.getNodeHref(66, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label9", "\u7f51\u4e0a\u516c\u544a"), "64", I18NMessage.get(TreeItem.class, "TreeItem.label10", "\u9891\u9053[\u7f51\u4e0a\u516c\u544a]"), TreeItem.getNodeHref(64, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label11", "\u65b0\u95fb\u4e2d\u5fc3"), "31", I18NMessage.get(TreeItem.class, "TreeItem.label12", "\u9891\u9053[\u65b0\u95fb\u4e2d\u5fc3]"), TreeItem.getNodeHref(31, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label13", "\u653f\u52a1\u5927\u5385"), "33", I18NMessage.get(TreeItem.class, "TreeItem.label14", "\u9891\u9053[\u653f\u52a1\u5927\u5385]"), TreeItem.getNodeHref(33, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label15", "\u6f14\u793a\u8bf4\u660e"), "63", I18NMessage.get(TreeItem.class, "TreeItem.label16", "\u9891\u9053[\u6f14\u793a\u8bf4\u660e]"), TreeItem.getNodeHref(63, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label17", "\u53cb\u60c5\u94fe\u63a5"), "67", I18NMessage.get(TreeItem.class, "TreeItem.label18", "\u9891\u9053[\u53cb\u60c5\u94fe\u63a5]"), TreeItem.getNodeHref(67, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label19", "\u7f51\u4e0a\u8c03\u67e5"), "34", I18NMessage.get(TreeItem.class, "TreeItem.label20", "\u9891\u9053[\u7f51\u4e0a\u8c03\u67e5]"), TreeItem.getNodeHref(34, 1), aRootItem, true);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label21", "\u97e9\u5578\u6d4b\u8bd5"), "S3", I18NMessage.get(TreeItem.class, "TreeItem.label22", "\u7ad9\u70b9[\u97e9\u5578\u6d4b\u8bd5]"), TreeItem.getRootHref(3, 1), null, true);
                aRootItem.m_bOpened = true;
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label23", "\u6d4b\u8bd5Channel"), "175", I18NMessage.get(TreeItem.class, "TreeItem.label24", "\u9891\u9053[\u6d4b\u8bd5Channel]"), TreeItem.getNodeHref(175, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label25", "\u6587\u6863\u5907\u4efd\u6d4b\u8bd5"), "134", I18NMessage.get(TreeItem.class, "TreeItem.label26", "\u9891\u9053[\u6587\u6863\u5907\u4efd\u6d4b\u8bd5]"), TreeItem.getNodeHref(134, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label27", "\u7248\u672c\u6d4b\u8bd5"), "120", I18NMessage.get(TreeItem.class, "TreeItem.label28", "\u9891\u9053[\u7248\u672c\u6d4b\u8bd5]"), TreeItem.getNodeHref(120, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label29", "\u6d4b\u8bd5Document"), "110", I18NMessage.get(TreeItem.class, "TreeItem.label30", "\u9891\u9053[\u6d4b\u8bd5Document]"), TreeItem.getNodeHref(110, 1), aRootItem, true);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label31", "\u66f9\u8f89\u6d4b\u8bd5"), "S4", I18NMessage.get(TreeItem.class, "TreeItem.label32", "\u7ad9\u70b9[\u66f9\u8f89\u6d4b\u8bd5]"), TreeItem.getRootHref(4, 1), null, true);
                aRootItem.m_bOpened = true;
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label33", "\u4e0d\u80fd\u5220\u9664\u7684\u680f\u76ee3"), "141", I18NMessage.get(TreeItem.class, "TreeItem.label34", "\u9891\u9053[\u4e0d\u80fd\u5220\u9664\u7684\u680f\u76ee3]"), TreeItem.getNodeHref(141, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label35", "\u4e0d\u80fd\u5220\u9664\u7684\u680f\u76ee2"), "140", I18NMessage.get(TreeItem.class, "TreeItem.label36", "\u9891\u9053[\u4e0d\u80fd\u5220\u9664\u7684\u680f\u76ee2]"), TreeItem.getNodeHref(140, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label37", "\u4e0d\u80fd\u5220\u9664\u7684\u680f\u76ee"), "139", I18NMessage.get(TreeItem.class, "TreeItem.label38", "\u9891\u9053[\u4e0d\u80fd\u5220\u9664\u7684\u680f\u76ee]"), TreeItem.getNodeHref(139, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label39", "\u6d4b\u8bd5\u5bfc\u5165"), "113", I18NMessage.get(TreeItem.class, "TreeItem.label40", "\u9891\u9053[\u6d4b\u8bd5\u5bfc\u5165]"), TreeItem.getNodeHref(113, 1), aRootItem, true);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label41", "\u6e29\u4e1a\u8f89\u6d4b\u8bd5"), "S5", I18NMessage.get(TreeItem.class, "TreeItem.label42", "\u7ad9\u70b9[\u6e29\u4e1a\u8f89\u6d4b\u8bd5]"), TreeItem.getRootHref(5, 1), null, true);
                aRootItem.m_bOpened = true;
                aItem = new TreeItem(0, "test", "172", I18NMessage.get(TreeItem.class, "TreeItem.label43", "\u9891\u9053[test]"), TreeItem.getNodeHref(172, 1), aRootItem, true);
                aItem = new TreeItem(0, "restore", "170", I18NMessage.get(TreeItem.class, "TreeItem.label44", "\u9891\u9053[restore]"), TreeItem.getNodeHref(170, 1), aRootItem, true);
                aItem = new TreeItem(0, "delch", "155", I18NMessage.get(TreeItem.class, "TreeItem.label45", "\u9891\u9053[delch]"), TreeItem.getNodeHref(155, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label46", "\u83b7\u53d6\u6a21\u677f\u6d4b\u8bd5"), "137", I18NMessage.get(TreeItem.class, "TreeItem.label47", "\u9891\u9053[\u83b7\u53d6\u6a21\u677f\u6d4b\u8bd5]"), TreeItem.getNodeHref(137, 1), aRootItem, true);
                aItem = new TreeItem(0, "delDoc", "133", I18NMessage.get(TreeItem.class, "TreeItem.label48", "\u9891\u9053[delDoc]"), TreeItem.getNodeHref(133, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label49", "\u65b0\u7a3f\u53d1\u5e03"), "131", I18NMessage.get(TreeItem.class, "TreeItem.label50", "\u9891\u9053[\u65b0\u7a3f\u53d1\u5e03]"), TreeItem.getNodeHref(131, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label51", "\u8de8\u7ad9\u70b9\u76f8\u5173\u6587\u6863\u6d4b\u8bd5"), "129", I18NMessage.get(TreeItem.class, "TreeItem.label52", "\u9891\u9053[\u8de8\u7ad9\u70b9\u76f8\u5173\u6587\u6863\u6d4b\u8bd5]"), TreeItem.getNodeHref(129, 1), aRootItem, true);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label53", "\u83b7\u53d6\u6d4b\u8bd5"), "S9", I18NMessage.get(TreeItem.class, "TreeItem.label54", "\u7ad9\u70b9[\u83b7\u53d6\u6d4b\u8bd5]"), TreeItem.getRootHref(9, 1), null, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label55", "\u83b7\u53d6\u63a5\u53e3\u6d4b\u8bd5"), "159", I18NMessage.get(TreeItem.class, "TreeItem.label56", "\u9891\u9053[\u83b7\u53d6\u63a5\u53e3\u6d4b\u8bd5]"), TreeItem.getNodeHref(159, 1), aRootItem, true);
                aItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label57", "\u9891\u9053\u6587\u6863\u7684\u83b7\u53d6\u6d4b\u8bd5"), "158", I18NMessage.get(TreeItem.class, "TreeItem.label58", "\u9891\u9053[\u9891\u9053\u6587\u6863\u7684\u83b7\u53d6\u6d4b\u8bd5]"), TreeItem.getNodeHref(158, 1), aRootItem, true);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, "moveChannelFrom", "S16", I18NMessage.get(TreeItem.class, "TreeItem.label59", "\u7ad9\u70b9[moveChannelFrom]"), TreeItem.getRootHref(16, 1), null, true);
                aRootItem.m_bOpened = true;
                aItem = new TreeItem(0, "moveFrom", "241", I18NMessage.get(TreeItem.class, "TreeItem.label60", "\u9891\u9053[moveFrom]"), TreeItem.getNodeHref(241, 1), aRootItem, true);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, "moveChannelTo", "S17", I18NMessage.get(TreeItem.class, "TreeItem.label61", "\u7ad9\u70b9[moveChannelTo]"), TreeItem.getRootHref(17, 1), null, true);
                aRootItem.m_bOpened = true;
                aItem = new TreeItem(0, "moveTo", "242", I18NMessage.get(TreeItem.class, "TreeItem.label62", "\u9891\u9053[moveTo]"), TreeItem.getNodeHref(242, 1), aRootItem, true);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label63", "\u65b0\u5efa\u7ad9\u70b920041210221518"), "S58", I18NMessage.get(TreeItem.class, "TreeItem.label64", "\u7ad9\u70b9[\u65b0\u5efa\u7ad9\u70b920041210221518]"), TreeItem.getRootHref(58, 1), null, false);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label65", "\u65b0\u5efa\u7ad9\u70b920041211090403"), "S59", I18NMessage.get(TreeItem.class, "TreeItem.label66", "\u7ad9\u70b9[\u65b0\u5efa\u7ad9\u70b920041211090403]"), TreeItem.getRootHref(59, 1), null, false);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label67", "\u65b0\u5efa\u7ad9\u70b920041211120749"), "S60", I18NMessage.get(TreeItem.class, "TreeItem.label68", "\u7ad9\u70b9[\u65b0\u5efa\u7ad9\u70b920041211120749]"), TreeItem.getRootHref(60, 1), null, false);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label69", "\u65b0\u5efa\u7ad9\u70b920041211172311"), "S61", I18NMessage.get(TreeItem.class, "TreeItem.label70", "\u7ad9\u70b9[\u65b0\u5efa\u7ad9\u70b920041211172311]"), TreeItem.getRootHref(61, 1), null, false);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label71", "\u65b0\u5efa\u7ad9\u70b920041212090330"), "S62", I18NMessage.get(TreeItem.class, "TreeItem.label72", "\u7ad9\u70b9[\u65b0\u5efa\u7ad9\u70b920041212090330]"), TreeItem.getRootHref(62, 1), null, false);
                System.out.println(aRootItem.toHTML());
                aRootItem = new TreeItem(0, I18NMessage.get(TreeItem.class, "TreeItem.label73", "\u65b0\u5efa\u7ad9\u70b920041212120819"), "S63", I18NMessage.get(TreeItem.class, "TreeItem.label74", "\u7ad9\u70b9[\u65b0\u5efa\u7ad9\u70b920041212120819]"), TreeItem.getRootHref(63, 1), null, false);
                System.out.println(aRootItem.toHTML());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        currTimer.stop();
        System.out.println(I18NMessage.get(TreeItem.class, "TreeItem.label75", "\u6784\u90202000\u4e2a\u8282\u70b9\u6240\u7528\u65f6\u95f4\u4e3a[") + currTimer.getTime() + I18NMessage.get(TreeItem.class, "TreeItem.label76", "]\u6beb\u79d2"));
    }

    static {
        m_hTreeRes.put("target", "main");
        m_hTreeRes.put("icon_e", "../images/trstree_empty.gif");
        m_hTreeRes.put("icon_l", "../images/trstree_line.gif");
        m_hTreeRes.put("icon_32", "../images/trstree_base.gif");
        m_hTreeRes.put("icon_36", "../images/trstree_base.gif");
        m_hTreeRes.put("icon_48", "../images/trstree_base.gif");
        m_hTreeRes.put("icon_52", "../images/trstree_base.gif");
        m_hTreeRes.put("icon_56", "../images/trstree_base.gif");
        m_hTreeRes.put("icon_60", "../images/trstree_base.gif");
        m_hTreeRes.put("icon_16", "../images/trstree_folder.gif");
        m_hTreeRes.put("icon_20", "../images/trstree_folderopen.gif");
        m_hTreeRes.put("icon_24", "../images/trstree_folderopen.gif");
        m_hTreeRes.put("icon_28", "../images/trstree_folderopen.gif");
        m_hTreeRes.put("icon_0", "../images/trstree_page.gif");
        m_hTreeRes.put("icon_4", "../images/trstree_page.gif");
        m_hTreeRes.put("icon_2", "../images/trstree_joinbottom.gif");
        m_hTreeRes.put("icon_3", "../images/trstree_join.gif");
        m_hTreeRes.put("icon_18", "../images/trstree_plusbottom.gif");
        m_hTreeRes.put("icon_19", "../images/trstree_plus.gif");
        m_hTreeRes.put("icon_26", "../images/trstree_minusbottom.gif");
        m_hTreeRes.put("icon_27", "../images/trstree_minus.gif");
        m_hTreeRes.put("icon_34", "../images/trstree_joinbottom.gif");
        m_hTreeRes.put("icon_35", "../images/trstree_join.gif");
        m_hTreeRes.put("icon_50", "../images/trstree_plusbottom.gif");
        m_hTreeRes.put("icon_51", "../images/trstree_plus.gif");
        m_hTreeRes.put("icon_58", "../images/trstree_minusbottom.gif");
        m_hTreeRes.put("icon_59", "../images/trstree_minus.gif");
    }
}

