/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mlf.simplelog;

import com.trs.mlf.simplelog.LogBody;
import com.trs.mlf.simplelog.LogUser;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class SimpleLogServer {
    private static Logger logger = Logger.getLogger(SimpleLogServer.class);
    public static final String OPERATION_TYPE = "trslogoperation";
    public static final String RELEASE_TYPE = "trslogrelease";
    public static final String DISTRIBUTE_TYPE = "trslogdistribute";
    public static final String SECURITY_TYPE = "trslogsecurity";
    public static final String SYSTEM_TYPE = "trslogsystem";
    public static final String ELAPSE_TYPE = "trslogelapse";
    public static final String INFO_LEVEL = "INFO";
    public static final String DEBUG_LEVEL = "DEBUG";
    public static final String WARN_LEVEL = "WARN";
    public static final String ERROR_LEVEL = "ERROR";
    private static final String ENDPOINT_FOR_LOG = " @@ ";

    private static LogBody init(LogUser user) {
        LogBody newLogBody = new LogBody();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (user == null) {
            user = new LogUser();
        }
        newLogBody.setLogUser(user.getName());
        newLogBody.setTrueName(user.getTrueName());
        newLogBody.setLogUserIP(user.getLoginIP());
        newLogBody.setLogTime(dateFormat.format(new Date()));
        newLogBody.setClassInfo(SimpleLogServer.getCallMeInfo(4));
        newLogBody.setLogUserGroup(user.getGroupNames());
        return newLogBody;
    }

    public static void operation(String moduleName, LogUser user, String operType, String logDesc, String objName) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setOperateType(operType);
        logBody.setLogDesc(logDesc);
        logBody.setObjName(objName);
        logBody.setModule(OPERATION_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.info(logBody);
    }

    public static void release(String moduleName, LogUser user, int useTime, String taskTitle, String taskStatus) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setTimeUsed(useTime >= 0 ? "\u6267\u884c\u8017\u65f6[" + useTime + "]ms" : "");
        logBody.setTaskTitle(taskTitle);
        logBody.setTaskStatus(taskStatus);
        logBody.setModule(RELEASE_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.info(logBody);
    }

    public static void distribute(String moduleName, LogUser user, String objName, String desc) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setObjName(objName);
        logBody.setLogDesc(desc);
        logBody.setModule(DISTRIBUTE_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.info(logBody);
    }

    public static void security(String moduleName, LogUser user, String loginResult) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setLogResult(loginResult);
        logBody.setModule(SECURITY_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.info(logBody);
    }

    public static void security(String moduleName, LogUser user, String loginResult, String loginIp) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setLogResult(loginResult);
        logBody.setModule(SECURITY_TYPE);
        logBody.setLogUserIP(loginIp);
        logBody.setModuleName(moduleName);
        SimpleLogServer.info(logBody);
    }

    public static void error(String moduleName, LogUser user, String operation, String errorType, String desc, Throwable ex) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setOperateType(operation);
        logBody.setErrorType(errorType);
        logBody.setLogDesc(SimpleLogServer.getExceptionDetail(desc, ex));
        logBody.setModule(SYSTEM_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.error(logBody);
    }

    public static void warn(String moduleName, LogUser user, String operation, String warnType, String desc, Throwable e) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setOperateType(operation);
        logBody.setErrorType(warnType);
        logBody.setLogDesc(SimpleLogServer.getExceptionDetail(desc, e));
        logBody.setModule(SYSTEM_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.warn(logBody);
    }

    public static void warn(String moduleName, LogUser user, String operation, String warnType, String desc) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setOperateType(operation);
        logBody.setErrorType(warnType);
        logBody.setLogDesc(desc);
        logBody.setModule(SYSTEM_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.warn(logBody);
    }

    public static void debug(String moduleName, LogUser user, String operation, String debugType, String desc) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setOperateType(operation);
        logBody.setErrorType(debugType);
        logBody.setLogDesc(desc);
        logBody.setModule(SYSTEM_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.debug(logBody);
    }

    public static void info(String moduleName, LogUser user, String operation, String infoType, String desc) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setOperateType(operation);
        logBody.setErrorType(infoType);
        logBody.setLogDesc(desc);
        logBody.setModule(SYSTEM_TYPE);
        logBody.setModuleName(moduleName);
        SimpleLogServer.info(logBody);
    }

    public static void elapse(String moduleName, LogUser user, String operation, String desc, int timeUsed) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setOperateType(operation);
        logBody.setLogDesc(desc);
        logBody.setModule(ELAPSE_TYPE);
        logBody.setTimeUsed(String.valueOf(timeUsed));
        logBody.setModuleName(moduleName);
        SimpleLogServer.info(logBody);
    }

    public static void elapse(String moduleName, LogUser user, String operation, String desc, long timeUsed) {
        LogBody logBody = SimpleLogServer.init(user);
        logBody.setOperateType(operation);
        logBody.setLogDesc(desc);
        logBody.setModule(ELAPSE_TYPE);
        logBody.setTimeUsed(String.valueOf(timeUsed));
        logBody.setModuleName(moduleName);
        SimpleLogServer.info(logBody);
    }

    private static void info(LogBody logBody) {
        logBody.setLogLevel(INFO_LEVEL);
        logger.info((Object)(ENDPOINT_FOR_LOG + LogBody.toJsonString(logBody) + ENDPOINT_FOR_LOG));
    }

    private static void debug(LogBody logBody) {
        logBody.setLogLevel(DEBUG_LEVEL);
        logger.debug((Object)(ENDPOINT_FOR_LOG + LogBody.toJsonString(logBody) + ENDPOINT_FOR_LOG));
    }

    private static void warn(LogBody logBody) {
        logBody.setLogLevel(WARN_LEVEL);
        logger.warn((Object)(ENDPOINT_FOR_LOG + LogBody.toJsonString(logBody) + ENDPOINT_FOR_LOG));
    }

    private static void error(LogBody logBody) {
        logBody.setLogLevel(ERROR_LEVEL);
        logger.error((Object)(ENDPOINT_FOR_LOG + LogBody.toJsonString(logBody) + ENDPOINT_FOR_LOG));
    }

    private static String getCallMeInfo(int _nDepth) {
        int nDepth = _nDepth;
        StackTraceElement[] pStackTraceElements = new Throwable().getStackTrace();
        if (nDepth >= pStackTraceElements.length) {
            nDepth = pStackTraceElements.length - 1;
        }
        StackTraceElement oStackTraceElement = pStackTraceElements[nDepth];
        return oStackTraceElement.getClassName() + "." + oStackTraceElement.getMethodName() + "(" + oStackTraceElement.getFileName() + " " + oStackTraceElement.getLineNumber() + ")";
    }

    private static String getExceptionDetail(String desc, Throwable e) {
        StringBuilder stringBuilder = new StringBuilder(desc + "\n" + e.toString() + "\n");
        StackTraceElement[] messages = e.getStackTrace();
        int length = messages.length;
        for (StackTraceElement message : messages) {
            stringBuilder.append("\t" + message.toString() + "\n");
        }
        return stringBuilder.toString();
    }
}

