/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.Deflater;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected Deflater def;

    protected void deflate() throws IOException {
        int len;
        while (!this.def.needsInput() && (len = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, len);
        }
        if (!this.def.needsInput()) {
            throw new InternalError("Can't deflate all input?");
        }
    }

    public DeflaterOutputStream(OutputStream out) {
        this(out, new Deflater(), 512);
    }

    public DeflaterOutputStream(OutputStream out, Deflater defl) {
        this(out, defl, 512);
    }

    public DeflaterOutputStream(OutputStream out, Deflater defl, int bufsize) {
        super(out);
        if (bufsize <= 0) {
            throw new IllegalArgumentException("bufsize <= 0");
        }
        this.buf = new byte[bufsize];
        this.def = defl;
    }

    @Override
    public void flush() throws IOException {
        this.def.flush();
        this.deflate();
        this.out.flush();
    }

    public void finish() throws IOException {
        int len;
        this.def.finish();
        while (!this.def.finished() && (len = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, len);
        }
        if (!this.def.finished()) {
            throw new InternalError("Can't deflate all input?");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    @Override
    public void write(int bval) throws IOException {
        byte[] b = new byte[]{(byte)bval};
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.def.setInput(buf, off, len);
        this.deflate();
    }
}

