/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.XmlCharCheckedInputStream;
import com.trs.infra.util.store.FileService;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class CMyDOM4jHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element buildXmlFile(String _sXmlFile, String _sXslFile) throws WCMException {
        Document document = null;
        SAXReader reader = new SAXReader();
        InputStream checkedIns = null;
        InputStream fins = null;
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            fins = new FileService(_sXmlFile).getInputStream();
            checkedIns = new XmlCharCheckedInputStream(fins);
            document = reader.read(checkedIns);
        }
        catch (Exception e) {
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (checkedIns != null) {
                try {
                    checkedIns.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                String sEncoding = CharsetDetector.detect(_sXmlFile);
                fins = new FileService(_sXmlFile).getInputStream();
                checkedIns = new XmlCharCheckedInputStream(fins);
                reader.setEncoding(sEncoding);
                document = reader.read(checkedIns);
            }
            catch (Exception ex) {
                throw new WCMException(I18NMessage.get(CMyDOM4jHelper.class, "CMyDOM4jHelper.label1", "\u8bfb\u53d6XML\u6587\u4ef6[") + _sXmlFile + I18NMessage.get(CMyDOM4jHelper.class, "CMyDOM4jHelper.label2", "]\u5931\u8d25\uff01"), ex);
            }
        }
        finally {
            if (fins != null) {
                try {
                    fins.close();
                }
                catch (Exception e) {}
            }
            if (checkedIns != null) {
                try {
                    checkedIns.close();
                }
                catch (Exception e) {}
            }
        }
        if (_sXslFile == null || _sXslFile.length() == 0) {
            return document.getRootElement();
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(_sXslFile));
            DocumentSource source = new DocumentSource(document);
            DocumentResult result = new DocumentResult();
            transformer.transform((Source)source, (Result)result);
            document = result.getDocument();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(CMyDOM4jHelper.class, "CMyDOM4jHelper.label3", "\u5bf9XML\u6587\u4ef6[") + _sXmlFile + I18NMessage.get(CMyDOM4jHelper.class, "CMyDOM4jHelper.label4", "]\u8fdb\u884c\u8f6c\u6362[XSLT:") + _sXslFile + I18NMessage.get(CMyDOM4jHelper.class, "CMyDOM4jHelper.label2", "]\u5931\u8d25\uff01"));
        }
        return document.getRootElement();
    }

    public static void toXMLFile(Element _element, String _sXMLEncoding, String _sXMLFile, String _XSLFileName) throws WCMException {
        Document docXML = CMyDOM4jHelper.makeXMLDocument(_element, _XSLFileName);
        Writer fileWriter = null;
        OutputStream fs = null;
        try {
            fs = new FileService(_sXMLFile).getOutputStream();
            fileWriter = new OutputStreamWriter(fs, _sXMLEncoding);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(_sXMLEncoding);
            XMLWriter xmlWriter = new XMLWriter(fileWriter, format);
            xmlWriter.write(docXML);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(CMyDOM4jHelper.class, "CMyDOM4jHelper.label5", "\u751f\u6210XML\u6587\u4ef6\u65f6\u5931\u8d25!"), ex);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Document makeXMLDocument(Element _element, String _XSLFileName) throws TransformerFactoryConfigurationError, WCMException {
        Document document = DocumentHelper.createDocument();
        document.add(_element);
        if (_XSLFileName == null || _XSLFileName.length() == 0) {
            return document;
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(_XSLFileName));
            DocumentSource source = new DocumentSource(document);
            DocumentResult result = new DocumentResult();
            transformer.transform((Source)source, (Result)result);
            document = result.getDocument();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(CMyDOM4jHelper.class, "CMyDOM4jHelper.label6", "\u4f7f\u7528XSLT\u8f6c\u6362\u5931\u8d25!"));
        }
        return document;
    }
}

