/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.persistent.cache;

import com.trs.DreamFactory;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.cache.CacheLayer;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.cache.CachedObjectConfig;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyMemory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CachedPOMgr
implements ICachedPOMgr {
    private static final Logger logger = Logger.getLogger((String)CachedPOMgr.class.getName());
    private CachedObjectConfig[] m_arConfigs = null;
    private ArrayList m_lCachedIndex = null;
    private Cache cache = (Cache)DreamFactory.createObjectById("cache");

    @Override
    public synchronized boolean init() throws WCMException {
        if (this.cache.exists(this.getKey()).booleanValue()) {
            return true;
        }
        logger.info((Object)(I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label1", "\u542f\u52a8[\u5bf9\u8c61\u7f13\u51b2]\u524d\u7cfb\u7edf\u5185\u5b58:") + CMyMemory.toMemoryInfo()));
        int nBuffCount = this.getConfigs().length;
        this.cache.set(this.getKey(), "true");
        for (int i = 0; i < nBuffCount; ++i) {
            try {
                this.initBuffer(this.getConfigs()[i].getCachedObjectClass());
                logger.info((Object)(I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label2", "\u7f13\u51b2\u5bf9\u8c61[") + i + "][" + this.getConfigs()[i].getName() + I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label3", "]\u521d\u59cb\u5316\u5b8c\u6210\uff01")));
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)(I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label2", "\u7f13\u51b2\u5bf9\u8c61[") + i + "][" + this.getConfigs()[i].getName() + I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label4", "]\u521d\u59cb\u5316\u5931\u8d25\uff01")), (Throwable)ex);
            }
        }
        logger.info((Object)(I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label5", "\u542f\u52a8[\u5bf9\u8c61\u7f13\u51b2]\u540e\u7cfb\u7edf\u5185\u5b58:") + CMyMemory.toMemoryInfo()));
        return true;
    }

    @Override
    public BaseObj getObjFromBuffer(String _sClassName, int _objId) throws WCMException {
        return this.getObjFromBuffer(_sClassName, (Object)new Integer(_objId));
    }

    @Override
    public BaseObj getObjFromBuffer(Class _objClass, int _objId) throws WCMException {
        return this.getObjFromBuffer(_objClass.getName(), _objId);
    }

    @Override
    public BaseObj getObjFromBuffer(Class _objClass, Object _key) throws WCMException {
        return this.getObjFromBuffer(_objClass.getName(), _key);
    }

    @Override
    public void refreshCache(BaseObj obj) throws WCMException {
        String sClassName = obj.getClass().getName();
        int nIndex = this.getCacheIndex(sClassName);
        if (nIndex < 0) {
            return;
        }
        String sKey = this.getKey(sClassName);
        if (!this.cache.exists(sKey).booleanValue()) {
            this.initBuffer(this.getConfigs()[nIndex].getCachedObjectClass());
        }
        this.cache.hset(this.getKey(sClassName), obj.getId(), obj);
    }

    @Override
    public boolean isCached(Class _objClass) throws WCMException {
        return this.isCached(_objClass.getName());
    }

    @Override
    public boolean isCached(String _sClassName) throws WCMException {
        int nIndex = this.getCacheIndex(_sClassName);
        return nIndex >= 0;
    }

    private int getCacheIndex(String _sClassName) {
        CachedObjectConfig[] configs = this.getConfigs();
        for (int i = 0; i < configs.length; ++i) {
            if (!configs[i].getClassName().equals(_sClassName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.clearCacheIndex();
        this.clearConfig();
        this.clearBuffer();
    }

    private void clearCacheIndex() {
    }

    private void clearConfig() {
        if (this.m_arConfigs == null) {
            return;
        }
        logger.info((Object)I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label9", "\u6b63\u5728\u6e05\u7a7a\u7f13\u51b2\u5bf9\u8c61\u7684\u914d\u7f6e\u4fe1\u606f..."));
        for (int i = 0; i < this.m_arConfigs.length; ++i) {
            if (this.m_arConfigs[i] != null) continue;
        }
        this.m_arConfigs = null;
        logger.info((Object)I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label10", "\u6e05\u7a7a\u7f13\u51b2\u5bf9\u8c61\u7684\u914d\u7f6e\u4fe1\u606f\u5b8c\u6210\uff01"));
    }

    private void clearBuffer() {
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) {
        this.addCachedPO(_oObjAdded);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) {
        this.removeCachedPO(_oObjDeleted);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) {
        String sKey = this.getKey(_oObjModified.getClass());
        CacheLayer.disable(sKey);
        BaseObj baseObj = (BaseObj)this.cache.hget(sKey, _oObjModified.getKey());
        baseObj.setProperties(_oObjModified.getNewProperties());
        this.cache.hset(sKey, _oObjModified.getKey(), baseObj);
    }

    private Object getPojo(Class _objClass) throws WCMException {
        try {
            return _objClass.newInstance();
        }
        catch (Exception ex) {
            throw new WCMException(10, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label6", "\u5b9e\u4f8b\u5316\u7c7b[") + _objClass.getName() + I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label7", "]\u51fa\u73b0\u5f02\u5e38\uff01\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u6587\u4ef6"));
        }
    }

    private void initBuffer(Class _sClassName) throws WCMException {
        BaseObj obj = (BaseObj)this.getPojo(_sClassName);
        this.initBuffer(obj);
    }

    private void initBuffer(BaseObj _srcCachedPO) throws WCMException {
        Statement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        BaseObj aObj = null;
        Connection oConn = null;
        try {
            oConn = this.getDBManager().getConnection();
            Class<?> objClass = _srcCachedPO.getClass();
            String strSQL = "SELECT * FROM " + _srcCachedPO.getDbTableName() + " ORDER BY " + _srcCachedPO.getIdFieldName();
            oStmt = oConn.createStatement();
            rsData = oStmt.executeQuery(strSQL);
            rsmdData = null;
            int nCount = 0;
            while (rsData.next()) {
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                aObj = (BaseObj)objClass.newInstance();
                aObj.readFromRs(rsData, rsmdData);
                this.cache.hset(this.getKey(aObj.getClass()), aObj.getKey(), aObj);
                ++nCount;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u7f13\u5b58PO\u6570\u636e\u8868[" + _srcCachedPO.getDbTableName() + "],\u8bb0\u5f55\u6570\u4e3a:" + nCount));
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label8", "CachedPOMgr\u521d\u59cb\u5316\u7f13\u51b2\u533a\u51fa\u9519[") + _srcCachedPO.getDbTableName() + "." + _srcCachedPO.getIdFieldName() + "]", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label8", "CachedPOMgr\u521d\u59cb\u5316\u7f13\u51b2\u533a\u51fa\u9519[") + _srcCachedPO.getDbTableName() + "." + _srcCachedPO.getIdFieldName() + "]", ex);
        }
        finally {
            try {
                if (rsData != null) {
                    rsData.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (oStmt != null) {
                    oStmt.close();
                }
            }
            catch (Exception exception) {}
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    private void removeCachedPO(BaseObj _obj) {
        this.cache.hdel(this.getKey(_obj.getClass()), _obj);
    }

    private void addCachedPO(BaseObj _obj) {
        this.cache.hset(this.getKey(_obj.getClass()), _obj.getKey(), _obj);
    }

    private void loadConfigs() {
        if (this.m_arConfigs != null) {
            return;
        }
        List listConfigMgrs = XMLConfigServer.getInstance().getConfigObjects(CachedObjectConfig.class);
        this.m_arConfigs = listConfigMgrs == null || listConfigMgrs.size() == 0 ? new CachedObjectConfig[0] : CachedPOMgr.toCachedObjectConfigArray(listConfigMgrs);
    }

    public CachedObjectConfig[] getConfigs() {
        if (this.m_arConfigs == null) {
            this.loadConfigs();
        }
        return this.m_arConfigs;
    }

    protected DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label13", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(CachedPOMgr.class, "CachedPOMgr.label14", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        this.init();
        return true;
    }

    private static CachedObjectConfig[] toCachedObjectConfigArray(List cachedObjects) {
        if (cachedObjects == null || cachedObjects.size() == 0) {
            return null;
        }
        CachedObjectConfig[] result = new CachedObjectConfig[cachedObjects.size()];
        for (int i = 0; i < cachedObjects.size(); ++i) {
            result[i] = (CachedObjectConfig)cachedObjects.get(i);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("CachedObjectConfig:" + result[i].getClassName()));
        }
        return result;
    }

    private BaseObj getObjFromBuffer(String _sClassName, Object _objId) throws WCMException {
        int nIndex = this.getCacheIndex(_sClassName);
        if (nIndex < 0) {
            return null;
        }
        String sKey = this.getKey(_sClassName);
        if (!this.cache.exists(sKey).booleanValue()) {
            this.initBuffer(this.getConfigs()[nIndex].getCachedObjectClass());
        }
        return (BaseObj)this.cache.hget(this.getKey(_sClassName), _objId);
    }

    private String getKey() {
        return CachedPOMgr.class.getName();
    }

    private String getKey(Class clazz) {
        return this.getKey() + "." + clazz.getName();
    }

    private String getKey(String clazzName) {
        return this.getKey() + "." + clazzName;
    }
}

