/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.version.IObjSpecialHandler;
import com.trs.components.wcm.version.IObjectVersionMgr;
import com.trs.components.wcm.version.ObjAndConfigHandler;
import com.trs.components.wcm.version.ObjSpecialHandlerFactory;
import com.trs.components.wcm.version.ObjectVersion;
import com.trs.components.wcm.version.ObjectVersions;
import com.trs.components.wcm.version.config.ObjectVersionConfig;
import com.trs.components.wcm.version.parser.ObjectForElementConverter;
import com.trs.components.wcm.version.parser.ObjectForXmlCompleteConverter;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.ObjectTypesFinder;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.TableInfo;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ObjectVersionMgr
implements IObjectVersionMgr {
    @Override
    public void delete(ObjectVersion _oVersion) throws WCMException {
        if (_oVersion == null) {
            throw new WCMException(10, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label1", "\u5bf9\u8c61\u7248\u672c\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        String sXml = _oVersion.getVersionContent();
        try {
            Map<CMSObj, List<CMSObj>> hMap = ObjectForXmlCompleteConverter.parseXmlData(sXml);
            Iterator<CMSObj> iterator = hMap.keySet().iterator();
            CMSObj cMainCMSObj = null;
            if (iterator.hasNext()) {
                cMainCMSObj = iterator.next();
            }
            if (cMainCMSObj == null) {
                throw new WCMException(150, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label7", "\u5bf9\u8c61\u7248\u672cxml\u6570\u636e\u89e3\u6790\u5f02\u5e38"));
            }
            List<CMSObj> relationCMSObjs = hMap.get(cMainCMSObj);
            ObjSpecialHandlerFactory factory = ObjSpecialHandlerFactory.getNewInstance();
            IObjSpecialHandler specialHandler = factory.getSpecialHandler(cMainCMSObj.getClass());
            specialHandler.deleteSpecialField(cMainCMSObj, cMainCMSObj, _oVersion.getVersionNum());
            for (int i = 0; i < relationCMSObjs.size(); ++i) {
                CMSObj cRelationObj = relationCMSObjs.get(i);
                specialHandler = factory.getSpecialHandler(cRelationObj.getClass());
                specialHandler.deleteSpecialField(cRelationObj, cMainCMSObj, _oVersion.getVersionNum());
            }
        }
        catch (DocumentException e) {
            throw new WCMException(150, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label7", "\u5bf9\u8c61\u7248\u672cxml\u6570\u636e\u89e3\u6790\u5f02\u5e38"));
        }
        _oVersion.delete(this.getLoginUser());
    }

    @Override
    public ObjectVersions findObjectVersions(CMSObj _CMSObj2, WCMFilter _extraFilter) throws WCMException {
        if (_CMSObj2 == null) {
            throw new WCMException(10, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label2", "\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u627e\u5bf9\u8c61\u7248\u672c\u5217\u8868"));
        }
        if (!this.isAbleToBuildVersion(_CMSObj2)) {
            throw new WCMException(10, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label6", "\u8be5\u5bf9\u8c61\u6ca1\u6709\u5f00\u542f\u7248\u672c\u7ba1\u7406\u529f\u80fd"));
        }
        int wcmType = _CMSObj2.getWCMType();
        int objId = _CMSObj2.getId();
        String sWhere = "ObjectType=" + wcmType + " and ObjectId=" + objId;
        WCMFilter filter = new WCMFilter("", sWhere, "VersionNum,VersionDesc");
        filter.mergeWith(_extraFilter);
        return ObjectVersions.openWCMObjs(this.getLoginUser(), filter);
    }

    @Override
    public ObjectVersions findObjectVersions(CMSObj _CMSObj2) throws WCMException {
        return this.findObjectVersions(_CMSObj2, null);
    }

    @Override
    public void recover(ObjectVersion _oVersion) throws WCMException {
        if (_oVersion == null) {
            throw new WCMException(10, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label4", "\u5bf9\u8c61\u7248\u672c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5bf9\u8c61\u7248\u672c\u6062\u590d"));
        }
        String sXml = _oVersion.getVersionContent();
        try {
            Map<CMSObj, List<CMSObj>> hMap = ObjectForXmlCompleteConverter.parseXmlData(sXml);
            Iterator<CMSObj> iterator = hMap.keySet().iterator();
            CMSObj cMainCMSObj = null;
            if (iterator.hasNext()) {
                cMainCMSObj = iterator.next();
            }
            if (cMainCMSObj == null) {
                throw new WCMException(150, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label7", "\u5bf9\u8c61\u7248\u672cxml\u6570\u636e\u89e3\u6790\u5f02\u5e38"));
            }
            List<CMSObj> relationCMSObjs = hMap.get(cMainCMSObj);
            int mainObjId = cMainCMSObj.getPropertyAsInt(cMainCMSObj.getIdFieldName(), 0);
            CMSObj mainCMSObj = this.getCMSObjById(cMainCMSObj.getWCMType(), mainObjId);
            if (mainCMSObj == null) {
                throw new WCMException(150, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label8", "\u5bf9\u8c61\u7248\u672c\u6570\u636e\u5f02\u5e38\uff0c\u5bf9\u5e94\u7684\u5bf9\u8c61\u5df2\u4e0d\u5b58\u5728"));
            }
            this.setNewProperties(mainCMSObj, cMainCMSObj);
            ObjSpecialHandlerFactory factory = ObjSpecialHandlerFactory.getNewInstance();
            IObjSpecialHandler specialHandler = factory.getSpecialHandler(mainCMSObj.getClass());
            specialHandler.recoverSpecialField(mainCMSObj, mainCMSObj, _oVersion.getVersionNum());
            for (int i = 0; i < relationCMSObjs.size(); ++i) {
                CMSObj cRelationObj = relationCMSObjs.get(i);
                int relationObjId = cRelationObj.getPropertyAsInt(cRelationObj.getIdFieldName(), 0);
                specialHandler = factory.getSpecialHandler(cRelationObj.getClass());
                if (relationObjId == 0) {
                    specialHandler.recoverSpecialField(cRelationObj, mainCMSObj, _oVersion.getVersionNum());
                    continue;
                }
                CMSObj relationObj = this.getCMSObjById(cRelationObj.getWCMType(), relationObjId);
                if (relationObj == null) {
                    relationObj = cRelationObj;
                    relationObj.insert(this.getLoginUser());
                } else {
                    this.setNewProperties(relationObj, cRelationObj);
                    relationObj.update(ContextHelper.getLoginUser());
                }
                specialHandler.recoverSpecialField(relationObj, mainCMSObj, _oVersion.getVersionNum());
            }
            mainCMSObj.update(ContextHelper.getLoginUser());
        }
        catch (DocumentException e) {
            throw new WCMException(150, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label7", "\u5bf9\u8c61\u7248\u672cxml\u6570\u636e\u89e3\u6790\u5f02\u5e38"));
        }
    }

    @Override
    public ObjectVersion buildVersion(CMSObj _CMSObj2, String _sVersionDesc) throws WCMException {
        if (_CMSObj2 == null) {
            throw new WCMException(10, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label5", "\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u627e\u5bf9\u8c61\u7248\u672c\u5217\u8868"));
        }
        ObjectVersionConfig oConfig = this.getObjectVersionConfig(_CMSObj2);
        if (oConfig == null || !oConfig.isBuild()) {
            throw new WCMException(10, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label6", "\u8be5\u5bf9\u8c61\u6ca1\u6709\u5f00\u542f\u7248\u672c\u7ba1\u7406\u529f\u80fd"));
        }
        int newVersionNum = this.getNewVersionNum(_CMSObj2);
        ObjAndConfigHandler handler = ObjectForXmlCompleteConverter.parseObjData(_CMSObj2, oConfig);
        String sXMLData = handler.getXmlData();
        IObjSpecialHandler specialHandler = ObjSpecialHandlerFactory.getNewInstance().getSpecialHandler(_CMSObj2.getClass());
        specialHandler.parseSpecialField(_CMSObj2, _CMSObj2, newVersionNum);
        List<CMSObj> relationObjs = handler.getRelationObjs();
        for (int i = 0; i < relationObjs.size(); ++i) {
            CMSObj relationObj = relationObjs.get(i);
            specialHandler = ObjSpecialHandlerFactory.getNewInstance().getSpecialHandler(relationObjs.get(i).getClass());
            specialHandler.parseSpecialField(relationObj, _CMSObj2, newVersionNum);
        }
        ObjectVersion version = new ObjectVersion();
        version.setVersionNum(newVersionNum);
        version.setVersionContent(sXMLData);
        version.setObjectType(_CMSObj2.getWCMType());
        version.setObjectId(_CMSObj2.getId());
        if (CMyString.isEmpty(_sVersionDesc)) {
            _sVersionDesc = this.getLoginUser().getName() + "\u4fdd\u5b58\u7248\u672cv" + newVersionNum;
        }
        version.setVersionDesc(_sVersionDesc);
        version.insert(this.getLoginUser());
        this.deleteMaximumVersion(_CMSObj2);
        return version;
    }

    @Override
    public CMSObj getCMSObjFromVersion(ObjectVersion _version) throws WCMException {
        if (_version == null) {
            throw new WCMException(10, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label16", "\u5bf9\u8c61\u7248\u672c\u4fe1\u606f\u4e3a\u7a7a"));
        }
        int nWCMType = _version.getObjectType();
        Class classWCMObj = ObjectTypesFinder.findObjectClassByType(nWCMType);
        CMSObj cmsObj = (CMSObj)CMSObj.createNewInstance(classWCMObj);
        cmsObj.setId(_version.getObjectId());
        try {
            Document document = DocumentHelper.parseText((String)_version.getVersionContent());
            Element root = document.getRootElement();
            if (!root.attributeValue("TYPE").equals(cmsObj.getClass().getName())) {
                throw new WCMException(2, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label10", "xml\u6570\u636e\u4e0e\u8981\u8f6c\u6362\u7684\u5bf9\u8c61\u4e0d\u7b26"));
            }
            ObjectForElementConverter.parseElementToCMSObj(root, cmsObj);
        }
        catch (Exception e) {
            throw new WCMException("xml\u89e3\u6790\u5f02\u5e38", e);
        }
        return cmsObj;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private int getNewVersionNum(CMSObj _CMSObj2) throws WCMException {
        ObjectVersion objectVersion;
        int newVersionNum = 1;
        WCMFilter extraFilter = new WCMFilter("", "", "VERSIONNUM desc", "VERSIONNUM", 1);
        ObjectVersions objectVersions = this.findObjectVersions(_CMSObj2, extraFilter);
        if (!objectVersions.isEmpty() && (objectVersion = (ObjectVersion)objectVersions.getAt(0)) != null) {
            newVersionNum = objectVersion.getVersionNum() + 1;
        }
        return newVersionNum;
    }

    private boolean isAbleToBuildVersion(CMSObj _CMSObj2) throws WCMException {
        ObjectVersionConfig config = this.getObjectVersionConfig(_CMSObj2);
        return config != null && config.isBuild();
    }

    private ObjectVersionConfig getObjectVersionConfig(CMSObj _CMSObj2) throws WCMException {
        List list = XMLConfigServer.getInstance().getConfigObjects(ObjectVersionConfig.class);
        ObjectVersionConfig config2 = null;
        for (ObjectVersionConfig config2 : list) {
            if (config2 == null || !_CMSObj2.getClassName(true).equals(config2.getClassname())) continue;
            if (!config2.isValid()) {
                throw new WCMException(I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label8", "\u8be5\u5bf9\u8c61\u7248\u672c\u7ba1\u7406\u529f\u80fd\u914d\u7f6e\u9519\u8bef"));
            }
            return config2;
        }
        return null;
    }

    private CMSObj getCMSObjById(int _nObjType, int _nObjId) throws WCMException {
        CMSObj cmsObj;
        Class currClass = ObjectTypesFinder.findObjectClassByType(_nObjType);
        Method mFindById = null;
        try {
            mFindById = currClass.getMethod("findById", Integer.TYPE);
            cmsObj = (CMSObj)mFindById.invoke(null, _nObjId);
        }
        catch (Exception e) {
            cmsObj = null;
        }
        return cmsObj;
    }

    private void setNewProperties(CMSObj _cmsObj, CMSObj _parseObj) throws WCMException {
        if (_cmsObj == null) {
            return;
        }
        TableInfo tableInfo = DBManager.getDBManager().getTableInfo(_cmsObj.getDbTableName());
        Hashtable<String, Object> m_hProperties = _cmsObj.getAllProperty();
        Hashtable<String, Object> m_hTempProperties = new Hashtable<String, Object>();
        m_hTempProperties.putAll(m_hProperties);
        Enumeration enKeys = m_hTempProperties.keys();
        String sKey = null;
        Object objValue = null;
        while (enKeys.hasMoreElements()) {
            sKey = (String)enKeys.nextElement();
            if (sKey.equalsIgnoreCase(_cmsObj.getIdFieldName())) continue;
            DataType dataType = tableInfo.getFieldInfo(sKey).getDataType();
            NullValue nullValue = new NullValue(dataType.getType());
            if (dataType.getType() != 2005) {
                m_hTempProperties.put(sKey, nullValue);
                continue;
            }
            m_hTempProperties.put(sKey, "");
        }
        Hashtable<String, Object> m_hNewProperties = _parseObj.getAllProperty();
        Enumeration<String> enNewKeys = m_hNewProperties.keys();
        while (enNewKeys.hasMoreElements()) {
            String sNewKey = enNewKeys.nextElement();
            m_hTempProperties.put(sNewKey, m_hNewProperties.get(sNewKey));
        }
        _cmsObj.setNewProperties(m_hTempProperties);
    }

    private void deleteMaximumVersion(CMSObj _CMSObj2) throws WCMException {
        ObjectVersions objectVersions;
        if (_CMSObj2 == null) {
            throw new WCMException(10, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label17", "\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u627e\u5bf9\u8c61\u7248\u672c\u5217\u8868"));
        }
        ObjectVersionConfig oConfig = this.getObjectVersionConfig(_CMSObj2);
        if (oConfig == null) {
            throw new WCMException(11, I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label18", "\u65e0\u6cd5\u83b7\u53d6\u5230\u5f53\u524d\u5bf9\u8c61\u914d\u7f6e\u7248\u672c\u7ba1\u7406\u4fe1\u606f"));
        }
        int iMaximumVersion = oConfig.getMaximumVersion();
        if (iMaximumVersion <= 0) {
            iMaximumVersion = 100;
        }
        if ((objectVersions = this.findObjectVersions(_CMSObj2, new WCMFilter("", "", "versionnum desc", ""))) != null) {
            for (int i = objectVersions.size() - 1; i >= iMaximumVersion; --i) {
                ObjectVersion objectVersion = (ObjectVersion)objectVersions.getAt(i);
                if (objectVersion == null) continue;
                this.delete(objectVersion);
            }
        }
    }
}

