/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.AutoDocBakMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.DocumentSyn;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class AutoTransmitMgr {
    private static Logger m_oLogger = Logger.getLogger(AutoDocBakMgr.class);

    private User getLoginUser() throws WCMException {
        User user = ContextHelper.getLoginUser();
        if (user == null) {
            throw new WCMException(1001, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label1", "\u7528\u6237\u672a\u767b\u5f55\u6216\u767b\u5f55\u8d85\u65f6!"));
        }
        return user;
    }

    private void assertNotNull(BaseObj _baseObj) throws WCMException {
        if (_baseObj == null) {
            throw new WCMException(10, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label2", "\u65e0\u6548\u7684\u5bf9\u8c61[null],\u65e0\u6cd5\u5b8c\u6210\u64cd\u4f5c!"));
        }
    }

    public ChannelSyn save(ChannelSyn _currChnlSyn) throws WCMException {
        this.assertNotNull(_currChnlSyn);
        this.validate(_currChnlSyn);
        _currChnlSyn.save(this.getLoginUser());
        return _currChnlSyn;
    }

    public DocumentSyn saveDocumentSyn(DocumentSyn _currTransmittedDoc) throws WCMException {
        this.assertNotNull(_currTransmittedDoc);
        _currTransmittedDoc.save(this.getLoginUser());
        return _currTransmittedDoc;
    }

    public void delete(ChannelSyn _currChnlSyn) throws WCMException {
        if (_currChnlSyn == null) {
            return;
        }
        if (!_currChnlSyn.canEdit(this.getLoginUser())) {
            throw new WCMException(200006, CMyString.format(I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label3", "\u914d\u7f6e\u4fe1\u606f\u6682\u65f6\u88ab [{0}] \u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\u3002"), new String[]{this.getLoginUser().toString()}));
        }
        _currChnlSyn.delete(this.getLoginUser());
    }

    public void deleteDocumentSyn(DocumentSyn _currTransmittedDoc) throws WCMException {
        if (_currTransmittedDoc == null) {
            return;
        }
        if (!_currTransmittedDoc.canEdit(this.getLoginUser())) {
            throw new WCMException(200006, CMyString.format(I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label4", "TransmittedDoc\u5bf9\u8c61\u6682\u65f6\u88ab [{0}] \u9501\u5b9a\uff0c\u65e0\u6cd5\u5220\u9664\u3002"), new String[]{this.getLoginUser().toString()}));
        }
        _currTransmittedDoc.delete(this.getLoginUser());
    }

    public ChannelSyns getChannelSyns(Channel _currChannel, WCMFilter _filter) throws WCMException {
        return this.getChannelSyns(_currChannel, _filter, false);
    }

    public ChannelSyns getChannelSyns(Channel _currChannel, WCMFilter _filter, boolean _bChannelAsTarget) throws WCMException {
        this.assertNotNull(_currChannel);
        WCMFilter filter = new WCMFilter("", _bChannelAsTarget ? "ToChannel=?" : "SRCCHANNEL=?", "CHANNELSYNID desc");
        filter.addSearchValues(0, _currChannel.getId());
        filter.mergeWith(_filter);
        ChannelSyns currSyns = new ChannelSyns(this.getLoginUser());
        try {
            currSyns.open(filter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)ex.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label5", "\u83b7\u53d6\u9891\u9053\u7684\u6587\u6863\u81ea\u52a8\u5206\u53d1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!"), ex);
        }
        return currSyns;
    }

    public ChannelSyns getRelatedChannelSyns(Channel _currChannel, WCMFilter _filter) throws WCMException {
        this.assertNotNull(_currChannel);
        int nCurrChnlId = _currChannel.getId();
        WCMFilter filter = new WCMFilter("", "SRCCHANNEL=" + nCurrChnlId + " OR TOCHANNEL=" + nCurrChnlId, "CHANNELSYNID desc");
        filter.mergeWith(_filter);
        ChannelSyns currSyns = new ChannelSyns(this.getLoginUser());
        try {
            currSyns.open(filter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)ex.getStackTraceText());
            throw new WCMException(1100, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label5", "\u83b7\u53d6\u9891\u9053\u7684\u6587\u6863\u81ea\u52a8\u5206\u53d1\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!"), ex);
        }
        return currSyns;
    }

    private boolean validate(ChannelSyn _currChnlSyn) throws WCMException {
        this.assertNotNull(_currChnlSyn);
        return this.validate(_currChnlSyn.getSrcChannel(), _currChnlSyn.getToChannel());
    }

    private boolean validate(Channel _srcChannel, Channel _toChannel) throws WCMException {
        this.assertNotNull(_srcChannel);
        this.assertNotNull(_toChannel);
        if (_srcChannel == _toChannel) {
            throw new WCMException(10, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label6", "\u9891\u9053\u4e0d\u80fd\u5206\u53d1\u7ed9\u81ea\u5df1\uff01"));
        }
        ChannelSyns currChnlSyns = this.getChannelSyns(_toChannel, null);
        if (currChnlSyns == null || currChnlSyns.isEmpty()) {
            return true;
        }
        ChannelSyn aChnlSyn = null;
        Channel aChnl = null;
        for (int i = 0; i < currChnlSyns.size(); ++i) {
            aChnlSyn = (ChannelSyn)currChnlSyns.getAt(i);
            aChnl = aChnlSyn.getToChannel();
            if (aChnl == _srcChannel) {
                throw new WCMException(10, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label7", "\u64cd\u4f5c\u5931\u8d25\uff01\u6587\u6863\u81ea\u52a8\u5206\u53d1\u914d\u7f6e\u6709\u8bef\uff0c\u9891\u9053\u6784\u6210\u56de\u8def\uff01"));
            }
            this.validate(_srcChannel, aChnl);
        }
        return true;
    }

    private WCMFilter constructSynChannelsFilter(Channel _currChannel, String _sWhere, String _sSelect) throws WCMException {
        if (_currChannel == null) {
            throw new WCMException(10, I18NMessage.get(AutoTransmitMgr.class, "AutoTransmitMgr.label8", "\u5f53\u524d\u9891\u9053\u65e0\u6548,\u65e0\u6cd5\u53d6\u5f97\u7ed9\u5b83\u5206\u53d1\u6587\u6863\u7684\u9891\u9053"));
        }
        String sWhere = "WCMCHANNELSYN." + _sWhere + "=" + _currChannel.getId();
        String sSelect = _sSelect + " as " + "CHANNELID";
        return new WCMFilter("WCMCHANNELSYN", sWhere, "", sSelect);
    }

    public Channels getSynSrcChannels(Channel _currChannel) throws WCMException {
        WCMFilter aFilter = this.constructSynChannelsFilter(_currChannel, "ToChannel", "SrcChannel");
        return Channels.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }

    public Channels getSynToChannels(Channel _currChannel) throws WCMException {
        WCMFilter aFilter = this.constructSynChannelsFilter(_currChannel, "SrcChannel", "ToChannel");
        return Channels.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
    }
}

