/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import com.trs.cluster.ext.wcm.HttpProxy;
import com.trs.cluster.ext.wcm.MemberInfo;
import com.trs.infra.cluster.Member;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClusterProxyFilter
implements Filter {
    private static boolean m_zAllProxyed = false;
    private static boolean m_zProxyed = false;
    private static HttpProxy m_oProxy = new HttpProxy();

    public void destroy() {
        m_zProxyed = false;
        m_oProxy.clear();
        m_oProxy = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (m_zProxyed && m_zAllProxyed) {
            m_oProxy.proxy((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig conf) throws ServletException {
        String ignore = conf.getInitParameter("IgnoreHeaders");
        if (ignore != null && ignore.trim().length() == 0) {
            String[] temp = ignore.split(",");
            int len = temp.length;
            for (int i = len - 1; i >= 0; --i) {
                m_oProxy.addIgnoreHeader(temp[i]);
                temp[i] = null;
            }
        }
        int nBuffSize = 0;
        try {
            nBuffSize = Integer.parseInt(conf.getInitParameter("BufferSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nBuffSize > 0) {
            m_oProxy.setBuffSize(nBuffSize);
        }
    }

    static synchronized void setMasterProxy(Member masterMember) {
        MemberInfo info;
        if (masterMember != null && (info = (MemberInfo)masterMember.getAttribute("cluster.extra.MemberInfo")) != null) {
            m_oProxy.setHost(info.getHost());
            m_oProxy.setPort(info.getPort());
            m_zProxyed = true;
            return;
        }
        m_zProxyed = false;
    }

    static synchronized void setProxyAll(boolean enabled) {
        m_zAllProxyed = enabled;
    }

    static HttpProxy getProxy() {
        if (m_zProxyed) {
            return m_oProxy;
        }
        return null;
    }
}

