/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.view.controller.mission;

import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.bean.DbParams;
import com.trs.cis4.gateway.bean.FieldData;
import com.trs.cis4.gateway.view.controller.base.Simple_Form_Controller;
import com.trs.cis4.gateway.view.util.RDBSqlTypeCollection;
import com.trs.cis4.util.ExceptionUtil;
import com.trs.cis4.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

public class Source_Column_Set_Content_Controller
extends Simple_Form_Controller {
    private RDBSqlTypeCollection rdbSqlTypeCollection;

    public ModelAndView _onSubmit(HttpServletRequest request, HttpServletResponse response, Object formObj, BindException ex) throws Exception {
        AgentConfig agentConfig = (AgentConfig)formObj;
        String columnC = request.getParameter("expandColumn");
        String[] columns = columnC.split(";");
        String isAdd = request.getParameter("isAdd");
        if (isAdd != null && isAdd.equals("0")) {
            this.deleteColumn(request, agentConfig, columns);
        }
        if (isAdd != null && isAdd.equals("1")) {
            this.addMergeColumn(request, agentConfig, columnC, columns);
        }
        return new ModelAndView(this.getSelfView());
    }

    public Object _formBackingObject(HttpServletRequest request) throws Exception {
        AgentConfig agentConfig = this.getAgentConfig(request);
        DbParams dbParams = this.getDbParamByAgent(agentConfig);
        HttpSession session = request.getSession();
        this.requireFieldList(request, session, agentConfig, dbParams);
        String[] rdbType = this.getRdbSqlTypeCollection().getRDBSqlTypes(agentConfig.getRdbConfig().getRdb_type());
        request.setAttribute("types", (Object)rdbType);
        return agentConfig;
    }

    private void requireFieldList(HttpServletRequest request, HttpSession session, AgentConfig agentConfig, DbParams dbParams) throws ExceptionUtil {
        String tableOrViewChanged = (String)session.getAttribute("tableOrViewChanged");
        String rdbclientcharsetChanged = (String)session.getAttribute("rdbclientcharsetChanged");
        session.removeAttribute("rdbclientcharsetChanged");
        if (tableOrViewChanged != null && tableOrViewChanged.equals("true") || rdbclientcharsetChanged != null && rdbclientcharsetChanged.equals("true") || agentConfig.getField_list() == null || agentConfig.getField_list() != null && agentConfig.getField_list().size() < 1) {
            session.setAttribute("tableOrViewChanged", (Object)"true");
            if (agentConfig.getRdbConfig().isRdb_view()) {
                dbParams.setView(agentConfig.getRdbConfig().getRdb_vname());
                dbParams.setTable(agentConfig.getRdbConfig().getRdb_table());
                List<FieldData> viewColumn = new ArrayList<FieldData>();
                if (dbParams.getDbserver() != null && dbParams.getDbpassword() != null && dbParams.getDbuser() != null && dbParams.getView() != null && dbParams.getTable() != null) {
                    List<FieldData> viewColumn2 = super.getConfigLogic().getViewColumn(dbParams);
                    for (FieldData element : viewColumn2) {
                        if (element.getFieldData2() == null) continue;
                        element.getFieldData2().setField_name2("");
                    }
                    viewColumn = viewColumn2;
                }
                agentConfig.setField_list(viewColumn);
                session.removeAttribute("tableOrViewChanged");
                agentConfig.getExt_list().clear();
            } else {
                dbParams.setTable(agentConfig.getRdbConfig().getRdb_table());
                List<FieldData> tableColumn = new ArrayList<FieldData>();
                if (dbParams.getDbserver() != null && dbParams.getDbpassword() != null && dbParams.getDbuser() != null && dbParams.getTable() != null) {
                    List<FieldData> tableColumn2 = super.getConfigLogic().getTableColumn(dbParams);
                    for (FieldData element : tableColumn2) {
                        if (element.getFieldData2() == null) continue;
                        element.getFieldData2().setField_name2("");
                    }
                    tableColumn = tableColumn2;
                }
                agentConfig.setField_list(tableColumn);
                session.removeAttribute("tableOrViewChanged");
                agentConfig.getExt_list().clear();
            }
        }
    }

    private void addMergeColumn(HttpServletRequest request, AgentConfig agentConfig, String columnC, String[] columns) {
        int end;
        String fname;
        Pattern pattern;
        Matcher matcher;
        List<FieldData> field_list = agentConfig.getField_list();
        String spiltTag = "br";
        String _splitTag = request.getParameter("spiltTag");
        if (StringUtil.isNotEmpty((String)_splitTag)) {
            spiltTag = _splitTag;
        }
        int seq = 0;
        List<FieldData> ext_list = agentConfig.getExt_list();
        if (ext_list != null && ext_list.size() > 0 && (matcher = (pattern = Pattern.compile("((\\+[M|C]\\+)(\\d+)(\\+\\w*))")).matcher(fname = ext_list.get(ext_list.size() - 1).getField_name())).find()) {
            seq = Integer.parseInt(matcher.group(3)) + 1;
        }
        FieldData fieldData = new FieldData();
        int begin = columns[0].lastIndexOf("+");
        int n = end = columns[0].indexOf("_") == -1 ? columns[0].length() : columns[0].indexOf("_");
        if (begin != -1) {
            columns[0] = columns[0].substring(begin + 1, end);
        }
        fieldData.setField_name("+M+" + seq + "+" + columns[0]);
        fieldData.setAlias(columnC);
        fieldData.setField_use(true);
        for (FieldData data : field_list) {
            if (!data.getField_name().equalsIgnoreCase(columns[0].trim())) continue;
            fieldData.setField_type(data.getField_type());
            fieldData.setField_len(data.getField_len());
            try {
                fieldData.setFieldData2(data.getFieldData2().clone());
            }
            catch (CloneNotSupportedException e) {
                this.log.error((Object)e.getMessage());
            }
        }
        fieldData.getFieldData2().setField_name2("");
        fieldData.setExt_type(0);
        fieldData.setField_ext(spiltTag);
        if (ext_list != null) {
            ext_list.add(fieldData);
        }
    }

    private void deleteColumn(HttpServletRequest request, AgentConfig agentConfig, String[] columns) {
        List<FieldData> ext_list = agentConfig.getExt_list();
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            Iterator<FieldData> it = ext_list.iterator();
            while (it.hasNext()) {
                FieldData data = it.next();
                if (!data.getField_name().trim().equals(col.trim())) continue;
                it.remove();
                ext_list.remove(data);
            }
            ++n2;
        }
    }

    private DbParams getDbParamByAgent(AgentConfig agentConfig) {
        DbParams dbParams = new DbParams();
        if (agentConfig.getRdbConfig() != null) {
            String rdb_server = agentConfig.getRdbConfig().getRdb_server();
            String rdb_username = agentConfig.getRdbConfig().getRdb_username();
            String rdb_password = agentConfig.getRdbConfig().getRdb_password();
            int rdb_type = agentConfig.getRdbConfig().getRdb_type();
            String rdb_database = agentConfig.getRdbConfig().getRdb_database();
            if (rdb_server != null && rdb_username != null && rdb_password != null) {
                dbParams.setDbserver(rdb_server);
                dbParams.setDbuser(rdb_username);
                dbParams.setDbpassword(rdb_password);
                dbParams.setDbtype(rdb_type);
                dbParams.setDbdatabase(rdb_database);
                dbParams.setRdbClientCharset(agentConfig.getRdbConfig().getRdb_client_charset());
            }
        }
        return dbParams;
    }

    public RDBSqlTypeCollection getRdbSqlTypeCollection() {
        return this.rdbSqlTypeCollection;
    }

    public void setRdbSqlTypeCollection(RDBSqlTypeCollection rdbSqlTypeCollection) {
        this.rdbSqlTypeCollection = rdbSqlTypeCollection;
    }
}

