/*
 * Decompiled with CFR 0.152.
 */
package t4j.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import t4j.TBlogException;
import t4j.TBlogResponse;
import t4j.data.User;
import t4j.http.Response;
import t4j.org.json.JSONArray;
import t4j.org.json.JSONException;
import t4j.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMessage
extends TBlogResponse {
    private long id;
    private String text;
    private long sender_id;
    private long recipient_id;
    private Date created_at;
    private String sender_screen_name;
    private String recipient_screen_name;
    private User sender;
    private User recipient;

    public DirectMessage(JSONObject json) throws TBlogException {
        this.init(json);
    }

    public DirectMessage(Response res) throws TBlogException {
        this.init(res.asJSONObject());
    }

    private void init(JSONObject json) throws TBlogException {
        try {
            this.id = json.getInt("id");
            this.text = json.getString("text");
            this.sender_id = json.getLong("sender_id");
            this.recipient_id = json.getLong("recipient_id");
            this.created_at = DirectMessage.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
            this.sender_screen_name = json.getString("sender_screen_name");
            this.recipient_screen_name = json.getString("recipient_screen_name");
            this.sender = new User(json.getJSONObject("sender"));
            this.recipient = new User(json.getJSONObject("recipient"));
        }
        catch (JSONException e) {
            throw new TBlogException(e);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public long getSenderId() {
        return this.sender_id;
    }

    public void setSenderId(long sender_id) {
        this.sender_id = sender_id;
    }

    public long getRecipientId() {
        return this.recipient_id;
    }

    public void setRecipientId(long recipient_id) {
        this.recipient_id = recipient_id;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public void setCreatedAt(Date created_at) {
        this.created_at = created_at;
    }

    public String getSenderScreenName() {
        return this.sender_screen_name;
    }

    public void setSenderScreenName(String sender_screen_name) {
        this.sender_screen_name = sender_screen_name;
    }

    public String getRecipientScreenName() {
        return this.recipient_screen_name;
    }

    public void setRecipientScreenName(String recipient_screen_name) {
        this.recipient_screen_name = recipient_screen_name;
    }

    public User getSender() {
        return this.sender;
    }

    public void setSender(User sender) {
        this.sender = sender;
    }

    public User getRecipient() {
        return this.recipient;
    }

    public void setRecipient(User recipient) {
        this.recipient = recipient;
    }

    public static List<DirectMessage> createDirectMessageList(Response res) throws TBlogException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<DirectMessage> directMessages = new ArrayList<DirectMessage>(size);
            int i = 0;
            while (i < size) {
                directMessages.add(new DirectMessage(list.getJSONObject(i)));
                ++i;
            }
            return directMessages;
        }
        catch (JSONException jsone) {
            throw new TBlogException(jsone);
        }
        catch (TBlogException te) {
            throw te;
        }
    }
}

