/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.io.Serializable;
import org.springframework.aop.TargetSource;
import org.springframework.util.ObjectUtils;

public final class SingletonTargetSource
implements TargetSource,
Serializable {
    private final Object target;

    public SingletonTargetSource(Object target) {
        this.target = target;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public Object getTarget() {
        return this.target;
    }

    public void releaseTarget(Object o) {
    }

    public boolean isStatic() {
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingletonTargetSource)) {
            return false;
        }
        SingletonTargetSource otherTargetSource = (SingletonTargetSource)other;
        return ObjectUtils.nullSafeEquals((Object)this.target, (Object)otherTargetSource.target);
    }

    public String toString() {
        return "SingletonTargetSource: target=(" + this.target + ")";
    }
}

