/*
 * Decompiled with CFR 0.152.
 */
package com.trs.webframework.xmlserver;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import java.util.HashMap;

public class XMLConvertorFactory {
    private static HashMap s_mapConvertors = new HashMap(3);

    public static IXMLConvertor createConvertor(Class _objectClass) {
        Class currClass;
        for (currClass = _objectClass; currClass != Object.class; currClass = currClass.getSuperclass()) {
            IXMLConvertor convertor = (IXMLConvertor)s_mapConvertors.get(currClass.getName());
            if (convertor == null) continue;
            return convertor;
        }
        return (IXMLConvertor)s_mapConvertors.get(currClass.getName());
    }

    public static IXMLConvertor createConvertor(String _sObjectClassName) throws Exception {
        return XMLConvertorFactory.createConvertor(Class.forName(_sObjectClassName));
    }

    public static void registerConvertor(String _sConvertorClassName, String _sTargetClassName) throws Exception {
        IXMLConvertor convertor = null;
        try {
            Class<?> classConvertor = Class.forName(_sConvertorClassName);
            convertor = (IXMLConvertor)classConvertor.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CMyException(I18NMessage.get(XMLConvertorFactory.class, "XMLConvertorFactory.label1", "\u6307\u5b9a\u7684Class[") + _sConvertorClassName + I18NMessage.get(XMLConvertorFactory.class, "XMLConvertorFactory.label2", "]\u4e0d\u80fd\u627e\u5230\uff01"), e);
        }
        catch (InstantiationException e) {
            throw new CMyException(I18NMessage.get(XMLConvertorFactory.class, "XMLConvertorFactory.label3", "\u6307\u5b9a\u7684\u5bf9\u8c61[") + _sConvertorClassName + I18NMessage.get(XMLConvertorFactory.class, "XMLConvertorFactory.label4", "]\u4e0d\u80fd\u5b9e\u4f8b\u5316\uff01"), e);
        }
        XMLConvertorFactory.registerConvertor(convertor, _sTargetClassName);
    }

    public static void registerConvertor(IXMLConvertor convertor, String _sTargetClassName) {
        if (_sTargetClassName == null || (_sTargetClassName = _sTargetClassName.trim()).length() <= 0) {
            String[] pTargetClassName = convertor.registerTargetClassName();
            for (int i = 0; i < pTargetClassName.length; ++i) {
                s_mapConvertors.put(pTargetClassName[i], convertor);
            }
        } else {
            s_mapConvertors.put(_sTargetClassName, convertor);
        }
        s_mapConvertors.put(_sTargetClassName, convertor);
    }
}

