/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.old;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.wcm.old.WCMFormInfo;
import com.trs.wcm.old.WCMFormInfos;
import java.util.Enumeration;
import java.util.Hashtable;

public class WCMExcelData
extends Document {
    public static final int OBJ_TYPE = 612;
    public static final String DB_TABLE_NAME = "WCMEXCELDATA";
    public static final String DB_ID_NAME = "RECID";

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("DOCCHANNEL") == null) {
                throw new WCMException(1106, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label1", "\u5c5e\u6027\uff0d\u6240\u5c5e\u9891\u9053\uff08DOCCHANNEL\uff09\u6ca1\u6709\u8bbe\u7f6e(WCMExcel.isValid)"));
            }
            if (this.getProperty("FORMID") == null) {
                throw new WCMException(1106, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label2", "\u5c5e\u6027\uff0d\u6240\u5c5e\u8868\u5355FormId\u6ca1\u6709\u8bbe\u7f6e(WCMExcel.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(WCMExcel.isValid)"));
        }
        return true;
    }

    @Override
    public int getWCMType() {
        return 612;
    }

    @Override
    public int getChannelId() {
        return this.getPropertyAsInt("DOCCHANNEL", 0);
    }

    @Override
    public Channel getChannel() throws WCMException {
        int nChannelId = this.getChannelId();
        if (nChannelId == 0) {
            return null;
        }
        return Channel.findById(nChannelId);
    }

    @Override
    public boolean setChannel(int _channelId) throws WCMException {
        return this.setProperty("DOCCHANNEL", _channelId);
    }

    @Override
    public boolean setChannel(Channel _channel) throws WCMException {
        if (_channel == null || !_channel.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label4", "\u65e0\u6548\u7684\u9891\u9053\u5bf9\u8c61(WCMExcelData.setChannel)"));
        }
        return this.setChannel(_channel.getId());
    }

    public boolean setForm(int _formId) throws WCMException {
        return this.setProperty("FORMID", _formId);
    }

    public int getFormId() {
        return this.getPropertyAsInt("FORMID", 0);
    }

    public WCMFormInfo getForm() throws WCMException {
        int nFormId = this.getFormId();
        String sWhere = "WCMFORMINFOID=" + nFormId;
        WCMFormInfos aWCMFormInfos = new WCMFormInfos(User.getSystem());
        aWCMFormInfos.setMaxSize(1);
        try {
            aWCMFormInfos.open(new WCMFilter("", sWhere, ""));
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label5", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u4fe1\u606f\u5931\u8d25\uff01"), ex);
        }
        if (aWCMFormInfos.isEmpty()) {
            return null;
        }
        WCMFormInfo aWCMFormInfo = (WCMFormInfo)aWCMFormInfos.getAt(0);
        return aWCMFormInfo;
    }

    public void setPropertyByDocument(Document _doc) throws WCMException {
        Hashtable<String, Object> hDocData = _doc.getAllProperty();
        Enumeration<String> e = hDocData.keys();
        while (e.hasMoreElements()) {
            String sFieldName = e.nextElement();
            if (this.getDBManager().getFieldInfo(this.getDbTableName(), sFieldName) == null) continue;
            this.setProperty(sFieldName, hDocData.get(sFieldName));
        }
    }

    public Document getDocument() throws WCMException {
        if (this.getProperty("DOCID") == null) {
            return null;
        }
        Object currDoc = null;
        try {
            Documents currDocuments = new Documents(User.getSystem(), 1, 1);
            currDocuments.setMaxBufferSize(1);
            currDocuments.setPageSize(1);
            currDocuments.setMaxSize(1);
            currDocuments.open(new WCMFilter("", "DOCID=" + this.getProperty("DOCID"), ""));
            if (currDocuments.isEmpty()) {
                return null;
            }
            return (Document)currDocuments.getAt(0);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(WCMExcelData.class, "WCMExcelData.label6", "\u83b7\u53d6\u6587\u6863\u5bf9\u8c61\u5931\u8d25\uff01"), ex);
        }
    }
}

