/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.old;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.DebugTimer;
import com.trs.infra.util.database.CDBText;
import com.trs.wcm.old.ImportDocsContext;
import com.trs.wcm.old.ImportDocsFromFile;
import org.apache.log4j.Logger;

public class ImportDocsFromHTMLFile
extends ImportDocsFromFile {
    private static Logger m_oLogger = Logger.getLogger(ImportDocsFromHTMLFile.class);

    @Override
    public void importDocs() throws Exception {
        if (this.importDocFromHTML()) {
            this.getCurrContext().addImportCount();
        } else {
            this.getCurrContext().addUnImportCount();
        }
    }

    public boolean importDocFromHTML() throws Exception {
        if (!this.getCurrContext().isValid()) {
            return false;
        }
        Documents newDocs = new Documents(this.getCurrContext().getCurrUser());
        Document newDoc = this.addNewDocument(newDocs, this.getCurrContext().getCurrChannel());
        if (newDoc == null) {
            return false;
        }
        String sContent = "";
        try {
            sContent = CMyFile.readFile(this.getCurrContext().getCurrImportFile());
        }
        catch (Exception ex) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label1", "\u5bfc\u5165\u6587\u4ef6[") + this.getCurrContext().getCurrTrueFileName() + I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label2", "]\u5931\u8d25\uff1a\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u65f6\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)ex);
            this.getCurrContext().addErrorInfo(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label3", "\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u65f6\u53d1\u751f\u5f02\u5e38"), ex);
            return false;
        }
        sContent = ImportDocsFromHTMLFile.getBodyHTML(sContent);
        sContent = this.dowithHTMLContent(newDoc, sContent);
        DBManager dbManager = DBManager.getDBManager();
        try {
            newDoc.setTitle(this.getTitleByFile());
            newDoc.setProperty("DOCHTMLCON", new CDBText(dbManager.getDBTypeAsInt(), sContent));
            newDoc.setProperty("DOCPUBHTMLCON", new CDBText(dbManager.getDBTypeAsInt(), ImportDocsFromHTMLFile.filterHTMLConToPubHTML(sContent)));
            newDocs.update();
        }
        catch (Exception ex) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label1", "\u5bfc\u5165\u6587\u4ef6[") + this.getCurrContext().getCurrTrueFileName() + I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label4", "]\u5931\u8d25\uff1a\u6dfb\u52a0\u6587\u6863\u65f6\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)ex);
            this.getCurrContext().addErrorInfo(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label5", "\u6dfb\u52a0\u6587\u6863\u65f6\u53d1\u751f\u5f02\u5e38!"), ex);
            return false;
        }
        this.getCurrContext().addSuccessInfo(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label6", "\u6210\u529f\u4ece\u6587\u4ef6[") + this.getCurrContext().getCurrTrueFileName() + I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label7", "]\u4e2d\u5bfc\u5165\u6587\u6863[") + newDoc.getTitle() + "]");
        return true;
    }

    private String getTitleByFile() {
        String sTitle;
        int nTitleEndPose;
        String sFileName = this.getCurrContext().getCurrTrueFileName();
        if (sFileName == null) {
            sFileName = this.getCurrContext().getCurrImportFile();
        }
        if ((nTitleEndPose = (sTitle = CMyFile.extractFileName(sFileName)).lastIndexOf(46)) <= 0) {
            return sTitle;
        }
        return sTitle.substring(0, nTitleEndPose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String sContent;
        boolean bOnlyTestMethod = false;
        try {
            sContent = "<html><body onload=\"alert(1);\"><a>123</a>dfasfd<P>123</body>";
            System.out.println(ImportDocsFromHTMLFile.getBodyHTML(sContent));
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label8", "\u6d4b\u8bd5[getBodyHTML]\u63a5\u53e3\u5931\u8d25\uff01"));
            ex.printStackTrace();
        }
        try {
            sContent = "<html><body onload=\"alert(1);\"><TABLE BACKGROUND=\"1.gif\" OLDID=123 OLDSRC=123><img src=\"1.gif\" OLDID=123 OLDSRC=123><a>123</a>dfasfd<P><img src=\"2.gif\" OLDID=123 OLDSRC=123><TABLE BACKGROUND=\"1.gif\" OLDID=123 OLDSRC=123>123</body>";
            System.out.println(ImportDocsFromHTMLFile.filterHTMLConToPubHTML(sContent));
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label9", "\u6d4b\u8bd5[filterHTMLConToPubHTML]\u63a5\u53e3\u5931\u8d25\uff01"));
            ex.printStackTrace();
        }
        if (bOnlyTestMethod) {
            return;
        }
        try {
            DebugTimer currTimer = new DebugTimer();
            Channel currChnl = Channel.findById(8);
            String sImportFileName = "c:\\test.htm";
            ImportDocsContext currContext = new ImportDocsContext();
            currContext.setCurrUser(User.getSystem());
            currContext.setCurrImportFile(sImportFileName);
            currContext.setCurrChannel(currChnl);
            currTimer.start();
            ImportDocsFromHTMLFile currImportHTML = new ImportDocsFromHTMLFile();
            try {
                currImportHTML.setCurrContext(currContext);
                currImportHTML.importDocs();
                System.out.println(currContext.getResult());
            }
            catch (Exception ex) {
                System.out.println(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label10", "\u5bfc\u5165\u6587\u4ef6") + sImportFileName + I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label11", "\u5931\u8d25\uff01"));
                ex.printStackTrace();
                return;
            }
            currTimer.stop();
            System.out.println(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label12", "\u5bfc\u5165\u6240\u7528\u65f6\u95f4\uff1a") + currTimer.getTime() + I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label13", "\u6beb\u79d2"));
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(ImportDocsFromHTMLFile.class, "ImportDocsFromHTMLFile.label14", "\u7cfb\u7edf\u5f02\u5e38\uff01"));
        }
    }
}

