/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.old;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyFile;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ImportDocsContext {
    private int m_nImportCount = 0;
    private int m_nUnImportCount = 0;
    private User m_oCurrUser = null;
    private Channel m_oCurrChannel = null;
    private Hashtable m_hAppendix = new Hashtable();
    private String m_sCurrImportFile = null;
    private ArrayList m_arNeedImportFile = new ArrayList();
    private String m_sCurrTrueFileName = null;
    private static Logger m_oLogger = Logger.getLogger(ImportDocsContext.class);
    private ArrayList m_arSuccessInfo = new ArrayList();
    private ArrayList m_arErrorInfo = new ArrayList();

    public void clearCurrInfo() {
        this.m_hAppendix.clear();
        this.m_arNeedImportFile.clear();
    }

    public void clear() {
        this.m_hAppendix.clear();
        this.m_arNeedImportFile.clear();
        this.m_arSuccessInfo.clear();
        this.m_arErrorInfo.clear();
    }

    public String getAbsoluteAppFileName(String _sAppFileName) {
        if (_sAppFileName == null || (_sAppFileName = _sAppFileName.trim()).length() <= 0) {
            return null;
        }
        return (String)this.m_hAppendix.get(_sAppFileName.toUpperCase());
    }

    public void putAbsoluteAppFileName(String _sAppFileName, String _sAbsolutFileName) {
        if (_sAppFileName == null || (_sAppFileName = _sAppFileName.trim()).length() <= 0) {
            return;
        }
        this.m_hAppendix.put(_sAppFileName.toUpperCase(), _sAbsolutFileName);
    }

    public Channel getCurrChannel() {
        return this.m_oCurrChannel;
    }

    public void setCurrChannel(Channel _currChannel) {
        this.m_oCurrChannel = _currChannel;
    }

    public User getCurrUser() {
        return this.m_oCurrUser;
    }

    public void setCurrUser(User _currUser) {
        this.m_oCurrUser = _currUser;
    }

    public boolean isValid() {
        if (!CMyFile.fileExists(this.getCurrImportFile())) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label1", "\u6587\u4ef6[") + this.getCurrTrueFileName() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label2", "]\u5bfc\u5165\u5931\u8d25:\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u4ef6[") + this.getCurrImportFile() + "]!"));
            return false;
        }
        if (this.getCurrUser() == null) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label1", "\u6587\u4ef6[") + this.getCurrTrueFileName() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label3", "]\u5bfc\u5165\u5931\u8d25:\u6ca1\u6709\u627e\u5230\u5bfc\u5165\u7528\u6237!")));
            return false;
        }
        if (this.getCurrChannel() != null && this.getCurrChannel().isDeleted()) {
            m_oLogger.error((Object)(I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label4", "\u5bfc\u5165\u6587\u4ef6[") + this.getCurrTrueFileName() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label5", "]\u5931\u8d25\uff1a\u6307\u5b9a\u7684\u5f53\u524d\u680f\u76ee\u65e0\u6548\uff01")));
        }
        return true;
    }

    public String getCurrImportFile() {
        return this.m_sCurrImportFile;
    }

    public void setCurrImportFile(String _currImportFile) {
        this.m_sCurrImportFile = _currImportFile;
    }

    public String getNeedImportFileAt(int _nIndex) {
        return (String)this.m_arNeedImportFile.get(_nIndex);
    }

    public int getNeedImportSize() {
        return this.m_arNeedImportFile.size();
    }

    public void addNeedImportFile(String _sNeedImportFile) {
        this.m_arNeedImportFile.add(_sNeedImportFile);
    }

    public static void main(String[] args) {
    }

    public int getImportCount() {
        return this.m_nImportCount;
    }

    public synchronized void addImportCount(int _importCount) {
        this.m_nImportCount += _importCount;
    }

    public synchronized void addImportCount() {
        this.addImportCount(1);
    }

    public int getUnImportCount() {
        return this.m_nUnImportCount;
    }

    public synchronized void addUnImportCount(int _unImportCount) {
        this.m_nUnImportCount += _unImportCount;
    }

    public synchronized void addUnImportCount() {
        this.addUnImportCount(1);
    }

    public ArrayList getSuccessInfo() {
        return this.m_arSuccessInfo;
    }

    protected void addSuccessInfo(String _sSuccessInfo) {
        this.m_arSuccessInfo.add(_sSuccessInfo);
    }

    public ArrayList getErrorInfo() {
        return this.m_arErrorInfo;
    }

    protected void addErrorInfo(String _sError) {
        this.addErrorInfo(_sError, null);
    }

    protected void addErrorInfo(String _sError, Exception _ex) {
        this.m_arErrorInfo.add(_sError);
        if (_ex != null) {
            _ex.printStackTrace();
        }
    }

    public String getResult() {
        int i;
        String sResult = I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label6", "\u672c\u6b21\u5bfc\u5165\u4fe1\u606f:\u6210\u529f\u5bfc\u5165[") + this.getImportCount() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label7", "]\u7bc7\u6587\u6863![") + this.getUnImportCount() + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label8", "]\u7bc7\u6587\u6863\u6ca1\u6709\u88ab\u5bfc\u5165!\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b:\n");
        if (this.getSuccessInfo().size() > 0) {
            sResult = sResult + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label9", "\u6210\u529f\u4fe1\u606f:\n");
            for (i = 0; i < this.getSuccessInfo().size(); ++i) {
                sResult = sResult + this.getSuccessInfo().get(i) + "\n";
            }
        }
        if (this.getErrorInfo().size() > 0) {
            sResult = sResult + I18NMessage.get(ImportDocsContext.class, "ImportDocsContext.label10", "\u9519\u8bef\u4fe1\u606f:\n");
            for (i = 0; i < this.getErrorInfo().size(); ++i) {
                sResult = sResult + this.getErrorInfo().get(i) + "\n";
            }
        }
        return sResult;
    }

    public String getCurrTrueFileName() {
        return this.m_sCurrTrueFileName;
    }

    public void setCurrTrueFileName(String _currTrueFileName) {
        this.m_sCurrTrueFileName = _currTrueFileName;
    }
}

