/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalServerAuto {
    private static final String WEB_INF_CLASSES_LOCALE = "/WEB-INF/classes/locale/";
    String m_sLang = "cn";
    String m_sRootPath = "/wcm";
    String m_sTargetPath = "";
    String[] m_arrToTransPaths = new String[]{"app", "console"};
    static Pattern m_pLocalServer = Pattern.compile("(?)LocaleServer\\.getString\\(\"([^\"]*?)\"\\s*,\\s*\"(.*?)\"\\)");
    Writer m_localePropsWriter = null;
    private Map m_tmpTranParams = null;
    private List list = new ArrayList();

    public LocalServerAuto(String sRootPath, String sLang) {
        this.m_sRootPath = new FileService(sRootPath.replace('/', File.separatorChar).replace('\\', File.separatorChar)).getAbsolutePath();
        this.m_sLang = sLang;
    }

    public String[] getToTransPaths() {
        return this.m_arrToTransPaths;
    }

    public void setToTransPaths(String[] toTransPaths) {
        this.m_arrToTransPaths = toTransPaths;
    }

    public void analyze() throws CMyException {
        try {
            this.getLocalePropsWriter();
            for (int i = 0; i < this.m_arrToTransPaths.length; ++i) {
                FileService toTrans = new FileService(this.m_sRootPath + File.separatorChar + this.m_arrToTransPaths[i]);
                this.analyzePath(toTrans);
            }
            this.writeLocale();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                this.closeLocalePropsWriter();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void analyzePath(FileStore oPath) throws CMyException, IOException {
        if (oPath.isDirectory()) {
            FileStore[] arrFiles = oPath.listFiles();
            for (int i = 0; i < arrFiles.length; ++i) {
                this.analyzePath(arrFiles[i]);
            }
            return;
        }
        this.analyzeFile(oPath);
    }

    public void analyzeFile(FileStore oFile) throws CMyException, IOException {
        String sOldFileName = oFile.getAbsolutePath();
        if (!this.isPageFile(sOldFileName)) {
            return;
        }
        String sFileEncoding = this.genFileEncoding(sOldFileName);
        String sHtml = CMyFile.readFile(sOldFileName, sFileEncoding);
        this.analyzeContent(sOldFileName, sHtml);
    }

    private void analyzeContent(String sFileName, String html) throws IOException {
        Matcher oMatcher = m_pLocalServer.matcher(html);
        while (oMatcher.find()) {
            String param = oMatcher.group(1);
            String value = oMatcher.group(2);
            String lastValue = (String)this.m_tmpTranParams.get(param);
            if (lastValue != null) {
                if (lastValue.equals(value)) continue;
                System.out.println(sFileName + I18NMessage.get(LocalServerAuto.class, "LocalServerAuto.label1", "===>\u91cd\u590d\u4f7f\u7528\u53d8\u91cf:") + param + I18NMessage.get(LocalServerAuto.class, "LocalServerAuto.label2", ",\u65e7\u503c:") + lastValue + I18NMessage.get(LocalServerAuto.class, "LocalServerAuto.label3", ",\u65b0\u503c:") + value);
                continue;
            }
            this.list.add(new String[]{param, value});
            this.m_tmpTranParams.put(param, value);
        }
    }

    private void writeLocale() throws IOException {
        Collections.sort(this.list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] pair1 = (String[])o1;
                String[] pair2 = (String[])o2;
                return pair1[0].compareToIgnoreCase(pair2[0]);
            }
        });
        Writer writer = this.getLocalePropsWriter();
        int length = this.list.size();
        for (int i = 0; i < length; ++i) {
            String[] pair = (String[])this.list.get(i);
            writer.write(pair[0]);
            writer.write("=");
            writer.write(pair[1]);
            writer.write("\n");
        }
    }

    private boolean isPageFile(String sFileName) {
        String strExt = sFileName.replaceFirst("^.*\\.([^\\.]*)", "$1").toLowerCase();
        return "jsp".equals(strExt);
    }

    private Writer getLocalePropsWriter() throws IOException {
        String sLocaleFile = this.m_sRootPath + WEB_INF_CLASSES_LOCALE + this.m_sLang + ".properties";
        if (this.m_localePropsWriter == null) {
            if (!new FileService(sLocaleFile).exists()) {
                CMyFile.makeDir(this.m_sRootPath + WEB_INF_CLASSES_LOCALE, true);
            }
            this.m_tmpTranParams = new HashMap();
            OutputStream fileos = new FileService(sLocaleFile).getOutputStream();
            this.m_localePropsWriter = new OutputStreamWriter(fileos, "GBK");
        }
        return this.m_localePropsWriter;
    }

    private void closeLocalePropsWriter() throws IOException {
        if (this.m_localePropsWriter != null) {
            this.m_localePropsWriter.close();
        }
    }

    private String genFileEncoding(String sAbsFilePath) {
        String sFileEncoding = "GBK";
        if ((sAbsFilePath = sAbsFilePath.replace('\\', '/')).indexOf("/metadata/application/") != -1) {
            return "utf-8";
        }
        if (sAbsFilePath.indexOf("/ext/") != -1 && sAbsFilePath.indexOf("/locale/") == -1 && sAbsFilePath.indexOf("wcm") == -1) {
            return "GBK";
        }
        if (sAbsFilePath.endsWith(".xml")) {
            return "GBK";
        }
        if (!sAbsFilePath.endsWith(".jsp")) {
            return "utf-8";
        }
        return sFileEncoding;
    }

    public static void main(String[] args) {
        String sRootPath = "E:\\MyWorkspace\\TRS.WCM.V6.1.Std\\release\\cn\\wcm";
        String locale = "zh_CN";
        if (args.length >= 2) {
            sRootPath = args[0];
            locale = args[1];
        }
        LocalServerAuto oLocalizer = new LocalServerAuto(sRootPath, locale);
        oLocalizer.setToTransPaths(new String[]{"app"});
        try {
            oLocalizer.analyze();
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
    }
}

