/*
 * Decompiled with CFR 0.152.
 */
package com.trs.tools;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.tools.JSLocaleProperties;
import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class JSLocaleTranslator {
    private static Logger logger = Logger.getLogger(JSLocaleTranslator.class);
    private Pattern m_scriptRegExp = Pattern.compile("(?is)(<script[^>]*>)(.*?)(</script>)");
    private Pattern m_chineseJSRegExp = Pattern.compile("(?im)('|\")((?:[^'\"\\n\\\\]|\\\\'|\\\\\"|\\\\)*[\\u4e00-\\u9fbb]+(?:[^'\"\\n\\\\]|\\\\'|\\\\\"|\\\\)*)\\1");
    private Pattern m_tagInChineseRegExp = Pattern.compile("(?im)[\\u4e00-\\u9fbb]+.*[<>].*[\\u4e00-\\u9fbb]+");
    private Pattern m_noTagInChineseRegExp = Pattern.compile("[^<>]*[\\u4e00-\\u9fbb]+[^<>]*");
    private String m_sRootPath;
    private String m_sPrefixRootPath;
    private String[] m_aAcceptFileExt = new String[]{".jsp", ".html", ".htm", ".js"};
    private Map m_mapResult;
    private String m_sOutputPath;

    public JSLocaleTranslator(String sRootPath, String sPrefixRootPath, String sJSLocaleFile, String sOutputPath) throws CMyException {
        this.m_sRootPath = CMyString.setStrEndWith(sRootPath.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_sPrefixRootPath = CMyString.setStrEndWith(sPrefixRootPath.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_sOutputPath = CMyString.setStrEndWith(sOutputPath.replace('/', File.separatorChar).replace('\\', File.separatorChar), File.separatorChar);
        this.m_mapResult = JSLocaleProperties.load(sJSLocaleFile);
    }

    public static void main(String[] args) throws CMyException {
        if (args.length < 4) {
            StringBuffer sbInfo = new StringBuffer(200);
            sbInfo.append("\u6307\u5b9a\u7684\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u9700\u8981\u56db\u4e2a\u53c2\u6570\n");
            sbInfo.append("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u8fdb\u884cjs\u4e2d\u6587\u66ff\u6362\u7684\u6839\u76ee\u5f55\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/app/");
            sbInfo.append("\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\u6307\u5b9a\u9700\u8981\u5904\u7406\u7684\u6839\u8def\u5f84\u524d\u7f00\u8def\u5f84\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/WebApp/");
            sbInfo.append("\n\u7b2c\u4e09\u4e2a\u53c2\u6570\u6307\u5b9a\u66ff\u6362\u8fc7\u7a0b\u4e2d\u9700\u8981\u7528\u5230\u7684\u8d44\u6e90\u6587\u4ef6\u5168\u8def\u5f84\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/workspace/TRS.WCM.V6.1.Std-1095-EN/SourceCode/Java/configfiles/wcm6-locale/js_en.properties");
            sbInfo.append("\n\u7b2c\u56db\u4e2a\u53c2\u6570\u6307\u5b9a\u66ff\u6362\u540e\u6587\u4ef6\u5b58\u653e\u7684\u6839\u76ee\u5f55\uff1a\n");
            sbInfo.append("\t\t\u5982\uff1a\n");
            sbInfo.append("E:/wcm65-en/");
            logger.error((Object)sbInfo);
            return;
        }
        JSLocaleTranslator instance = new JSLocaleTranslator(args[0], args[1], args[2], args[3]);
        instance.analyze();
    }

    public void analyze() throws CMyException {
        FileService root = new FileService(this.m_sRootPath);
        this.analyzeDir(root);
    }

    private void analyzeDir(FileStore oFile) throws CMyException {
        if (!this.isAccept(oFile)) {
            return;
        }
        if (oFile.isFile()) {
            this.analyzeFile(oFile);
            return;
        }
        FileStore[] aFiles = oFile.listFiles();
        for (int i = 0; i < aFiles.length; ++i) {
            this.analyzeDir(aFiles[i]);
        }
    }

    private boolean isAccept(FileStore oFile) {
        int i;
        String sFileName = oFile.getName();
        if (oFile.isDirectory()) {
            String[] excludeFolders = new String[]{".svn", "CVS", "editor", "runtime"};
            for (int i2 = 0; i2 < excludeFolders.length; ++i2) {
                if (!sFileName.endsWith(excludeFolders[i2])) continue;
                return false;
            }
            return true;
        }
        String[] excludeFiles = new String[]{"_cn.js", "_en.js", "jquery"};
        for (i = 0; i < excludeFiles.length; ++i) {
            if (sFileName.indexOf(excludeFiles[i]) < 0) continue;
            return false;
        }
        for (i = 0; i < this.m_aAcceptFileExt.length; ++i) {
            if (!sFileName.endsWith(this.m_aAcceptFileExt[i])) continue;
            return true;
        }
        return false;
    }

    private void analyzeFile(FileStore oFile) throws CMyException {
        String sFullFileName = oFile.getAbsolutePath();
        String sEncoding = CharsetDetector.detect(sFullFileName);
        String sContent = CMyFile.readFile(sFullFileName, sEncoding);
        StringBuffer sbContent = new StringBuffer(sContent.length());
        logger.info((Object)("\u5f00\u59cb\u5206\u6790\u6587\u4ef6\uff1a" + sFullFileName));
        if (sFullFileName.endsWith(".js")) {
            sbContent.append(this.analyzeContent(sContent));
        } else {
            Matcher matcher = this.m_scriptRegExp.matcher(sContent);
            int nStart = 0;
            int nEnd = 0;
            while (matcher.find()) {
                nStart = matcher.start();
                sbContent.append(sContent.substring(nEnd, nStart));
                nEnd = matcher.end();
                sbContent.append(matcher.group(1));
                String sJSCode = matcher.group(2);
                if (sJSCode.length() > 0) {
                    sbContent.append(this.analyzeContent(sJSCode));
                }
                sbContent.append(matcher.group(3));
            }
            if (nEnd < sContent.length()) {
                sbContent.append(sContent.substring(nEnd));
            }
        }
        this.writeFile(oFile, sbContent.toString());
    }

    private void writeFile(FileStore oFile, String sContent) throws CMyException {
        String sFileFullName = oFile.getAbsolutePath();
        String sEncoding = CharsetDetector.detect(sFileFullName);
        String sRelativeFileName = sFileFullName.substring(this.m_sPrefixRootPath.length());
        String sDstFileName = this.m_sOutputPath + sRelativeFileName;
        CMyFile.writeFile(sDstFileName, sContent, sEncoding);
    }

    private String analyzeContent(String sContent) {
        StringBuffer sbContent = new StringBuffer(sContent.length());
        Matcher matcher = this.m_chineseJSRegExp.matcher(sContent);
        int nStart = 0;
        int nEnd = 0;
        while (matcher.find()) {
            nStart = matcher.start();
            sbContent.append(sContent.substring(nEnd, nStart));
            nEnd = matcher.end();
            String sReplacedContent = matcher.group();
            String sChinese = matcher.group(2);
            String sOptimizeChinese = this.getOptimizeKey(sChinese);
            String sLocale = (String)this.m_mapResult.get(sOptimizeChinese);
            if (sLocale != null && !this.isInComment(sContent, nStart, nEnd)) {
                if (!sChinese.equals(sOptimizeChinese)) {
                    sLocale = CMyString.replaceStr(sChinese, sOptimizeChinese, sLocale);
                }
                sReplacedContent = matcher.group(1) + sLocale + matcher.group(1);
            }
            sbContent.append(sReplacedContent);
        }
        if (nEnd < sContent.length()) {
            sbContent.append(sContent.substring(nEnd));
        }
        return sbContent.toString();
    }

    private String getOptimizeKey(String sChineseKey) {
        Matcher matcher = this.m_tagInChineseRegExp.matcher(sChineseKey);
        if (matcher.find()) {
            return sChineseKey;
        }
        matcher = this.m_noTagInChineseRegExp.matcher(sChineseKey);
        if (matcher.find()) {
            String sNewKey = matcher.group();
            if (!matcher.find()) {
                return sNewKey;
            }
        }
        return sChineseKey;
    }

    private boolean isInComment(String sContent, int nStartIndex, int nEndIndex) {
        int nSP2;
        int nEnterStartPos;
        int nCommentStartPos = sContent.lastIndexOf("//", nStartIndex);
        if (nCommentStartPos > (nEnterStartPos = sContent.lastIndexOf(10, nStartIndex))) {
            return true;
        }
        int nSP1 = sContent.lastIndexOf("/*", nStartIndex);
        if (nSP1 < 0) {
            return false;
        }
        if (nSP1 != 0) {
            while (sContent.charAt(nSP1 - 1) == '/') {
                if ((nSP1 = sContent.lastIndexOf("/*", nSP1 - 1)) != -1) continue;
                return false;
            }
        }
        return nSP1 > (nSP2 = sContent.lastIndexOf("*/", nStartIndex));
    }
}

