/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.ajaxservice.xmlconvertors.ChannelToXML;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IObjectMemberMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.ObjectMember;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.MyPlugin;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.individuation.IndividuationMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyString;
import com.trs.presentation.locale.LocaleServer;
import com.trs.presentation.nav.TreeNodeCalctor;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.presentation.util.RequestHelper;
import com.trs.service.IUserService;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;

public class TreeCreator {
    private static Logger logger = Logger.getLogger(TreeCreator.class);
    public static final int VIEW_TYPE_NORMAL = 1;
    public static final int VIEW_TYPE_RADIO = 2;
    public static final int VIEW_TYPE_CHECKBOX = 3;
    private User m_oLoginUser = null;
    private Channel m_oCurrChannel = null;
    private WebSite m_oCurrSite = null;
    private int m_nCurrSiteId = 0;
    private CMSObj m_oViewer = null;
    private CMSObj m_oOperator = null;
    private RequestHelper currRequestHelper = null;
    private JspWriter out = null;
    private String m_sDesc = null;
    private boolean m_bInRightSetPage = false;
    private boolean m_bForIndividual = false;
    private boolean m_bSelectMobile = false;
    private boolean m_bInViewOperSetPage = false;
    private boolean m_bGetAllChildren = false;
    private int m_nOperatorId;
    private int m_nOperatorType;
    private int[] m_pObjectTypes = null;
    private int[] m_pObjectIds = null;
    private int m_nRightIndex;
    private int m_nSiteType;
    private String m_sSiteTypes;
    boolean isView = false;
    boolean m_isFirstLevelCustomChannel = false;
    private boolean m_bLoadFromPath = false;
    private IObjectMemberMgr oObjectMemberMgr = null;
    private int[] m_pExcludeParentIds = null;
    private Channels m_oSelectedChannels = null;
    private boolean m_bDisplayName = false;

    public TreeCreator(User _loginUser, RequestHelper _requestHelper, JspWriter _out) throws WCMException {
        if (_requestHelper.getRequest() != null) {
            Object oValue = _requestHelper.getRequest().getSession().getAttribute("NavDisplayName");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Session.NavDisplayName:" + oValue));
            }
            boolean bl = this.m_bDisplayName = oValue != null && "true".equalsIgnoreCase(oValue.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("m_bDisplayName:" + this.m_bDisplayName));
            }
        }
        this.oObjectMemberMgr = (IObjectMemberMgr)DreamFactory.createObjectById("IObjectMemberMgr");
        this.m_oLoginUser = _loginUser;
        this.currRequestHelper = _requestHelper;
        this.out = _out;
        this.isView = _requestHelper.getBoolean("isView", false);
        this.m_nOperatorId = _requestHelper.getInt("OperatorId", 0);
        if (this.m_nOperatorId > 0) {
            this.m_nOperatorType = _requestHelper.getInt("OperatorType", 0);
            this.m_oOperator = (CMSObj)BaseObj.findById(this.m_nOperatorType, this.m_nOperatorId);
            if (this.m_oOperator == null) {
                throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label1", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684Operator[Type=") + this.m_nOperatorType + ",Id=" + this.m_nOperatorId + I18NMessage.get(TreeCreator.class, "TreeCreator.label2", "]\u6216\u8bb8\u88ab\u5220\u9664\uff1f"));
            }
            this.validLoginUserIsAdminOfOperator();
        } else {
            this.m_oOperator = this.m_oLoginUser;
        }
        this.m_oViewer = _requestHelper.getBoolean("ViewerIsCurrUser", true) ? this.m_oLoginUser : this.m_oOperator;
        this.m_bForIndividual = _requestHelper.getBoolean("forIndividual", false);
        this.m_bSelectMobile = _requestHelper.getBoolean("SelectMobile", false);
        this.m_bInRightSetPage = _requestHelper.getBoolean("InRightSetPage", false);
        this.m_nRightIndex = _requestHelper.getInt("RightIndex", 64);
        this.m_nSiteType = _requestHelper.getInt("SiteType", 0);
        this.m_sSiteTypes = _requestHelper.getString("SiteTypes");
        this.m_bInViewOperSetPage = _requestHelper.getBoolean("InViewOperSetPage", false);
        this.m_bGetAllChildren = _requestHelper.getBoolean("GetAllChildren", false);
        boolean bFromSelect = this.currRequestHelper.getBoolean("FromSelect", false);
        if (bFromSelect) {
            int nSiteId;
            int nChannelId = this.currRequestHelper.getInt("CurrChannelId", 0);
            if (nChannelId > 0) {
                this.m_oCurrChannel = Channel.findById(nChannelId);
                if (this.m_oCurrChannel == null) {
                    throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label3", "\u6307\u5b9a\u9891\u9053[") + nChannelId + I18NMessage.get(TreeCreator.class, "TreeCreator.label4", "]\u4e0d\u5b58\u5728\uff01"));
                }
                this.m_nCurrSiteId = this.m_oCurrChannel.getSiteId();
            }
            if ((nSiteId = this.currRequestHelper.getInt("CurrSiteId", 0)) <= 0) {
                nSiteId = this.currRequestHelper.getInt("ExpandSiteId", 0);
            }
            if (nSiteId > 0) {
                this.m_oCurrSite = WebSite.findById(nSiteId);
                if (this.m_oCurrSite == null) {
                    throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label5", "\u6307\u5b9a\u7ad9\u70b9[") + nSiteId + I18NMessage.get(TreeCreator.class, "TreeCreator.label4", "]\u4e0d\u5b58\u5728\uff01"));
                }
                this.m_nCurrSiteId = nSiteId;
            }
        }
    }

    public void writeTopChildrenHTML() throws Exception {
        this.m_sDesc = I18NMessage.get(TreeCreator.class, "TreeCreator.label6", "\u4ea7\u751f\u7b2c\u4e00\u7ea7\u5b50\u8282\u70b9\u7684HTML");
        String sParentType = this.currRequestHelper.getString("ParentType");
        if (sParentType == null || (sParentType = sParentType.trim()).length() == 0) {
            throw new WCMException(this.m_sDesc + I18NMessage.get(TreeCreator.class, "TreeCreator.label7", "\u5931\u8d25\uff1a\u6ca1\u6709\u6307\u5b9a\u7236\u7ed3\u70b9\u7684\u7c7b\u578b\uff01[ParentType]"));
        }
        int nParentId = this.currRequestHelper.getInt("ParentId", 0);
        if (sParentType.equalsIgnoreCase("r")) {
            this.writeSitesHTML(nParentId);
            return;
        }
        if (sParentType.equalsIgnoreCase("s")) {
            this.writeChannelsHTML(nParentId, 0);
            return;
        }
        if (sParentType.equalsIgnoreCase("c")) {
            this.writeChannelsHTML(0, nParentId);
            return;
        }
        if (sParentType.equalsIgnoreCase("i")) {
            this.m_isFirstLevelCustomChannel = true;
            this.writeCustomChannelsHTML(nParentId);
            return;
        }
    }

    public void writeHTMLOfAPath() throws Exception {
        this.m_bLoadFromPath = true;
        this.m_sDesc = I18NMessage.get(TreeCreator.class, "TreeCreator.label8", "\u4ea7\u751f\u6307\u5b9a\u8def\u5f84\u7684HTML");
        String sNodeIds = this.currRequestHelper.getString("NodeIds");
        if (sNodeIds == null || (sNodeIds = sNodeIds.trim()).length() == 0) {
            throw new WCMException(this.m_sDesc + I18NMessage.get(TreeCreator.class, "TreeCreator.label9", "\u5931\u8d25\uff1a\u6ca1\u6709\u6307\u5b9a\u8def\u5f84\uff01[NodeIds]"));
        }
        String[] pNodeIds = sNodeIds.split(",");
        this.extractNodeInfo(pNodeIds);
        this.writeLevelHTMLOfAPath(0);
    }

    public void writeHTMLContainsChannels() throws Exception {
        this.m_sDesc = I18NMessage.get(TreeCreator.class, "TreeCreator.label10", "\u4ea7\u751f\u5305\u542b\u6307\u5b9a\u680f\u76ee\u7684HTML");
        String sChannelIds = this.currRequestHelper.getString("ChannelIds");
        if (sChannelIds == null || (sChannelIds = sChannelIds.trim()).length() == 0) {
            throw new WCMException(this.m_sDesc + I18NMessage.get(TreeCreator.class, "TreeCreator.label11", "\u5931\u8d25\uff1a\u6ca1\u6709\u6307\u5b9a\u76f8\u5173\u7684\u9891\u9053ID\uff01[ChannelIds]"));
        }
        this.m_oSelectedChannels = Channels.findByIds(this.m_oLoginUser, sChannelIds);
        int[] pSiteTypes = this.getSiteTypesOfChannels(sChannelIds);
        this.m_nSiteType = pSiteTypes[0];
        if (this.m_nSiteType == -1) {
            throw new WCMException(this.m_sDesc + I18NMessage.get(TreeCreator.class, "TreeCreator.label12", "\u5931\u8d25\uff1a\u6ca1\u6709\u660e\u786e\u7ad9\u70b9\u7c7b\u578b\uff01[SiteType=") + this.m_nSiteType + "]");
        }
        TreeNodeCalctor rootNode = new TreeNodeCalctor(sChannelIds, this.m_oLoginUser);
        WebSites sites = this.getWebSites(this.m_nSiteType);
        String sTabContent = this.makeTabContent(0);
        int nSize = sites.size();
        for (int i = 0; i < nSize; ++i) {
            WebSite site = (WebSite)sites.getAt(i);
            this.writeSingleNodeHTML(site, sTabContent);
            List lChildren = this.getChildren(site, 64);
            if (lChildren == null || lChildren.isEmpty()) continue;
            this.out.println(sTabContent + "<ul>");
            TreeNodeCalctor node = rootNode.getExpandNodeById(site.getId());
            if (node != null) {
                this.writeHTMLContainsChannels(lChildren, node, 1);
            }
            this.out.println(sTabContent + "</ul>");
        }
        this.writeSelectedChannelsWithoutPriv();
    }

    protected void writeSelectedChannelsWithoutPriv() throws IOException, WCMException, Exception {
        if (!this.m_oSelectedChannels.isEmpty()) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("<div id='selectedChnlsWithoutPriv' style='display:none'>");
            int size = this.m_oSelectedChannels.size();
            for (int i = 0; i < size; ++i) {
                Channel channel = (Channel)this.m_oSelectedChannels.getAt(i);
                if (channel == null) continue;
                buff.append("<span cid='");
                buff.append(channel.getId());
                buff.append("'>");
                buff.append(CMyString.transDisplay(channel.getDispDesc()));
                buff.append("</span>");
            }
            buff.append("</div>");
            this.out.println(buff.toString());
        }
    }

    private void writeHTMLContainsChannels(List objects, TreeNodeCalctor _parentNode, int _nCurrLevel) throws Exception {
        String sTabContent = this.makeTabContent(_nCurrLevel);
        int nSize = objects.size();
        for (int i = 0; i < nSize; ++i) {
            Channel host = (Channel)objects.get(i);
            if (host == null) continue;
            this.m_oSelectedChannels.remove(host, false);
            this.writeSingleNodeHTML(host, sTabContent);
            List lChildren = this.getChildren(host, 64);
            if (lChildren == null || lChildren.isEmpty()) continue;
            TreeNodeCalctor node = _parentNode.getExpandNodeById(host.getId());
            if (node != null) {
                this.out.println(sTabContent + "<ul>");
                this.writeHTMLContainsChannels(lChildren, node, _nCurrLevel + 1);
                this.out.println(sTabContent + "</ul>");
                continue;
            }
            this.out.println(sTabContent + "<ul></ul>");
        }
    }

    private void validLoginUserIsAdminOfOperator() throws WCMException {
        IUserService userService = (IUserService)DreamFactory.createObjectById("IUserService");
        if (this.m_oLoginUser.isSecurityAdmin()) {
            return;
        }
        if (userService.isManagerOfRole(this.m_oLoginUser)) {
            return;
        }
        switch (this.m_oOperator.getWCMType()) {
            case 204: {
                User user = (User)this.m_oOperator;
                if (user.getId() == this.m_oLoginUser.getId() && this.isView) {
                    return;
                }
                Groups groups = user.getGroups();
                int nSize = groups.size();
                for (int i = 0; i < nSize; ++i) {
                    Group group = (Group)groups.getAt(i);
                    if (group == null || !this.isAdminOfGroup(this.m_oLoginUser, group)) continue;
                    return;
                }
                break;
            }
            case 201: {
                if (!this.isAdminOfGroup(this.m_oLoginUser, (Group)this.m_oOperator)) break;
                return;
            }
            case 203: {
                if (!this.m_oLoginUser.getName().equals(this.m_oOperator.getCrUserName())) break;
                return;
            }
        }
        logger.error((Object)("\u7528\u6237[" + this.m_oLoginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406" + this.m_oOperator + "\uff01"), (Throwable)new Exception("who call me!"));
        throw new WCMException("\u7528\u6237[" + this.m_oLoginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406\uff01");
    }

    private boolean isAdminOfGroup(User loginUser, Group group) throws WCMException {
        if (group == null) {
            return false;
        }
        if (group.isAdministrator(loginUser)) {
            return true;
        }
        return this.isAdminOfGroup(loginUser, group.getParent());
    }

    private void writeSitesHTML(int _nSiteType) throws Exception {
        switch (_nSiteType) {
            case 1: {
                if (PluginConfig.isStartPhoto()) break;
                this.out.println("<font color=\"red\"" + I18NMessage.get(TreeCreator.class, "TreeCreator.label15", ">\u60a8\u6ca1\u6709\u8d2d\u4e70\u56fe\u7247\u9009\u4ef6\uff01</font>"));
                return;
            }
            case 2: {
                if (PluginConfig.isStartVideo()) break;
                this.out.println("<font color=\"red\"" + I18NMessage.get(TreeCreator.class, "TreeCreator.label16", ">\u60a8\u6ca1\u6709\u8d2d\u4e70\u6d41\u5a92\u4f53\u9009\u4ef6\uff01</font>"));
                return;
            }
            case 4: {
                CMyBitsValue bitsValue = new CMyBitsValue(MyPlugin.getPluginCode());
                if (bitsValue.getBit(2)) break;
                this.out.println("<font color=\"red\"" + I18NMessage.get(TreeCreator.class, "TreeCreator.label17", ">\u60a8\u6ca1\u6709\u8d2d\u4e70\u5143\u6570\u636e\u7ba1\u7406\u9009\u4ef6\uff01</font>"));
                return;
            }
        }
        WebSites sites = this.getWebSites(_nSiteType);
        this.writeHTMLFromObjects(sites);
    }

    private void writeChannelsHTML(int _nParentSiteId, int _nParentChannelId) throws Exception {
        BaseChannel host = null;
        if (_nParentSiteId > 0) {
            host = WebSite.findById(_nParentSiteId);
        } else if (_nParentChannelId > 0) {
            host = Channel.findById(_nParentChannelId);
        }
        List channels = this.getChildren(host, 64);
        this.writeHTMLFromObjects(channels);
    }

    private void writeCustomChannelsHTML(int _nParentId) throws Exception {
        if (_nParentId == 3) {
            IndividuationMgr individuationMgr = new IndividuationMgr();
            String channelIds = individuationMgr.getObjectIdsAsString(101);
            this.writeHTMLFromObjects(Channels.findByIds(this.m_oLoginUser, channelIds));
        }
    }

    public WebSites getWebSites(int _nSiteType) throws WCMException {
        String sWhere = "Status>=0";
        if (_nSiteType >= 0) {
            sWhere = sWhere + " and SiteType=?";
        }
        boolean bMultiSites = this.currRequestHelper.getBoolean("MultiSites", false);
        if (this.m_nCurrSiteId > 0 && !bMultiSites) {
            sWhere = sWhere + " and SiteId=?";
        }
        WCMFilter filter = new WCMFilter("", sWhere, "SiteType Asc,SiteOrder Desc");
        if (_nSiteType >= 0) {
            filter.addSearchValues(_nSiteType);
        }
        if (this.m_nCurrSiteId > 0 && !bMultiSites) {
            filter.addSearchValues(this.m_nCurrSiteId);
        }
        SiteMemberMgr siteMemberMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
        WebSites sites = null;
        sites = WebSites.openWCMObjs(null, filter);
        String isStartSeparate = ConfigServer.getServer().getInitProperty("SEPARATION_OF_THREE_POWERS");
        boolean isSecAdmin = this.m_oLoginUser.isSecurityAdmin();
        boolean isAuditAdmin = this.m_oLoginUser.isAuditAdmin();
        boolean bFromSelect = this.currRequestHelper.getBoolean("FromSelect", false);
        Hashtable customSiteIdHt = null;
        customSiteIdHt = this.currRequestHelper.getRequest() != null ? (Hashtable)this.currRequestHelper.getRequest().getSession().getAttribute("customSite") : new Hashtable(1);
        for (int i = sites.size() - 1; i >= 0; --i) {
            WebSite site = (WebSite)sites.getAt(i);
            if (site == null || "true".equalsIgnoreCase(isStartSeparate) && this.m_bInRightSetPage && isSecAdmin) continue;
            if ("true".equalsIgnoreCase(isStartSeparate) && (isSecAdmin || isAuditAdmin)) {
                sites.removeAt(i, false);
                continue;
            }
            if (this.m_bSelectMobile && !site.isMobile()) {
                sites.removeAt(i, false);
                continue;
            }
            if (this.m_oViewer instanceof User) {
                if (!this.hasSuperRight(site, this.m_oViewer) && !AuthServer.hasRight(this.m_oViewer, (CMSObj)site, 64)) {
                    sites.removeAt(i, false);
                    continue;
                }
            } else if (!this.hasSuperRight(site, this.m_oViewer) && !siteMemberMgr.isVisible(this.m_oViewer, site)) {
                sites.removeAt(i, false);
                continue;
            }
            if (this.m_bInRightSetPage || !this.m_bForIndividual || customSiteIdHt == null || customSiteIdHt.size() <= 0 || customSiteIdHt.get(String.valueOf(site.getId())) != null) continue;
            sites.removeAt(i, false);
        }
        return sites;
    }

    private boolean hasRight(BaseChannel _oSiteOrChannel, int nRightIndex) throws WCMException {
        if (this.m_nRightIndex == 42) {
            for (int i = 0; i < WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS.length; ++i) {
                if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)_oSiteOrChannel.getSite(), WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS[i])) continue;
                return true;
            }
            return false;
        }
        if (this.m_oViewer.getWCMType() != 204 && this.isView && nRightIndex == 64) {
            ObjectMember oObjectMember = this.oObjectMemberMgr.getObjectMember(this.m_oViewer.getWCMType(), this.m_oViewer.getId(), _oSiteOrChannel.getWCMType(), _oSiteOrChannel.getId());
            return oObjectMember != null && oObjectMember.isVisible();
        }
        return AuthServer.hasRight(this.m_oViewer, (CMSObj)_oSiteOrChannel, nRightIndex);
    }

    private void writeHTMLFromObjects(BaseObjs objects) throws Exception {
        this.writeHTMLFromObjects(objects, false, 0);
    }

    private void writeHTMLFromObjects(BaseObjs objects, boolean _bWriteChildrenHTML, int _nCurrLevel) throws Exception {
        int nSize = objects.size();
        for (int i = 0; i < nSize; ++i) {
            BaseChannel host = (BaseChannel)objects.getAt(i);
            if (host == null || !this.isVisibleOnLoadFromPath(host)) continue;
            if (this.m_bInRightSetPage) {
                if (this.m_bInViewOperSetPage) {
                    this.writeBaseChannelHTMLOfViewOperSet(host);
                    continue;
                }
                this.writeBaseChannelHTMLOfRightSet(host);
                continue;
            }
            this.writeBaseChannelHTML(host, _bWriteChildrenHTML, _nCurrLevel, "");
        }
    }

    private void writeBaseChannelHTML(BaseChannel host, boolean _bWriteChildrenHTML, int _nCurrLevel, String _sTabContent) throws Exception {
        String sTabContent = CMyString.showNull(_sTabContent);
        this.writeSingleNodeHTML(host, sTabContent);
        if (this.m_isFirstLevelCustomChannel) {
            return;
        }
        boolean bExcludeChildren = this.currRequestHelper.getBoolean("ExcludeChildren", false);
        if (bExcludeChildren && this.isExcludeChildren(host)) {
            return;
        }
        List<Channel> lChildren = host.getChildren(null);
        if (lChildren != null && !lChildren.isEmpty()) {
            if (this.isNeedWriteChildrenHTML(host, _bWriteChildrenHTML, _nCurrLevel)) {
                this.out.println(sTabContent + "<ul>");
                this.writeHTMLFromObjects(lChildren, _bWriteChildrenHTML, _nCurrLevel + 1);
                this.out.println(sTabContent + "</ul>");
            } else {
                this.out.println(sTabContent + "<ul></ul>");
            }
        }
    }

    private boolean isExcludeChildren(BaseChannel _host) throws WCMException {
        if (_host.isSite()) {
            return false;
        }
        String sExcludeParentIds = this.currRequestHelper.getString("ExcludeParentIds");
        if (this.m_pExcludeParentIds == null) {
            this.m_pExcludeParentIds = CMyString.splitToInt(sExcludeParentIds, ",");
        }
        if (this.m_pExcludeParentIds.length > 0) {
            for (int i = 0; i < this.m_pExcludeParentIds.length; ++i) {
                if (this.m_pExcludeParentIds[i] != _host.getId()) continue;
                return true;
            }
            return false;
        }
        return this.m_oCurrChannel != null && this.m_oCurrChannel.getId() == _host.getId();
    }

    private void writeSingleNodeHTML(BaseChannel _host, String _sTabContent) throws IOException, WCMException, Exception {
        String sDivId = (_host.isSite() ? "s" : "c") + "_" + _host.getId();
        String siteType = this.m_isFirstLevelCustomChannel ? " SiteType=" + this.getSiteType(_host) + " " : " ";
        this.out.println(_sTabContent + "<div title=\"" + CMyString.filterForHTMLValue(_host.getDispDesc()) + "\" classPre=\"" + this.getClassPre(_host) + "\"" + siteType + this.getExtraHTMLAttribute(_host) + " id=\"" + sDivId + "\">" + this.getNodeInnerHTML(_host, sDivId) + "</div>");
    }

    private boolean isNeedWriteChildrenHTML(BaseChannel _host, boolean _bWriteChildrenHTML, int _nCurrLevel) {
        return _bWriteChildrenHTML && _nCurrLevel < this.m_pObjectIds.length && this.m_pObjectIds[_nCurrLevel] == _host.getId();
    }

    private String getClassPre(BaseChannel _siteOrChannel) {
        if (_siteOrChannel.isSite()) {
            return "site";
        }
        Channel channel = (Channel)_siteOrChannel;
        if (channel.isNormType()) {
            return "channel";
        }
        return "channel" + channel.getType();
    }

    public void setDisplayName(boolean _bDisplayName) {
        this.m_bDisplayName = _bDisplayName;
    }

    public boolean isDispalyName() {
        return this.m_bDisplayName;
    }

    private String getNodeInnerHTML(BaseChannel host, String divId) throws Exception {
        String sDisplayValue;
        String string = sDisplayValue = this.isDispalyName() ? host.getName() : host.getDispDesc();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sDisplayValue:[" + sDisplayValue + "]"));
        }
        if (this.currRequestHelper.getBoolean("FromSelect", false)) {
            return "<a href=\"#\"  name=\"a" + divId + "\" " + this.getExtraAttrOfA(host) + "><label For=\"c" + divId + "\" style=\"cursor:hand\">" + CMyString.transDisplay(sDisplayValue) + "</label></a>";
        }
        return "<a href=\"#\"  name=\"a" + divId + "\" " + this.getExtraAttrOfA(host) + ">" + CMyString.transDisplay(sDisplayValue) + "</a>";
    }

    private String getExtraAttrOfA(BaseChannel host) {
        String sTitle = LocaleServer.getString("tree.label.bianhao", I18NMessage.get(TreeCreator.class, "TreeCreator.label18", "\u7f16\u53f7\uff1a")) + host.getId() + " \n" + LocaleServer.getString("tree.label.biaoshi", I18NMessage.get(TreeCreator.class, "TreeCreator.label19", "\u552f\u4e00\u6807\u8bc6\uff1a")) + CMyString.filterForHTMLValue(this.isDispalyName() ? host.getDispDesc() : host.getName()) + " \n" + LocaleServer.getString("tree.label.cruser", I18NMessage.get(TreeCreator.class, "TreeCreator.label20", "\u521b\u5efa\u8005\uff1a")) + CMyString.filterForHTMLValue(host.getCrUserName()) + " \n" + LocaleServer.getString("tree.label.crtime", I18NMessage.get(TreeCreator.class, "TreeCreator.label21", "\u521b\u5efa\u65f6\u95f4\uff1a")) + host.getCrTime();
        return " title=\"" + sTitle + "\" ";
    }

    private String getExtraHTMLAttribute(BaseChannel host) throws WCMException {
        String sAttr4Sel = "";
        if (this.currRequestHelper.getBoolean("unNotSelectDisabledNoRight", false)) {
            sAttr4Sel = " unNotSel=\"true\" ";
        }
        if (!this.currRequestHelper.getBoolean("FromSelect", false)) {
            String sAttr = "";
            if (!host.isSite()) {
                Channel channel = (Channel)host;
                if (!channel.isNormType()) {
                    sAttr = " ChannelType=" + channel.getType() + " ";
                }
                if (channel.isVirtual()) {
                    sAttr = sAttr + " IsV=1 ";
                }
            }
            RightValue oRightValue = null;
            oRightValue = this.hasSuperRight(host, this.m_oOperator) ? new RightValue(RightValue.getAdministratorValues()) : (this.oObjectMemberMgr.canOperate(this.m_oOperator, host.getWCMType(), host.getId()) ? AuthServer.getRightValue((CMSObj)host, this.m_oOperator) : new RightValue());
            if (host instanceof Channel) {
                Channel channel = (Channel)host;
                ChannelToXML.doFilterRight(oRightValue, channel);
            }
            sAttr = sAttr + " RV=" + oRightValue.toString() + " ";
            return sAttr + sAttr4Sel;
        }
        if (host.isSite()) {
            if (!this.currRequestHelper.getBoolean("ShowSiteCheckBox", false)) {
                return " OnlyNode=\"true\" " + sAttr4Sel;
            }
            return "" + sAttr4Sel;
        }
        if (this.hasRight((Channel)host)) {
            return "" + sAttr4Sel;
        }
        return " SDisabled=\"true\" " + sAttr4Sel;
    }

    private String getSiteType(BaseChannel host) throws WCMException {
        if (!host.isSite()) {
            host = WebSite.findById(host.getSiteId());
        }
        Number siteType = (Number)((WebSite)host).getProperty("SiteType");
        return siteType.toString();
    }

    public boolean hasSuperRight(BaseChannel host, CMSObj _aUser) throws WCMException {
        switch (_aUser.getWCMType()) {
            case 204: {
                User user = (User)_aUser;
                if (user.isAdministrator()) {
                    return true;
                }
                String isStartSeparate = ConfigServer.getServer().getInitProperty("SEPARATION_OF_THREE_POWERS");
                boolean isSecAdmin = user.isSecurityAdmin();
                if ("true".equalsIgnoreCase(isStartSeparate) && isSecAdmin && this.m_bInRightSetPage) {
                    return true;
                }
                if (host instanceof WebSite) {
                    String isPermitView = ConfigServer.getServer().getSysConfigValue("CREATER_CAN_SEE_OWN_SITE", "true");
                    if (host == null || !isPermitView.equalsIgnoreCase("true") || !((User)_aUser).getName().equalsIgnoreCase(host.getCrUserName())) break;
                    return true;
                }
                if (host instanceof Channel) {
                    String isPermitView = ConfigServer.getServer().getSysConfigValue("CREATER_CAN_SEE_OWN_CHANNEL", "true");
                    if (host == null || !isPermitView.equalsIgnoreCase("true") || !((User)_aUser).getName().equalsIgnoreCase(host.getCrUserName())) break;
                    return true;
                }
                if (host == null || !user.getName().equalsIgnoreCase(host.getCrUserName())) break;
                return true;
            }
            case 203: {
                Role role = (Role)_aUser;
                if (!role.isAdministrators()) break;
                return true;
            }
        }
        return false;
    }

    public boolean hasRight(Channel _channel) throws WCMException {
        boolean bExcludeSelf = this.currRequestHelper.getBoolean("ExcludeSelf", false);
        if (this.m_oCurrChannel != null && bExcludeSelf && _channel.getId() == this.m_oCurrChannel.getId()) {
            return false;
        }
        String sExcludeChannelIds = this.currRequestHelper.getString("ExcludeChannelIds");
        if (sExcludeChannelIds != null && sExcludeChannelIds.length() > 0 && ("," + sExcludeChannelIds + ",").indexOf("," + _channel.getId() + ",") >= 0) {
            return false;
        }
        boolean bExcludeVirtual = this.currRequestHelper.getBoolean("ExcludeVirtual", false);
        if (bExcludeVirtual && _channel.isVirtual()) {
            return false;
        }
        boolean bOnlyMyChildren = this.currRequestHelper.getBoolean("OnlyMyChildren", false);
        int nCurrChannelId = this.currRequestHelper.getInt("CurrChannelId", 0);
        if (bOnlyMyChildren && nCurrChannelId > 0) {
            boolean bExclude = true;
            for (Channel tmp = _channel; tmp != null; tmp = tmp.getParent()) {
                if (tmp.getId() == nCurrChannelId) {
                    bExclude = false;
                    break;
                }
                if (tmp.getParentId() <= 0) break;
            }
            if (bExclude) {
                return false;
            }
        }
        boolean bIsLink = _channel.getType() == 11;
        boolean bExcludeLink = this.currRequestHelper.getBoolean("ExcludeLink", false);
        if (bExcludeLink && bIsLink) {
            return false;
        }
        boolean bIsInfoview = _channel.getType() == 13;
        boolean bExcluedeInfoview = this.currRequestHelper.getBoolean("ExcludeInfoview", true);
        if (bExcluedeInfoview && bIsInfoview) {
            return false;
        }
        boolean bIsHostTop = _channel.getType() == 2 || _channel.getType() == 1;
        boolean bExcludeTop = this.currRequestHelper.getBoolean("ExcludeTop", false);
        if (bExcludeTop && bIsHostTop) {
            return false;
        }
        boolean bExcludeOnlySearch = this.currRequestHelper.getBoolean("ExcludeOnlySearch", false);
        if (bExcludeOnlySearch && _channel.isVirtual() && !bIsHostTop) {
            return false;
        }
        boolean bExcludeParent = this.currRequestHelper.getBoolean("ExcludeParent", false);
        if (this.m_oCurrChannel != null && bExcludeParent && _channel.getId() == this.m_oCurrChannel.getParentId()) {
            return false;
        }
        if (this.hasSuperRight(_channel, this.m_oViewer)) {
            return true;
        }
        return this.hasRight(_channel, this.m_nRightIndex);
    }

    private void writeHTMLFromObjects(List objects) throws Exception {
        this.writeHTMLFromObjects(objects, false, 0);
    }

    private void writeHTMLFromObjects(List objects, boolean _bWriteChildrenHTML, int _nCurrLevel) throws Exception {
        String sTabContent = this.makeTabContent(_nCurrLevel);
        int nSize = objects.size();
        for (int i = 0; i < nSize; ++i) {
            BaseChannel host = (BaseChannel)objects.get(i);
            if (host == null || !this.isVisibleOnLoadFromPath(host)) continue;
            if (this.m_bInRightSetPage) {
                if (this.m_bInViewOperSetPage) {
                    this.writeBaseChannelHTMLOfViewOperSet(host);
                    continue;
                }
                this.writeBaseChannelHTMLOfRightSet(host);
                continue;
            }
            this.writeBaseChannelHTML(host, _bWriteChildrenHTML, _nCurrLevel, sTabContent);
        }
    }

    private boolean isVisibleOnLoadFromPath(BaseChannel _oSiteOrChannel) throws WCMException {
        if (!this.m_bLoadFromPath) {
            return true;
        }
        if (_oSiteOrChannel.isSite()) {
            return WebSiteHelper.isVisible(this.m_oLoginUser, (WebSite)_oSiteOrChannel);
        }
        if (this.m_nRightIndex == 42) {
            for (int i = 0; i < WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS.length; ++i) {
                if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)_oSiteOrChannel.getSite(), WCMRightTypes.SET_FLOW_EMPLOY_RIGHTS[i])) continue;
                return true;
            }
            return false;
        }
        return AuthServer.hasRight(this.m_oLoginUser, (CMSObj)_oSiteOrChannel, 64);
    }

    private void writeBaseChannelHTMLOfRightSet(BaseChannel host) throws Exception {
        boolean canSetRight = true;
        String isStartSeparate = ConfigServer.getServer().getInitProperty("SEPARATION_OF_THREE_POWERS");
        if (!("true".equalsIgnoreCase(isStartSeparate) || this.m_oLoginUser.isSecurityAdmin() || this.m_bInRightSetPage || this.m_oViewer != this.m_oLoginUser)) {
            if (host.getWCMType() == 103) {
                if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)host, 7)) {
                    canSetRight = false;
                }
            } else if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)host, 55)) {
                canSetRight = false;
            }
        }
        List<Channel> lChildren = host.getChildren(null);
        this.out.print("<span id=\"" + (host.isSite() ? "s" : "c") + "_" + host.getId() + "\" desc=\"" + CMyString.transDisplay(host.getDispDesc()) + "\" hasChild=\"" + (lChildren != null && !lChildren.isEmpty()) + "\" classPre =\"" + this.getClassPre(host) + "\"" + this.getExtraHTMLAttribute(host) + this.getExtraAttrOfA(host) + "canSetRight = \"" + canSetRight + "\"" + this.getRightIdAttribute(host) + "></span>");
    }

    private String getRightIdAttribute(BaseChannel host) throws Exception {
        int _nObjId;
        int _nObjType = host.isSite() ? 103 : 101;
        Right right = Right.findBy(_nObjType, _nObjId = host.getId(), this.m_nOperatorType, this.m_nOperatorId);
        if (right != null) {
            return " RightId='" + right.getId() + "'";
        }
        return "";
    }

    private List getChildren(BaseChannel _parentChannel, int _nRightIndex) throws WCMException {
        if (_parentChannel == null) {
            throw new WCMException(10, I18NMessage.get(TreeCreator.class, "TreeCreator.label22", "\u9891\u9053\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u5f97\u5176\u5b50\u9891\u9053\uff01"));
        }
        List<Channel> listChildren = _parentChannel.getChildren(null);
        if (this.hasSuperRight(null, this.m_oViewer)) {
            return listChildren;
        }
        for (int i = listChildren.size() - 1; i >= 0; --i) {
            BaseChannel currObj = listChildren.get(i);
            if (currObj != null && this.hasRight(currObj, _nRightIndex)) continue;
            listChildren.remove(i);
        }
        return listChildren;
    }

    private void writeLevelHTMLOfAPath(int _nParentLevel) throws Exception {
        if (_nParentLevel >= this.m_pObjectTypes.length) {
            return;
        }
        switch (this.m_pObjectTypes[_nParentLevel]) {
            case 1: {
                WebSites sites = this.getWebSites(this.m_pObjectIds[_nParentLevel]);
                this.writeHTMLFromObjects(sites, true, _nParentLevel + 1);
                break;
            }
            case 103: {
                WebSite site = WebSite.findById(this.m_pObjectIds[_nParentLevel]);
                List channels = this.getChildren(site, 64);
                this.writeHTMLFromObjects(channels, true, _nParentLevel + 1);
                break;
            }
            case 101: {
                Channel channel = Channel.findById(this.m_pObjectIds[_nParentLevel]);
                this.writeHTMLFromObjects(this.getChildren(channel, 64), true, _nParentLevel + 1);
                break;
            }
        }
    }

    private void extractNodeInfo(String[] _pNodeIds) throws WCMException {
        this.m_pObjectTypes = new int[_pNodeIds.length];
        this.m_pObjectIds = new int[_pNodeIds.length];
        for (int i = 0; i < _pNodeIds.length; ++i) {
            int nPos = _pNodeIds[i].indexOf(95);
            if (nPos <= 0) {
                throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label23", "\u548c\u7ea6\u5b9a\u7684\u6570\u636e\u4e0d\u4e00\u81f4\uff01"));
            }
            this.m_pObjectIds[i] = Integer.parseInt(_pNodeIds[i].substring(nPos + 1));
            String sNodeType = _pNodeIds[i].substring(0, nPos);
            if (sNodeType.equalsIgnoreCase("r")) {
                this.m_pObjectTypes[i] = 1;
                continue;
            }
            if (sNodeType.equalsIgnoreCase("s")) {
                this.m_pObjectTypes[i] = 103;
                continue;
            }
            if (sNodeType.equalsIgnoreCase("c")) {
                this.m_pObjectTypes[i] = 101;
                continue;
            }
            throw new WCMException(I18NMessage.get(TreeCreator.class, "TreeCreator.label24", "\u4e0d\u80fd\u8bc6\u522b\u7684\u7c7b\u578b[") + sNodeType + "]\uff01");
        }
    }

    private String makeTabContent(int _nTabLevel) {
        if (_nTabLevel <= 0) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer(_nTabLevel & 4);
        for (int i = 0; i < _nTabLevel; ++i) {
            sbResult.append("   ");
        }
        return sbResult.toString();
    }

    private int[] getSiteTypesOfChannels(String _sChannelIds) throws Exception {
        return new int[]{this.getSiteTypeOfChannel(CMyString.splitToInt(_sChannelIds, ",")[0])};
    }

    private int getSiteTypeOfChannel(int _nChannelId) throws Exception {
        String SQL_GET_SITETYPE = "select SiteType from WCMWebSite where exists(select WCMChannel.ChannelId from WCMChannel  where WCMChannel.ChannelId=? and WCMChannel.SiteId=WCMWebSite.SiteId)";
        int nFirstLoadSiteType = DBManager.getDBManager().sqlExecuteIntQuery("select SiteType from WCMWebSite where exists(select WCMChannel.ChannelId from WCMChannel  where WCMChannel.ChannelId=? and WCMChannel.SiteId=WCMWebSite.SiteId)", new int[]{_nChannelId});
        return nFirstLoadSiteType;
    }

    private void writeBaseChannelHTMLOfViewOperSet(BaseChannel host) throws Exception {
        boolean canSetRight = true;
        String isStartSeparate = ConfigServer.getServer().getInitProperty("SEPARATION_OF_THREE_POWERS");
        if (!("true".equalsIgnoreCase(isStartSeparate) || this.m_oLoginUser.isSecurityAdmin() || this.m_bInRightSetPage || this.m_oViewer != this.m_oLoginUser)) {
            if (host.getWCMType() == 103) {
                if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)host, 7)) {
                    canSetRight = false;
                }
            } else if (!AuthServer.hasRight(this.m_oViewer, (CMSObj)host, 55)) {
                canSetRight = false;
            }
        }
        List<Channel> lChildren = host.getChildren(null);
        ObjectMember objMember = this.oObjectMemberMgr.getObjectMember(this.m_nOperatorType, this.m_nOperatorId, host.getWCMType(), host.getId());
        int nObjectMemberId = 0;
        boolean bVisible = false;
        boolean bDoOperation = false;
        if (objMember != null) {
            nObjectMemberId = objMember.getId();
            bVisible = objMember.isVisible();
            bDoOperation = objMember.isDoOperation();
        }
        this.out.print("<span id=\"" + (host.isSite() ? "s" : "c") + "_" + host.getId() + "\" desc=\"" + CMyString.transDisplay(host.getDispDesc()) + "\" hasChild=\"" + (lChildren != null && !lChildren.isEmpty()) + "\" classPre =\"" + this.getClassPre(host) + "\"" + this.getExtraHTMLAttribute(host) + this.getExtraAttrOfA(host) + " canSetRight = \"" + canSetRight + "\" visible = \"" + bVisible + "\" doOperation = \"" + bDoOperation + "\" objectMemberId = \"" + nObjectMemberId + "\"></span>");
        if (!this.m_bGetAllChildren) {
            return;
        }
        List channels = this.getChildren(host, 64);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            BaseChannel channel = (BaseChannel)channels.get(i);
            if (channel == null) continue;
            this.writeBaseChannelHTMLOfViewOperSet(channel);
        }
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis());
    }
}

