/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mas;

import com.trs.infra.common.WCMException;
import com.trs.infra.config.BaseConfigServer;
import com.trs.infra.support.config.ConfigServer;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class MASClientServer
extends BaseConfigServer {
    private static Logger logger = Logger.getLogger(MASClientServer.class);
    private ThreadSafeClientConnManager cm = null;
    private static int nCurrIndex = 0;
    private static MASClientServer server = null;
    private static Random r = new Random();

    @Override
    protected void doShutdown() {
        if (this.cm != null) {
            this.cm.shutdown();
        }
    }

    @Override
    protected boolean doStart() throws WCMException {
        try {
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            int nMaxPerRouteCount = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("MAX_PER_ROUTE_COUNT", "100"));
            this.cm = new ThreadSafeClientConnManager(schemeRegistry);
            this.cm.setMaxTotal(nMaxPerRouteCount * 5);
            this.cm.setDefaultMaxPerRoute(nMaxPerRouteCount);
            return true;
        }
        catch (Throwable e) {
            throw new WCMException("Fail to startup MAS Client server", e);
        }
    }

    public HttpClient getHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        params.setParameter("http.connection.timeout", (Object)8000);
        return new DefaultHttpClient((ClientConnectionManager)this.cm, (HttpParams)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentFromURL(String _sURL) throws Exception {
        HttpGet get = null;
        try {
            HttpClient client = this.getHttpClient();
            get = new HttpGet(_sURL);
            HttpResponse response = client.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            String sResult = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = sResult;
                return string;
            }
            logger.warn((Object)("Fail to get URL[" + _sURL + "]"));
            logger.warn((Object)sResult);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            server = new MASClientServer();
            server.startup();
            while (nCurrIndex < 1000) {
                new Thread(){
                    private int m_nIndex = MASClientServer.access$000();

                    @Override
                    public void run() {
                        try {
                            System.out.println(this.m_nIndex + "......");
                            long lStart = System.currentTimeMillis();
                            String sURL = "http://bbs.trs.net.cn/mas/openapi/pages.do?method=exQuery&appKey=TRSWCMrao&id=3160,3135";
                            String sValue = server.getContentFromURL(sURL + "&r=" + r.nextInt(5000));
                            System.out.println(sValue);
                            System.out.println(this.m_nIndex + " use[" + (System.currentTimeMillis() - lStart) + "]ms");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
                ++nCurrIndex;
            }
            Thread.sleep(600000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (server != null) {
                server.shutdown();
            }
        }
    }

    static /* synthetic */ int access$000() {
        return nCurrIndex;
    }
}

