/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.upgrade.sql;

import com.trs.infra.util.store.FileService;
import com.trs.infra.util.upgrade.DbConfig;
import com.trs.infra.util.upgrade.dbcompare.MetaDataLoader;
import com.trs.infra.util.upgrade.dbcompare.SchemaCompare;
import com.trs.infra.util.upgrade.dbcompare.TableDiff;
import com.trs.infra.util.upgrade.sql.SchemaUpdSqlMaker;
import com.trs.infra.util.upgrade.sql.SchemaUpdSqlMakerFactory;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiffSqlMaker {
    private String dbconf;
    private String output;

    public DiffSqlMaker(String dbconf, String output) {
        this.dbconf = dbconf;
        this.output = output;
    }

    public void make() throws Exception {
        DbConfig conf = new DbConfig();
        conf.load(this.dbconf);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileService(this.output).getOutputStream(), "GBK"));
        Class.forName(conf.getJdbcDriver());
        Connection source = DriverManager.getConnection(conf.getOldUrl(), conf.getOldUser(), conf.getOldPasswd());
        Connection dest = DriverManager.getConnection(conf.getNewUrl(), conf.getNewUser(), conf.getNewPasswd());
        MetaDataLoader olddb = new MetaDataLoader(source, conf.getOldSchema());
        MetaDataLoader newdb = new MetaDataLoader(dest, conf.getNewSchema());
        SchemaCompare compare = new SchemaCompare(olddb, newdb);
        Comparator tableDiffComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TableDiff diff0 = (TableDiff)arg0;
                TableDiff diff1 = (TableDiff)arg1;
                return diff0.getTableName().compareTo(diff1.getTableName());
            }
        };
        List list = compare.getDiff4Source();
        Collections.sort(list, tableDiffComparator);
        SchemaUpdSqlMaker sqlMaker = SchemaUpdSqlMakerFactory.makeSqlMaker(conf.getDbtype());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            for (String sql : sqlMaker.getSql((TableDiff)list.get(i))) {
                if (sql == null || sql.length() <= 0) continue;
                writer.write(sql);
                writer.write("\n\r");
            }
            writer.flush();
        }
        writer.close();
        source.close();
        dest.close();
    }

    public static void main(String[] args) throws Exception {
        DiffSqlMaker maker = new DiffSqlMaker(args[0], args[1]);
        maker.make();
    }
}

