/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

import com.trs.infra.util.uftp.ChainNode;
import java.util.Iterator;

class ChainList {
    private ChainNode m_pole;
    private int m_size = 0;

    public ChainList() {
        this.m_pole.m_next = this.m_pole = new ChainNode();
        this.m_pole.m_prev = this.m_pole;
    }

    public synchronized boolean cut(ChainNode node) {
        if (this.m_size == 0) {
            return false;
        }
        if (node.m_next == null || node.m_prev == null) {
            return false;
        }
        node.m_next.m_prev = node.m_prev;
        node.m_prev.m_next = node.m_next;
        node.m_prev = null;
        node.m_next = null;
        node.m_list = null;
        --this.m_size;
        return true;
    }

    public synchronized ChainNode get() {
        if (this.m_size == 0) {
            return null;
        }
        ChainNode head = this.m_pole.m_next;
        head.m_prev.m_next = head.m_next;
        head.m_next.m_prev = head.m_prev;
        head.m_prev = null;
        head.m_next = null;
        head.m_list = null;
        --this.m_size;
        return head;
    }

    public synchronized void put(ChainNode node) {
        if (node.m_next != null || node.m_prev != null) {
            return;
        }
        ChainNode tail = this.m_pole.m_prev;
        tail.m_next = node;
        node.m_list = this;
        node.m_next = this.m_pole;
        node.m_prev = tail;
        this.m_pole.m_prev = node;
        ++this.m_size;
    }

    public int size() {
        return this.m_size;
    }

    public Iterator values() {
        return new Iterator(){
            ChainNode m_peek;
            {
                this.m_peek = ChainList.this.m_pole;
            }

            @Override
            public boolean hasNext() {
                return this.m_peek.m_next != ChainList.this.m_pole;
            }

            public Object next() {
                this.m_peek = this.m_peek.m_next;
                return this.m_peek;
            }

            @Override
            public void remove() {
            }
        };
    }
}

