/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.key;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MacAddressHelper {
    public static final boolean IS_DEBUG = false;

    public static boolean isValidMac(long _lMac) {
        if (_lMac == Long.parseLong("123456789012")) {
            return true;
        }
        int nMaxValidCount = 10;
        for (int i = 0; i < nMaxValidCount; ++i) {
            if (MacAddressHelper.getMyMacAsLong(i) != _lMac) continue;
            return true;
        }
        return false;
    }

    public static long getMyMacAsLong(int _nIndex) {
        String sMac = MacAddressHelper.getMyMac(_nIndex);
        return MacAddressHelper.getMyMacAsLong(sMac);
    }

    public static long getMyMacAsLong() {
        return MacAddressHelper.getMyMacAsLong(0);
    }

    public static long getMyMacAsLong(String _sMac) {
        if (_sMac == null || _sMac.length() <= 0) {
            return 0L;
        }
        String sMac = _sMac;
        sMac = CMyString.replaceStr(sMac, "-", "");
        long nMac = Long.parseLong(sMac, 16);
        sMac = "" + nMac;
        if (sMac.length() > 12) {
            sMac = sMac.substring(0, 12);
            while (sMac.charAt(0) == '0' && sMac.length() > 0) {
                sMac = sMac.substring(1, sMac.length());
            }
            nMac = Long.parseLong(sMac);
        }
        return nMac;
    }

    private static String getMacOnWindow(int _nIndex) {
        String s = "";
        try {
            String s1 = "ipconfig /all";
            Process process = Runtime.getRuntime().exec(s1);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine();
            int nIndex = 0;
            while (line != null) {
                String nextLine = bufferedreader.readLine();
                if (line.indexOf("Physical Address") != -1 || line.indexOf(I18NMessage.get(MacAddressHelper.class, "MacAddressHelper.label1", "\u7269\u7406\u5730\u5740")) != -1) {
                    if (nIndex == _nIndex) {
                        s = line.split(":")[1].trim();
                        break;
                    }
                    ++nIndex;
                }
                line = nextLine;
            }
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            s = "";
        }
        return s.trim();
    }

    private static String getMacOnLinux(int _nIndex) {
        String s = "";
        try {
            String s1 = "/sbin/ifconfig -a";
            Process process = Runtime.getRuntime().exec(s1);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine().toUpperCase();
            int nIndex = 0;
            while (line != null) {
                String nextLine = bufferedreader.readLine();
                if (line.indexOf("HWADDR") > 0) {
                    if (nIndex == _nIndex) {
                        int i = line.indexOf("HWADDR") + 7;
                        s = line.substring(i);
                        break;
                    }
                    ++nIndex;
                }
                line = nextLine.toUpperCase();
            }
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            s = "";
        }
        return s.trim().replace(':', '-');
    }

    private static String getMacOnHP(int _nIndex) {
        String s = "";
        try {
            String s1 = "/usr/sbin/lanscan";
            Process process = Runtime.getRuntime().exec(s1);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine().toUpperCase();
            int nIndex = 0;
            while (line != null) {
                String nextLine = bufferedreader.readLine();
                int nPose = line.indexOf("0X");
                if (nPose > 0) {
                    if (nIndex == _nIndex) {
                        int nStart = nPose + 2;
                        int nEnd = line.indexOf(" ", nStart);
                        s = line.substring(nStart, nEnd);
                        break;
                    }
                    ++nIndex;
                }
                line = nextLine.toUpperCase();
            }
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            s = "";
        }
        return s.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMacOnSolaris(int _nIndex) {
        String s = "";
        Process process = null;
        try {
            String s1 = "/usr/sbin/ifconfig -a";
            process = Runtime.getRuntime().exec(s1);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine().toUpperCase();
            int nIndex = 0;
            while (line != null) {
                String nextLine = bufferedreader.readLine().toUpperCase();
                if (line.indexOf("NEI0") > 0) {
                    int nEnd;
                    int nStart = nextLine.indexOf("INET") + 5;
                    if (nStart < 5 || (nEnd = nextLine.indexOf(" ", nStart)) <= nStart) break;
                    if (nIndex == _nIndex) {
                        s = nextLine.substring(nStart, nEnd);
                        break;
                    }
                    ++nIndex;
                }
                line = nextLine;
            }
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception exception) {
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        if (s == null || s.length() <= 8) {
            s = MacAddressHelper.getMacOnSolaris2(_nIndex);
        }
        if (s == null || s.length() < 8) {
            return MacAddressHelper.getMacOnSolaris3();
        }
        return CMyString.replaceStr(s, ".", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMacOnSolaris3() {
        String result = "";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec("netstat -pn");
            InputStream pis = proc.getInputStream();
            final InputStream per = proc.getErrorStream();
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        int a = 0;
                        while ((a = per.read()) != -1) {
                            baos.write(a);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            t.start();
            int a = 0;
            while ((a = pis.read()) != -1) {
                baos.write(a);
            }
            t.join();
            result = new String(baos.toByteArray());
            int ix = result.indexOf("SP");
            if (ix != -1) {
                result = result.substring(ix + 2);
                while (result.startsWith(" ")) {
                    result = result.substring(1);
                }
                result = result.substring(0, 17);
                String string = result.replaceAll(":", "");
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
        }
        return result;
    }

    private static String getMacOnSolaris2(int _nIndex) {
        String s = "";
        try {
            String s1 = "/usr/sbin/ifconfig -a";
            Process process = Runtime.getRuntime().exec(s1);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine().toUpperCase();
            int nIndex = 0;
            while (line != null) {
                int nStart = (line = line.toUpperCase()).indexOf("ETHER");
                if (nStart >= 0) {
                    if (nIndex == _nIndex) {
                        int nEnd = line.indexOf(" ", nStart += 6);
                        if (nEnd <= 0) {
                            nEnd = line.length();
                        }
                        s = line.substring(nStart, nEnd).trim();
                        break;
                    }
                    ++nIndex;
                }
                line = bufferedreader.readLine();
            }
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(MacAddressHelper.class, "MacAddressHelper.label2", "\u83b7\u53d6Sun Solaris\u64cd\u4f5c\u7cfb\u7edf\u7684Mac\u5730\u5740\u5931\u8d25\uff01(getMacOnSolaris2)"));
            ex.printStackTrace();
        }
        s = CMyString.replaceStr(s, ".", "");
        s = CMyString.replaceStr(s, ":", "");
        return s;
    }

    private static String getMacOnAIX(int _nIndex) {
        String s = "";
        try {
            String line;
            String s1 = "/usr/bin/uname -m";
            Process process = Runtime.getRuntime().exec(s1);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            s = line = bufferedreader.readLine().toUpperCase();
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            s = "";
        }
        return s.trim();
    }

    public static String getMyMac(int _nIndex) {
        String sOs = System.getProperty("os.name", "");
        if (CMyString.isEmpty(sOs)) {
            sOs = (String)System.getProperties().get("os.name");
        }
        if (CMyString.isEmpty(sOs)) {
            System.out.println("Can't obatain the os name at runtime!");
            System.out.println("So can't mark the machine.");
            return "";
        }
        if ((sOs = sOs.toUpperCase()).indexOf("WINDOWS") >= 0) {
            return MacAddressHelper.getMacOnWindow(_nIndex);
        }
        if (sOs.indexOf("HP") >= 0) {
            return MacAddressHelper.getMacOnHP(_nIndex);
        }
        if (sOs.indexOf("LINUX") >= 0) {
            return MacAddressHelper.getMacOnLinux(_nIndex);
        }
        if (sOs.indexOf("SOLARIS") >= 0 || sOs.indexOf("SUNOS") >= 0) {
            return MacAddressHelper.getMacOnSolaris(_nIndex);
        }
        if (sOs.indexOf("AIX") >= 0) {
            return MacAddressHelper.getMacOnAIX(_nIndex);
        }
        if (sOs.indexOf("FREEBSD") != -1) {
            return MacAddressHelper.getMacOnFreeBSD(_nIndex);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMacOnFreeBSD(int index) {
        InputStream ins = null;
        InputStreamReader insr = null;
        BufferedReader reader = null;
        String result = "";
        try {
            String cmd = "/sbin/ifconfig -a";
            Process process = Runtime.getRuntime().exec(cmd);
            ins = process.getInputStream();
            insr = new InputStreamReader(ins);
            reader = new BufferedReader(insr);
            String line = reader.readLine();
            int nIndex = 0;
            while (line != null) {
                if ((line = line.toUpperCase()).indexOf("ETHER") != -1) {
                    if (nIndex == index) {
                        result = line.trim().split(" ")[1];
                        break;
                    }
                    ++nIndex;
                }
                line = reader.readLine();
            }
            process.waitFor();
        }
        catch (Exception exception) {
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (Exception exception) {}
            }
            if (insr != null) {
                try {
                    insr.close();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return result.trim().replace(':', '-');
    }

    public static void main(String[] args) {
        try {
            System.out.println(MacAddressHelper.getMyMacAsLong(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

