/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.testmove;

import com.trs.exchange.DataMigrationLogger;
import com.trs.exchange.MyDBManager;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;

public class CommonUtil {
    protected MyDBManager m_oDBMgr = null;
    protected FilesMan filesMan = null;
    protected DataMigrationLogger m_oDLogger = null;
    private static Logger logger = Logger.getLogger(CommonUtil.class);

    public static void finallyClose(ResultSet result, PreparedStatement oPreStmt, Connection oConn, MyDBManager m_oDBMgr) {
        if (result != null) {
            try {
                result.close();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close result", (Throwable)e);
            }
        }
        if (oPreStmt != null) {
            try {
                oPreStmt.close();
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
            }
        }
        if (oConn != null) {
            m_oDBMgr.freeConnection(oConn);
        }
    }

    public void initLogger(int tableType) throws Exception {
        this.m_oDLogger = new DataMigrationLogger(this.m_oDBMgr.getSrcNameOfDB(), tableType);
        String sLogFilePath = this.filesMan.getPathConfigValue("N0", 0);
        sLogFilePath = CMyString.setStrEndWith(sLogFilePath, File.separatorChar);
        String sLogFileName = sLogFilePath + "exchange_" + this.m_oDBMgr.getSrcNameOfDB() + ".log";
        PatternLayout layout = new PatternLayout("[ExchangeLog] %m - %d - %-5p %x  - %c%l -%-4r [%t] %n");
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)new FileOutputStream(sLogFileName, true));
        appender.setEncoding("UTF-8");
        logger.removeAllAppenders();
        logger.addAppender((Appender)appender);
    }

    protected void warn(String _sInfo, Exception _ex) throws WCMException {
        logger.error((Object)_sInfo, (Throwable)_ex);
    }

    protected void error(String _sInfo) throws WCMException {
        this.error(_sInfo, null);
    }

    protected void error(String _sInfo, Exception _ex) throws WCMException {
        logger.error((Object)_sInfo, (Throwable)_ex);
        throw new WCMException(_sInfo, _ex);
    }
}

