/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.document;

import com.trs.components.wcm.content.persistent.Document;
import com.trs.exchange.MyDBManager;
import com.trs.exchange.document.DocumentExchange;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import java.util.List;

public class DocumentExchangeFromWCM
extends DocumentExchange {
    private String m_sWCMDataPath = "g:/wcmdata/";
    private WCMFilter[] m_pFilterForQueryAppendixes = new WCMFilter[]{new WCMFilter("WCMAppendix", "AppDocId=? and AppFlag=20", "APPSERN", "SrcFile,AppFile,FileExt, AppFileType, AppFlag,  AppDesc, AppLinkAlt, AppProp,AppTime,AppAuthor,CRUSER,CrTime"), new WCMFilter("WCMAppendix", "AppDocId=? and AppFlag=10", "APPSERN", "SrcFile,AppFile,FileExt, AppFileType, AppFlag,  AppDesc, AppLinkAlt, AppProp,AppTime,AppAuthor,CRUSER,CrTime"), new WCMFilter("WCMAppendix", "AppDocId=? and AppFlag=40", "APPSERN", "SrcFile,AppFile,FileExt, AppFileType, AppFlag,  AppDesc, AppLinkAlt, AppProp,AppTime,AppAuthor,CRUSER,CrTime")};
    private FilesMan m_oDstWCMFilesMan = null;

    public DocumentExchangeFromWCM(MyDBManager _dbMgr) {
        super(_dbMgr);
    }

    public void setWCMDataRootPath(String _sWCMDataRootPath) {
        this.m_sWCMDataPath = _sWCMDataRootPath;
        this.m_sWCMDataPath = CMyString.setStrEndWith(_sWCMDataRootPath, File.separatorChar);
        this.m_oDstWCMFilesMan = FilesMan.getFilesMan();
    }

    @Override
    protected String makeResFullPathName(Document _document, String _sResName, boolean _bAppendix) throws Exception {
        try {
            String sFileName = CMyFile.extractFileName(_sResName);
            String sAbsolutePath = this.m_oDstWCMFilesMan.mapFilePath(sFileName, 0);
            int nPos = sAbsolutePath.toUpperCase().indexOf("WCMDATA");
            if (nPos <= 0) {
                throw new WCMException("\u76ee\u6807WCMData\u548c\u9884\u671f\u89c4\u5219\u4e0d\u4e00\u81f4\uff01[" + sAbsolutePath + "]");
            }
            return this.m_sWCMDataPath + sAbsolutePath.substring(nPos + 8) + sFileName;
        }
        catch (Exception e) {
            this.warn("Fail to dowith the file[" + _sResName + "]!Document:[" + _document + "]", e);
            return _sResName;
        }
    }

    @Override
    protected WCMFilter[] makeFilterQueryAppendixOfDocument(Document _document) {
        for (int i = 0; i < this.m_pFilterForQueryAppendixes.length; ++i) {
            WCMFilter filter = this.m_pFilterForQueryAppendixes[i];
            filter.addSearchValues(0, _document.getOutUpId());
        }
        return this.m_pFilterForQueryAppendixes;
    }

    @Override
    protected List makeAppendixesOfDocument(Document _document) throws Exception {
        return null;
    }
}

