/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version.config;

import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.version.config.RelationObjectVersionConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.persistent.IConfigElement;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectVersionConfig
implements IConfigElement {
    private String id;
    private String m_sName;
    private String m_sClass;
    private String m_sDesc;
    private int right;
    private String m_sTitleDesc;
    private boolean m_build;
    private String m_sExcludeFields;
    private Map<String, Object> m_hRelationObjects = new HashMap<String, Object>();
    private boolean isValid;
    private boolean isVerify = false;
    private int iMaximumVersion;

    public int getMaximumVersion() {
        return this.iMaximumVersion;
    }

    public void setMaximumVersion(int _iMaximumVersion) {
        this.iMaximumVersion = _iMaximumVersion;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void setName(String name) {
        this.m_sName = name;
    }

    public String getClassname() {
        return this.m_sClass;
    }

    public void setClassname(String class1) {
        this.m_sClass = class1;
    }

    public String getDesc() {
        return this.m_sDesc;
    }

    public void setDesc(String desc) {
        this.m_sDesc = desc;
    }

    public String getTitledesc() {
        return this.m_sTitleDesc;
    }

    public void setTitledesc(String titleDesc) {
        this.m_sTitleDesc = titleDesc;
    }

    public boolean isBuild() {
        return this.m_build;
    }

    public void setBuild(boolean _biuld) {
        this.m_build = _biuld;
    }

    public String getExcludefields() {
        return this.m_sExcludeFields;
    }

    public void setExcludefields(String excludeFields) {
        this.m_sExcludeFields = excludeFields;
    }

    public Map<String, Object> getRelations() {
        return this.m_hRelationObjects;
    }

    public void setRelations(Map<String, Object> relationObjects) {
        this.m_hRelationObjects = relationObjects;
    }

    public List<Map.Entry<String, Object>> getSortRelations() {
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(this.m_hRelationObjects.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                if (o1 == null || o1.getKey() == null) {
                    return 0;
                }
                if (o2 == null || o2.getKey() == null) {
                    return 0;
                }
                return o1.getKey().split("\\.").length - o2.getKey().split("\\.").length;
            }
        });
        return list;
    }

    public String[] getExcludeFields() {
        String sExcludeFields = this.getExcludefields();
        if (sExcludeFields != null && !CMyString.isEmpty(sExcludeFields)) {
            return sExcludeFields.split(",");
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() throws WCMException {
        if (this.isVerify) {
            return this.isValid;
        }
        ObjectVersionConfig objectVersionConfig = this;
        synchronized (objectVersionConfig) {
            if (this.isVerify) {
                return this.isValid;
            }
            this.isValid = this.doVerify();
            this.isVerify = true;
            return this.isValid;
        }
    }

    private boolean doVerify() throws WCMException {
        try {
            CMSObj cmsObj = (CMSObj)Class.forName(this.m_sClass).newInstance();
            DBManager oManager = DBManager.getDBManager();
            String sTableName = cmsObj.getDbTableName();
            if (sTableName == null) {
                return true;
            }
            String[] excludeFields = this.getExcludeFields();
            if (excludeFields != null) {
                for (int i = 0; i < excludeFields.length; ++i) {
                    if (oManager.getFieldInfo(sTableName, excludeFields[i].trim().toUpperCase()) != null) continue;
                    throw new WCMException("\u9a8c\u8bc1" + cmsObj.getClassName(true) + "\uff1a\u6570\u636e\u8868-" + sTableName + "\u6392\u9664\u5b57\u6bb5" + excludeFields[i] + "\u9519\u8bef");
                }
            }
            if (this.right <= 0) {
                throw new WCMException("\u9a8c\u8bc1" + cmsObj.getClassName(true) + "\uff1a\u6743\u9650\u914d\u7f6e\u9519\u8bef");
            }
            List<Map.Entry<String, Object>> relations = this.getSortRelations();
            HashMap<String, String> hTables = new HashMap<String, String>();
            if (!CMyString.isEmpty(this.id)) {
                hTables.put(this.id, sTableName);
            }
            for (int i = 0; i < relations.size(); ++i) {
                Map.Entry<String, Object> relation = relations.get(i);
                String sKey = relation.getKey();
                RelationObjectVersionConfig relationConfig = (RelationObjectVersionConfig)relation.getValue();
                String[] sKeys = sKey.split("\\.");
                if (sKeys.length == 1) {
                    if (oManager.getFieldInfo(sTableName, sKey) == null) {
                        throw new WCMException("\u9a8c\u8bc1" + cmsObj.getClassName(true) + " \u6570\u636e\u8868-" + sTableName + " \u5916\u952e" + sKey + " \u9519\u8bef");
                    }
                    CMSBaseObjs cmsObjs = CMSBaseObjs.createInstance(ContextHelper.getLoginUser(), relationConfig.getClassname());
                    String sRelationTableName = ((CMSObj)cmsObjs.getElementClass().newInstance()).getDbTableName();
                    hTables.put(relationConfig.getId(), sRelationTableName);
                    continue;
                }
                if (sKeys.length <= 1) continue;
                String sUpperTableName = (String)hTables.get(sKeys[sKeys.length - 2]);
                if (oManager.getFieldInfo(sUpperTableName, sKeys[sKeys.length - 1].trim().toUpperCase()) == null) {
                    throw new WCMException("\u9a8c\u8bc1" + cmsObj.getClassName(true) + " \u6570\u636e\u8868-" + sUpperTableName + " \u5916\u952e-" + sKeys[sKeys.length - 1] + " \u9519\u8bef");
                }
                if (!relationConfig.isValid()) {
                    return false;
                }
                CMSBaseObjs cmsObjs = CMSBaseObjs.createInstance(ContextHelper.getLoginUser(), relationConfig.getClassname());
                String sRelationTableName = ((CMSObj)cmsObjs.getElementClass().newInstance()).getDbTableName();
                hTables.put(relationConfig.getId(), sRelationTableName);
            }
            return true;
        }
        catch (Exception e) {
            throw new WCMException("\u5bf9\u8c61\u914d\u7f6e\u9519\u8bef", e);
        }
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getRight() {
        return this.right;
    }
}

