/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat.chart;

import com.trs.components.wcm.stat.StatFieldMap;
import com.trs.components.wcm.stat.StatFieldMaps;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.util.CMyString;
import de.laures.cewolf.DatasetProducer;
import java.util.Date;
import java.util.Map;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public final class BarChartProducer
implements DatasetProducer {
    private static final String PRODUCER_ID = "BarChartProducer";
    public static final String PARAM_UNIQUENAME = "UniquerName";
    public static final String PARAM_COMPAREDFIELD = "CompareField";
    public static final String PARAM_VIEWID = "ViewId";
    private transient CMyResultSets statResults = null;
    private transient StatFieldMaps statFieldMaps = null;

    public Object produceDataset(Map _params) {
        String sUniqueName = (String)_params.get(PARAM_UNIQUENAME);
        String sComparedFieldName = (String)_params.get(PARAM_COMPAREDFIELD);
        return this.getDataSet(sUniqueName, sComparedFieldName);
    }

    private CategoryDataset getDataSet(String _sUniqueName, String _sComparedField) {
        int i;
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        CMyResultSets results = this.getStatResults();
        if (results == null || results.size() == 0) {
            return dataset;
        }
        StatFieldMaps fields = this.getStatFieldMaps();
        CMyResultSet result = null;
        Object value = null;
        String[] names = new String[fields.size()];
        String[] descs = new String[names.length];
        for (i = 0; i < fields.size(); ++i) {
            StatFieldMap field = (StatFieldMap)fields.getAt(i);
            names[i] = field.getFieldName();
            descs[i] = field.getFieldDesc();
        }
        if (_sUniqueName == null) {
            result = (CMyResultSet)results.getAt(0);
            for (i = 0; i < names.length; ++i) {
                value = result.getProperty(names[i]);
                if (!(value instanceof Number) || ((Number)value).intValue() == 0) continue;
                dataset.setValue((double)((Number)value).intValue(), (Comparable)((Object)descs[i]), (Comparable)((Object)descs[i]));
            }
            return dataset;
        }
        for (i = 0; i < results.size(); ++i) {
            result = (CMyResultSet)results.getAt(i);
            String sName = this.makeUniqueName(result, _sUniqueName);
            value = result.getProperty(_sComparedField);
            if (!(value instanceof Number)) continue;
            dataset.setValue((double)((Number)value).intValue(), (Comparable)((Object)sName), (Comparable)((Object)descs[this.getIndex(names, _sComparedField)]));
        }
        return dataset;
    }

    private String makeUniqueName(CMyResultSet _result, String _sUniqueName) {
        if (CMyString.isEmpty(_sUniqueName)) {
            return "UniqueName";
        }
        String[] uniquenames = CMyString.split(_sUniqueName, ",");
        String uniqueName = _result.getPropertyAsString(uniquenames[0]);
        for (int i = 1; i < uniquenames.length; ++i) {
            uniqueName = uniqueName + ":" + _result.getPropertyAsString(uniquenames[i]);
        }
        return uniqueName;
    }

    private int getIndex(String[] _fieldNames, String _sFieldName) {
        for (int i = 0; i < _fieldNames.length; ++i) {
            if (!_sFieldName.equalsIgnoreCase(_fieldNames[i])) continue;
            return i;
        }
        throw new RuntimeException();
    }

    public boolean hasExpired(Map _params, Date _since) {
        return false;
    }

    public String getProducerId() {
        return PRODUCER_ID;
    }

    public final CMyResultSets getStatResults() {
        return this.statResults;
    }

    public final void setStatResults(CMyResultSets results) {
        this.statResults = results;
    }

    public final StatFieldMaps getStatFieldMaps() {
        return this.statFieldMaps;
    }

    public final void setStatFieldMaps(StatFieldMaps statFieldMaps) {
        this.statFieldMaps = statFieldMaps;
    }
}

