/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class RollDocumentsChannelsFinder {
    private String m_sQuoteConteteChannelIds = "";
    private IPublishFolder m_oCurrFolder = null;
    private IPublishFolder m_oCurrRoot = null;

    public RollDocumentsChannelsFinder(IPublishFolder _folder) throws WCMException {
        this.m_oCurrFolder = _folder;
        this.m_oCurrRoot = this.m_oCurrFolder.getRoot();
    }

    public String find(TagItem _tagItem) throws WCMException {
        String sChnlType;
        int nChnlId;
        block12: {
            nChnlId = 0;
            sChnlType = _tagItem.getAttributeTrim("CHNLTYPE");
            try {
                String paretnid = _tagItem.getAttributeTrim("PARENTCHANNELID");
                nChnlId = Integer.parseInt(paretnid);
                Channel channel = Channel.findById(nChnlId);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(RollDocumentsChannelsFinder.class, "RollDocumentsChannelsFinder.label1", "\u6307\u5b9a\u7684\u9891\u9053\u6ca1\u6709\u627e\u5230[Id=") + nChnlId + "]!");
                }
                if (channel.isDeleted()) {
                    throw new WCMException(I18NMessage.get(RollDocumentsChannelsFinder.class, "RollDocumentsChannelsFinder.label2", "\u6307\u5b9a\u7684\u9891\u9053[") + channel + I18NMessage.get(RollDocumentsChannelsFinder.class, "RollDocumentsChannelsFinder.label3", "]\u5df2\u5220\u9664!"));
                }
            }
            catch (NumberFormatException e) {
                BaseChannel parent = this.findIdAppointedFolder(_tagItem, true);
                nChnlId = parent.getId();
                if (!parent.isSite()) break block12;
                return this.m_sQuoteConteteChannelIds;
            }
        }
        DBManager manager = DBManager.getDBManager();
        int nLevel = RollDocumentsChannelsFinder.getValueOfTag(_tagItem, "CHILDLEVEL", -1);
        StringBuffer buff = new StringBuffer(256);
        if (!CMyString.isEmpty(sChnlType) && !"0".equals(sChnlType)) {
            StringBuffer sql = new StringBuffer(128);
            sql.append("select channelid from wcmchannel where ");
            sql.append("parentid=? and status=0");
            int[] nTypes = CMyString.splitToInt(sChnlType, ",");
            if (nTypes.length == 1) {
                if (nTypes[0] != -1) {
                    sql.append(" and chnltype=?");
                } else {
                    nTypes = new int[]{};
                }
            } else {
                sql.append(" and chnltype in(?");
                int len = nTypes.length;
                for (int i = 1; i < len; ++i) {
                    sql.append(",?");
                }
                sql.append(")");
            }
            this.getChildIdsWithType(manager, sql.toString(), nLevel, buff, nChnlId, nTypes);
        } else {
            this.getChildIds(manager, nLevel, buff, nChnlId);
        }
        if (buff.length() > 1) {
            this.m_sQuoteConteteChannelIds = buff.substring(1);
        }
        return this.m_sQuoteConteteChannelIds;
    }

    private static int getValueOfTag(TagItem _tagItem, String _sValueName, int _nDefault) {
        int nChildLevel = _nDefault;
        String sValue = _tagItem.getAttributeTrim(_sValueName);
        if (!CMyString.isEmpty(sValue)) {
            nChildLevel = Integer.parseInt(sValue);
        }
        return nChildLevel;
    }

    private BaseChannel findIdAppointedFolder(TagItem _tagItem, boolean _bIsFromAllCataTag) throws WCMException {
        BaseChannel channelOrSite;
        String sName = _tagItem.getAttribute("PARENTCHANNELID");
        int nHashcode = sName == null || (sName = sName.trim()).length() == 0 ? (_bIsFromAllCataTag ? 2545479 : 75627155) : sName.toUpperCase().hashCode();
        switch (nHashcode) {
            case 2545479: {
                try {
                    channelOrSite = (BaseChannel)this.m_oCurrFolder.getSubstance();
                    if (channelOrSite.isSite()) break;
                    channelOrSite = channelOrSite.getSite();
                    break;
                }
                catch (ClassCastException ex) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            case 75627155: {
                channelOrSite = (BaseChannel)this.m_oCurrFolder.getSubstance();
                break;
            }
            case -1942094678: {
                try {
                    channelOrSite = (BaseChannel)this.m_oCurrFolder.getSubstance();
                    if (channelOrSite.isSite()) break;
                    channelOrSite = channelOrSite.getHost();
                    break;
                }
                catch (ClassCastException ex) {
                    throw new WCMException(10, "Upper host must be a channel or a site!");
                }
            }
            default: {
                channelOrSite = Channel.findByName(this.m_oCurrRoot.getId(), sName);
                if (channelOrSite != null) break;
                String sMsg = I18NMessage.get(RollDocumentsChannelsFinder.class, "RollDocumentsChannelsFinder.label4", "\u6307\u5b9a\u7684\u9891\u9053 [") + sName + I18NMessage.get(RollDocumentsChannelsFinder.class, "RollDocumentsChannelsFinder.label5", "]\u5728") + this.m_oCurrRoot.getInfo() + I18NMessage.get(RollDocumentsChannelsFinder.class, "RollDocumentsChannelsFinder.label6", "\u6ca1\u6709\u627e\u5230!");
                throw new WCMException(233, sMsg);
            }
        }
        return channelOrSite;
    }

    private void getChildIdsWithType(DBManager manager, String sql, int nLevel, StringBuffer buff, int nParentId, int[] types) throws WCMException {
        if (nLevel < 0) {
            return;
        }
        PreparedStatement pstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = manager.getConnection();
            pstmt = conn.prepareStatement(sql);
            int ix = 1;
            pstmt.setInt(ix++, nParentId);
            int len = types.length;
            for (int i = 0; i < len; ++i) {
                pstmt.setInt(ix++, types[i]);
            }
            rs = pstmt.executeQuery();
            int nId = 0;
            buff.append(',').append(nParentId);
            while (rs.next()) {
                nId = rs.getInt(1);
                buff.append(',').append(nId);
                this.getChildIdsWithType(manager, sql, nLevel - 1, buff, nId, types);
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(RollDocumentsChannelsFinder.class, "RollDocumentsChannelsFinder.label7", "\u83b7\u53d6\u9891\u9053\u96c6\u5408\u5931\u8d25!"), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                manager.freeConnection(conn);
            }
        }
    }

    private void getChildIds(DBManager manager, int nLevel, StringBuffer buff, int nParentId) throws WCMException {
        if (nLevel < 0) {
            return;
        }
        String sql = "select channelid from wcmchannel where parentid=? and chnltype=0 and status=0";
        PreparedStatement pstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        try {
            conn = manager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, nParentId);
            rs = pstmt.executeQuery();
            int nId = 0;
            while (rs.next()) {
                nId = rs.getInt(1);
                buff.append(',').append(nId);
                this.getChildIds(manager, nLevel - 1, buff, nId);
            }
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(RollDocumentsChannelsFinder.class, "RollDocumentsChannelsFinder.label7", "\u83b7\u53d6\u9891\u9053\u96c6\u5408\u5931\u8d25!"), e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                manager.freeConnection(conn);
            }
        }
    }
}

