/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.swf;

import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.util.swf.SWFCreator;
import org.apache.log4j.Logger;

public class DocumentListenerForFileToSWF
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentListenerForFileToSWF.class);

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + _oObjModified.getClass() + "]\u7684\u4fee\u6539\uff01"));
            return;
        }
        String sConvertToSWF = ConfigServer.getServer().getSysConfigValue("CONVERT_TO_SWF", "true");
        if (sConvertToSWF.equalsIgnoreCase("false")) {
            return;
        }
        Document document = (Document)_oObjModified;
        if (document.isChangeProperty("DOCTYPE")) {
            int nNewDocType = document.getNewPropertyAsInt("DocType", 0);
            if (nNewDocType == 40) {
                this.convertToSWF(document, document.getNewPropertyAsString("DocFileName"));
            }
        } else if (document.getType() == 40 && document.isChangeProperty("DocFileName")) {
            this.convertToSWF(document, document.getNewPropertyAsString("DocFileName"));
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[" + _oObjAdded.getClass() + "]\u7684\u65b0\u589e\uff01"));
            return;
        }
        String sConvertToSWF = ConfigServer.getServer().getSysConfigValue("CONVERT_TO_SWF", "true");
        if (sConvertToSWF.equalsIgnoreCase("false")) {
            return;
        }
        Document document = (Document)_oObjAdded;
        if (document.getType() != 40) {
            return;
        }
        String sFileName = document.getPropertyAsString("DOCFILENAME");
        this.convertToSWF(document, sFileName);
    }

    private void convertToSWF(Document _document, String _sFileName) throws WCMException {
        String sAbsoluteFileName = FilesMan.getFilesMan().mapFilePath(_sFileName, 0) + _sFileName;
        try {
            SWFCreator oSwfCreator = new SWFCreator(sAbsoluteFileName);
            oSwfCreator.m_nServicePort = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("OPEN_OFFCIE_PORT", "8100"));
            oSwfCreator.m_sSWFToollsPath = ConfigServer.getServer().getSysConfigValue("SWF_TOOLS_PATH", oSwfCreator.m_sSWFToollsPath);
            oSwfCreator.start();
        }
        catch (Throwable e) {
            logger.error((Object)("Fail to convert the document " + _document + " file!"), e);
        }
    }
}

