/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.HTMLContent;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.HitsCount;
import com.trs.components.wcm.content.persistent.HitsCounts;
import com.trs.components.wcm.resource.DocKind;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.Keyword;
import com.trs.components.wcm.resource.Keywords;
import com.trs.components.wcm.resource.Security;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FileHelper;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.CDBText;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.FieldInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Document
extends CMSObj {
    public static boolean SYNCHRONIZE_PROPERTIES_TO_CHNLDOC = false;
    public static boolean DOCUMENTS_GET_OPTIMIZE = false;
    public static String[] SYNCHRONIZED_FIELDS = new String[]{"DOCRELTIME", "DOCCHANNEL"};
    private HTMLContent m_oHTMLContent = null;
    private static Logger logger = Logger.getLogger(Document.class);
    public static final int OBJ_TYPE = 605;
    public static final String DB_TABLE_NAME = "WCMDOCUMENT";
    public static final String DB_ID_NAME = "DOCID";
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_NORMAL = 10;
    public static final int TYPE_HTML = 20;
    public static final int TYPE_LINK = 30;
    public static final int TYPE_FILE = 40;
    public static final int TYPE_PIC = 50;
    public static final int TYPE_VIDEO = 60;
    public static final int DOC_TYPE_NORMAL = 10;
    public static final int DOC_TYPE_HTML = 20;
    public static final int DOC_TYPE_LINK = 30;
    public static final int DOC_TYPE_FILE = 40;
    public static final int DOC_FORM_UNKNOWN = 0;
    public static final int DOC_FORM_LITERY = 1;
    public static final int DOC_FORM_PIC = 2;
    public static final int DOC_FORM_AUDIO = 3;
    public static final int DOC_FORM_VIDEO = 4;
    public static final int FLAG_UNKNOWN = -1;
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_USER_DEFINE = 20;
    public static final int[] ALL_TYPES = new int[]{10, 20, 30, 40};
    public static final int GET_RELATEDDOC_BY_ALL = 0;
    public static final int GET_RELATEDDOC_BY_KEYWORDS = 10;
    public static final int GET_RELATEDDOC_BY_RELWORDS = 20;
    public static final int GET_RELATEDDOC_BY_RELATION = 30;
    public static final int DOCPIC_IN_APPENDIX = 1;
    public static final int DOCPIC_IN_CONTENT = 2;
    public static final int DOCPIC_IN_APD_AND_CON = 3;
    public static final int DOCPIC_NONE = 0;
    public static final int MIN_WIDTH_PIC_IN_CONTENT = 600;
    public static final int MIN_HEIGHT_PIC_IN_CONTENT = 400;
    static String sContent = "";
    int m_currChnlId = 0;
    protected String m_sTableName = null;
    public boolean g_bXMLforTRS = false;
    public boolean m_bXMLOnlySelf = false;
    private boolean m_bForceAdd = false;
    private static CMyDateTime m_dtPubPathStartTime = null;
    private static boolean m_bSavePubFileByTime = true;

    public static String getTypeString(int _nType) {
        switch (_nType) {
            case 10: {
                return I18NMessage.get(Document.class, "Document.label1", "\u7eaf\u6587\u672c");
            }
            case 20: {
                return I18NMessage.get(Document.class, "Document.label2", "Html\u6587\u6863");
            }
            case 30: {
                return I18NMessage.get(Document.class, "Document.label3", "\u94fe\u63a5\u6587\u6863");
            }
            case 40: {
                return I18NMessage.get(Document.class, "Document.label4", "\u5916\u90e8\u6587\u4ef6");
            }
        }
        return I18NMessage.get(Document.class, "Document.label5", "\u672a\u77e5");
    }

    public void setDbTableName(String _sTableName) {
        this.m_sTableName = _sTableName;
    }

    @Override
    public String getDbTableName() {
        String sOtherTableName = this.getOtherTableName();
        if (sOtherTableName != null && sOtherTableName.length() > 0) {
            return sOtherTableName;
        }
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 605;
    }

    public int getDocId() {
        return this.getId();
    }

    public boolean isDeleted() {
        return this.getStatusId() < 0;
    }

    public boolean setDeleted(boolean _bDeleted) throws WCMException {
        int nStatusId = this.getStatusId();
        if (nStatusId < 0 == _bDeleted) {
            return false;
        }
        return this.setStatus(-nStatusId);
    }

    public int getStatusId() {
        return this.getPropertyAsInt("DOCSTATUS", 0);
    }

    public Status getStatus() throws WCMException {
        int nStatusId = this.getStatusId();
        if (nStatusId < 0) {
            nStatusId = -nStatusId;
        }
        return Status.findById(nStatusId);
    }

    public String getStatusName() throws WCMException {
        if (this.getStatusId() == 0) {
            return "";
        }
        Status docStatus = this.getStatus();
        if (docStatus == null) {
            return I18NMessage.get(Document.class, "Document.label5", "\u672a\u77e5");
        }
        return docStatus.getDisp();
    }

    public boolean setStatus(int _statusId) throws WCMException {
        return this.setProperty("DOCSTATUS", _statusId);
    }

    public boolean setStatus(Status _status) throws WCMException {
        return this.setStatus(_status, false);
    }

    public boolean setStatus(Status _status, boolean _bDeleted) throws WCMException {
        if (_status == null || !_status.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label6", "\u65e0\u6548\u7684\u72b6\u6001\u5bf9\u8c61(Document.setStatus)"));
        }
        return this.setStatus(_status.getId() * (_bDeleted ? -1 : 1));
    }

    public int getSecurityId() {
        return this.getPropertyAsInt("DOCSECURITY", 0);
    }

    public Security getSecurity() throws WCMException {
        return Security.findById(this.getSecurityId());
    }

    public boolean setSecurity(int _securityId) throws WCMException {
        return this.setProperty("DOCSECURITY", _securityId);
    }

    public boolean setSecurity(Security _security) throws WCMException {
        if (_security == null || !_security.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label7", "\u65e0\u6548\u7684\u5b89\u5168\u7ea7\u522b\u5bf9\u8c61(Document.setSecurity)"));
        }
        return this.setSecurity(_security.getId());
    }

    public int getChannelId() {
        int nChannelId = this.getPropertyAsInt("DOCCHANNEL", 0);
        if (nChannelId < 0) {
            nChannelId = -nChannelId;
        }
        return nChannelId;
    }

    public Channel getChannel() throws WCMException {
        return Channel.findById(this.getChannelId());
    }

    public String getChannelName() throws WCMException {
        if (this.getChannelId() == 0) {
            return "";
        }
        Channel docChannel = this.getChannel();
        if (docChannel == null) {
            return I18NMessage.get(Document.class, "Document.label8", "\u672a\u77e5[") + this.getChannelId() + "]";
        }
        return docChannel.getName();
    }

    public boolean setChannel(int _channelId) throws WCMException {
        return this.setProperty("DOCCHANNEL", _channelId);
    }

    public boolean setChannel(Channel _channel) throws WCMException {
        if (_channel == null || !_channel.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label9", "\u65e0\u6548\u7684\u9891\u9053\u5bf9\u8c61(Document.setChannel)"));
        }
        return this.setChannel(_channel.getId());
    }

    public int getSourceId() {
        return this.getPropertyAsInt("DOCSOURCE", 0);
    }

    public Source getSource() throws WCMException {
        return Source.findById(this.getSourceId());
    }

    public boolean setSource(int _sourceId) throws WCMException {
        return this.setProperty("DOCSOURCE", _sourceId);
    }

    public boolean setSource(Source _source) throws WCMException {
        if (_source == null || !_source.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label10", "\u65e0\u6548\u7684\u6765\u6e90\u5bf9\u8c61(Document.setSource)"));
        }
        return this.setSource(_source.getId());
    }

    public CMyDateTime getValidTime() {
        return (CMyDateTime)this.getProperty("DOCVALID");
    }

    public boolean setValidTime(CMyDateTime _valid) throws WCMException {
        return this.setProperty("DOCVALID", _valid);
    }

    public String getEditorName() {
        return (String)this.getProperty("DOCEDITOR");
    }

    public User getEditor() {
        return User.findByName(this.getEditorName());
    }

    public boolean setEditor(String _editorName) throws WCMException {
        return this.setProperty("DOCEDITOR", _editorName);
    }

    public boolean setEditor(User _editor) throws WCMException {
        if (_editor == null || !_editor.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label11", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(Document.setEditor)"));
        }
        return this.setEditor(_editor.getName());
    }

    public String getAuditorName() {
        return (String)this.getProperty("DOCAUDITOR");
    }

    public User getAuditor() {
        return User.findByName(this.getAuditorName());
    }

    public boolean setAuditor(String _auditorName) throws WCMException {
        return this.setProperty("DOCAUDITOR", _auditorName);
    }

    public boolean setAuditor(User _auditor) throws WCMException {
        if (_auditor == null || !_auditor.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label12", "\u65e0\u6548\u7684\u7528\u6237\u5bf9\u8c61(Document.setAuditor)"));
        }
        return this.setAuditor(_auditor.getName());
    }

    public int getFlag() {
        return this.getPropertyAsInt("DOCFLAG", 0);
    }

    public boolean setFlag(int _flag) throws WCMException {
        return this.setProperty("DOCFLAG", _flag);
    }

    public int getHitsCount() {
        return this.getPropertyAsInt("HITSCOUNT", 0);
    }

    public boolean setHitsCount(int _hitsCount) throws WCMException {
        return this.setProperty("HITSCOUNT", _hitsCount);
    }

    public int getType() {
        return this.getPropertyAsInt("DOCTYPE", 0);
    }

    public String getTypeString() {
        return Document.getTypeString(this.getType());
    }

    public boolean setType(int _type) throws WCMException {
        if (_type != 10 && _type != 20 && _type != 30 && _type != 40) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label13", "\u65e0\u6548\u7684\u6587\u6863\u7c7b\u578b(Document.setType)"));
        }
        return this.setProperty("DOCTYPE", _type);
    }

    public int getKindId() {
        return this.getPropertyAsInt("DOCKIND", 0);
    }

    public DocKind getKind() throws WCMException {
        return DocKind.findById(this.getKindId());
    }

    public boolean setKind(int _kindId) throws WCMException {
        return this.setProperty("DOCKIND", _kindId);
    }

    public boolean setKind(DocKind _docKind) throws WCMException {
        if (_docKind == null || !_docKind.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Document.class, "Document.label14", "\u65e0\u6548\u7684\u6587\u6863\u7c7b\u522b(Document.setKind)"));
        }
        return this.setKind(_docKind.getId());
    }

    public String getTitle() {
        return (String)this.getProperty("DOCTITLE");
    }

    public boolean setTitle(String _title) throws WCMException {
        boolean bResult = this.setProperty("DOCTITLE", _title);
        return bResult;
    }

    public String getSubTitle() {
        return (String)this.getProperty("SUBDOCTITLE");
    }

    public boolean setSubTitle(String _title) throws WCMException {
        return this.setProperty("SUBDOCTITLE", _title);
    }

    public String getTitleColor() {
        return (String)this.getProperty("TitleColor");
    }

    public boolean setTitleColor(String _titleColor) throws WCMException {
        return this.setProperty("TitleColor", _titleColor);
    }

    public String getPeople() {
        return (String)this.getProperty("DOCPEOPLE");
    }

    public boolean setPeople(String _people) throws WCMException {
        return this.setProperty("DOCPEOPLE", _people);
    }

    public String getPlace() {
        return (String)this.getProperty("DOCPLACE");
    }

    public boolean setPlace(String _place) throws WCMException {
        return this.setProperty("DOCPLACE", _place);
    }

    public String getAuthorName() {
        return (String)this.getProperty("DOCAUTHOR");
    }

    public boolean setAuthor(String _authorName) throws WCMException {
        return this.setProperty("DOCAUTHOR", _authorName);
    }

    public String getPubURL() {
        return (String)this.getProperty("DOCPUBURL");
    }

    public boolean setPubURL(String _pubUrl) throws WCMException {
        return this.setProperty("DOCPUBURL", _pubUrl);
    }

    public String getContent() {
        if (!this.getProperties(true).containsKey("DOCCONTENT")) {
            try {
                this.loadTextsFromDB("DOCCONTENT");
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label16", "] DOCONTENT \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label17", "] DOCONTENT \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(e));
            }
        }
        return this.getPropertyAsString("DOCCONTENT");
    }

    public boolean setContent(String _content) throws WCMException {
        return this.setProperty("DOCCONTENT", new CDBText(this.getDBManager().getDBTypeAsInt(), _content));
    }

    public int getWordsCount() {
        return this.getPropertyAsInt("DOCWORDSCOUNT", 0);
    }

    public String getHtmlContent() {
        if (!this.getProperties(true).containsKey("DOCHTMLCON")) {
            try {
                this.loadTextsFromDB("DOCHTMLCON");
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label18", "] DOCHTMLCON \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label19", "] DOCHTMLCON \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(e));
            }
        }
        return this.getPropertyAsString("DOCHTMLCON");
    }

    public boolean setHtmlContent(String _sHtmlContent) throws WCMException {
        return this.setTextProperty("DOCHTMLCON", _sHtmlContent);
    }

    public String getAbstract() {
        return this.getPropertyAsString("DOCABSTRACT");
    }

    public boolean setAbstract(String _abstract) throws WCMException {
        return this.setPropertyWithString("DOCABSTRACT", _abstract);
    }

    public String getKeywords() {
        return (String)this.getProperty("DOCKEYWORDS");
    }

    public boolean setKeywords(String _keywords) throws WCMException {
        return this.setProperty("DOCKEYWORDS", _keywords);
    }

    public String getRelateWords() {
        return (String)this.getProperty("DOCRELWORDS");
    }

    public boolean setRelateWords(String _relateWords) throws WCMException {
        return this.setProperty("DOCRELWORDS", _relateWords);
    }

    public CMyDateTime getPubTime() {
        return (CMyDateTime)this.getProperty("DOCPUBTIME");
    }

    public boolean setPubTime(CMyDateTime _pubTime) throws WCMException {
        return this.setProperty("DOCPUBTIME", _pubTime);
    }

    public CMyDateTime getReleaseTime() {
        return (CMyDateTime)this.getProperty("DOCRELTIME");
    }

    public boolean setReleaseTime(CMyDateTime _releaseTime) throws WCMException {
        return this.setProperty("DOCRELTIME", _releaseTime);
    }

    public int getOutUpId() {
        return this.getPropertyAsInt("DOCOUTUPID", 0);
    }

    public boolean setOutUpId(int _outUpId) throws WCMException {
        return this.setProperty("DOCOUTUPID", _outUpId);
    }

    public boolean isOutUp() {
        return this.getOutUpId() > 0;
    }

    public int getVersion() {
        return this.getPropertyAsInt("DOCVERSION", 0);
    }

    public boolean setVersion(int _nVersion) throws WCMException {
        return this.setProperty("DOCVERSION", _nVersion);
    }

    public boolean isRightDefined() {
        return this.getPropertyAsInt("RightDefined", 0) > 0;
    }

    public boolean setRightDefined(boolean _bSysDefined) throws WCMException {
        return this.setProperty("RightDefined", _bSysDefined);
    }

    public int getAttachPic() {
        return this.getPropertyAsInt("AttachPic", 0);
    }

    public boolean isAttachPic() {
        return this.getPropertyAsInt("AttachPic", 0) > 0;
    }

    public boolean setAttachPic(int _nAttachPic) throws WCMException {
        return this.setProperty("AttachPic", _nAttachPic);
    }

    public boolean isAttachPic(int _nAttachPic) throws WCMException {
        return this.setProperty("AttachPic", _nAttachPic);
    }

    @Override
    public boolean isValid() throws WCMException {
        CDBText txtContent = null;
        if (this.isAddMode()) {
            this.setProperty("DOCWORDSCOUNT", 0L);
            if (this.getProperty("DOCKIND") == null) {
                this.setKind(0);
            }
            if (this.getProperty("DOCOUTUPID") == null) {
                this.setProperty("DOCOUTUPID", 0L);
            }
            this.validateAdd();
            txtContent = (CDBText)this.getProperty("DOCCONTENT");
        } else {
            this.validateEdit();
            txtContent = (CDBText)this.getNewProperty("DOCCONTENT");
        }
        if (txtContent != null) {
            this.setProperty("DOCWORDSCOUNT", txtContent.getLength());
        }
        this.setProperty("OperTime", CMyDateTime.now());
        return true;
    }

    private boolean isHTMLBody() {
        if (this.isAddMode() || !this.isChangeProperty("DOCTYPE")) {
            return this.getType() == 20;
        }
        return this.getNewPropertyAsInt("DOCTYPE", 20) == 20;
    }

    private void validateAdd() throws WCMException {
        String sDocSourceName;
        String docRelTime;
        if (this.getProperty("DOCCHANNEL") == null) {
            this.setChannel(0);
        }
        if (this.getProperty("DOCTYPE") == null) {
            this.setType(10);
        }
        if (this.getProperty("DOCSTATUS") == null) {
            this.setStatus(1);
        }
        if (this.getProperty("DOCSECURITY") == null) {
            this.setSecurity(0);
        }
        if (this.getProperty("DOCSOURCE") == null) {
            this.setSource(0);
        }
        if ("null".equalsIgnoreCase(docRelTime = String.valueOf(String.valueOf(this.getProperty("DOCRELTIME"))).trim()) || docRelTime.length() == 0) {
            this.setReleaseTime(CMyDateTime.now());
        }
        int nSiteId = 0;
        try {
            int nDocChannel = this.getPropertyAsInt("DocChannel", 0);
            Channel oChannel = Channel.findById(nDocChannel);
            nSiteId = oChannel.getSiteId();
            if (this.getPropertyAsInt("SrcSiteId", 0) == 0) {
                this.setProperty("SrcSiteId", nSiteId);
            }
            this.setProperty("SiteId", nSiteId);
        }
        catch (Exception nDocChannel) {
            // empty catch block
        }
        String sKeywords = this.getFinalPropertyAsString("DOCKEYWORDS");
        this.setKeywords(sKeywords);
        if (!CMyString.isEmpty(sKeywords)) {
            boolean bReplaceKeyWords = this.isReplaceKeywordsFromSiteid(nSiteId);
            Boolean bIsEnPhrases = ConfigServer.getServer().getSysConfigValue("EN_PHRASES_KEYWORDS", "false").trim().equalsIgnoreCase("true");
            if (bReplaceKeyWords) {
                sKeywords = bIsEnPhrases != false ? sKeywords.replaceAll("[\u3001,\uff1b,\uff0c]", ";") : sKeywords.replaceAll("[\\s, \u3001, ,, \uff1b, \uff0c]", ";");
            }
            String[] aNewKeywords = sKeywords.split(";");
            for (int i = 0; i < aNewKeywords.length; ++i) {
                WCMFilter ofilter = new WCMFilter("", "KNAME=?", "");
                ofilter.addSearchValues(aNewKeywords[i]);
                Keywords currKeywords = Keywords.openWCMObjs(null, ofilter);
                if (currKeywords == null || currKeywords.size() <= 0) continue;
                Keyword currKeyword = (Keyword)currKeywords.getAt(0);
                currKeyword.setKFREQ(currKeyword.getKFREQ() + 1);
                currKeyword.save();
            }
        }
        if (CMyString.isEmpty(this.getTitle())) {
            throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label20", "\u5c5e\u6027Title\u6ca1\u6709\u8bbe\u7f6e(Document.isValid)"));
        }
        if (this.getSourceId() == 0 && (sDocSourceName = this.getPropertyAsString("DOCSOURCENAME")) != null && sDocSourceName.trim().length() > 0) {
            this.setProperty("DOCSOURCE", sDocSourceName.hashCode());
        }
        int nDocType = this.getType();
        switch (nDocType) {
            case 20: {
                if (this.getProperty("DOCHTMLCON") == null) {
                    throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label21", "\u6ca1\u6709\u8bbe\u7f6eHTML\u6b63\u6587\uff01"));
                }
                this.setHtmlContent(HTMLContent.saveHtmlContent(this.getHtmlContent()));
                this.setPubHtmlContent(this.getHtmlContent());
                if (!CMyString.isEmpty(this.getContent())) break;
                this.setContent(CMyString.innerText(this.getHtmlContent()));
                break;
            }
            case 10: {
                if (this.getProperty("DOCCONTENT") == null) {
                    if (this.getProperty("DOCHTMLCON") == null) {
                        throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label22", "\u6ca1\u6709\u8bbe\u7f6e\u6b63\u6587\uff01"));
                    }
                    this.setContent(this.getPropertyAsString("DOCHTMLCON"));
                }
                if (this.isInfoviewDocument()) {
                    this.setContent(HTMLContent.saveHtmlContent(this.getContent()));
                }
                this.setPubHtmlContent(this.getContent());
                break;
            }
            case 30: 
            case 40: 
            case 50: 
            case 60: {
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(Document.class, "Document.label23", "\u8bbe\u7f6e\u7684Type\u65e0\u6548\uff01"));
            }
        }
    }

    private boolean isInfoviewDocument() {
        return this.getFlag() > 0;
    }

    private void validateEdit() throws WCMException {
        boolean bChangeDocType;
        if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(Document.class, "Document.label24", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Document.isValid)"));
        }
        String sKeywords = this.getFinalPropertyAsString("DOCKEYWORDS");
        if (!CMyString.isEmpty(sKeywords)) {
            boolean bReplaceKeyWords = true;
            int nSiteId = this.getPropertyAsInt("SiteId", 0);
            if (nSiteId != 0) {
                bReplaceKeyWords = this.isReplaceKeywordsFromSiteid(nSiteId);
            }
            Boolean bIsEnPhrases = ConfigServer.getServer().getSysConfigValue("EN_PHRASES_KEYWORDS", "false").trim().equalsIgnoreCase("true");
            if (bReplaceKeyWords) {
                sKeywords = bIsEnPhrases != false ? sKeywords.replaceAll("[\u3001,\uff1b,\uff0c]", ";") : sKeywords.replaceAll("[\\s, \u3001, ,, \uff1b, \uff0c]", ";");
            }
            String sOldkeywords = CMyString.showNull(this.getProperty("DOCKEYWORDS") == null ? "" : this.getProperty("DOCKEYWORDS").toString());
            String[] aNewKeywords = sKeywords.split(";");
            for (int i = 0; i < aNewKeywords.length; ++i) {
                boolean bNotContain = false;
                if (sOldkeywords.indexOf(aNewKeywords[i]) <= -1) {
                    bNotContain = true;
                }
                if (!bNotContain) continue;
                WCMFilter ofilter = new WCMFilter("", "KNAME=?", "");
                ofilter.addSearchValues(aNewKeywords[i]);
                Keywords currKeywords = Keywords.openWCMObjs(null, ofilter);
                if (currKeywords == null || currKeywords.size() <= 0) continue;
                Keyword currKeyword = (Keyword)currKeywords.getAt(0);
                currKeyword.setKFREQ(currKeyword.getKFREQ() + 1);
                currKeyword.save();
            }
            this.setKeywords(sKeywords);
        }
        if (this.getNewPropertyAsInt("DOCSOURCE", 0) == 0) {
            String sDocSourceName = this.getNewPropertyAsString("DOCSOURCENAME");
            if (sDocSourceName != null && sDocSourceName.trim().length() > 0) {
                this.setProperty("DOCSOURCE", sDocSourceName.hashCode());
            } else {
                this.setProperty("DOCSOURCE", 0L);
            }
        }
        int nDocType = (bChangeDocType = this.isChangeProperty("DOCTYPE")) ? this.getNewPropertyAsInt("DOCTYPE", 20) : this.getType();
        switch (nDocType) {
            case 20: {
                Object oHTMLCon = this.getNewProperty("DOCHTMLCON");
                if (bChangeDocType && oHTMLCon == null) {
                    throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label21", "\u6ca1\u6709\u8bbe\u7f6eHTML\u6b63\u6587\uff01"));
                }
                if (oHTMLCon == null) {
                    return;
                }
                String sHTMLCon = HTMLContent.saveHtmlContent(oHTMLCon.toString());
                this.setContent(this.getNewPropertyAsString("DOCCONTENT"));
                this.setHtmlContent(sHTMLCon);
                this.setPubHtmlContent(sHTMLCon);
                if (!CMyString.isEmpty(this.getNewPropertyAsString("DOCCONTENT"))) break;
                this.setContent(CMyString.innerText(sHTMLCon));
                break;
            }
            case 10: {
                Object oContent = this.getNewProperty("DOCCONTENT");
                if (bChangeDocType && oContent == null) {
                    throw new WCMException(1106, I18NMessage.get(Document.class, "Document.label22", "\u6ca1\u6709\u8bbe\u7f6e\u6b63\u6587\uff01"));
                }
                if (oContent == null) {
                    return;
                }
                if (this.isInfoviewDocument()) {
                    this.setContent(HTMLContent.saveHtmlContent(oContent.toString()));
                    this.setPubHtmlContent(this.getContent());
                    break;
                }
                this.setPubHtmlContent(oContent.toString());
                break;
            }
            case 30: 
            case 40: 
            case 50: 
            case 60: {
                break;
            }
            default: {
                throw new WCMException(10, I18NMessage.get(Document.class, "Document.label23", "\u8bbe\u7f6e\u7684Type\u65e0\u6548\uff01"));
            }
        }
    }

    public boolean isDraft() {
        return this.getChannelId() == 0;
    }

    @Override
    protected synchronized int getNextId(Connection _oConn) throws WCMException {
        int nNextId = super.getNextId(_oConn);
        return nNextId;
    }

    public boolean isDocumentObject() {
        return this.getDbTableName().compareToIgnoreCase(DB_TABLE_NAME) == 0;
    }

    public boolean logicalDelete(User _currUser) throws WCMException {
        return this.doLogicalDelete(_currUser, true);
    }

    public boolean logicalUndelete(User _currUser) throws WCMException {
        return this.doLogicalDelete(_currUser, false);
    }

    private boolean doLogicalDelete(User _currUser, boolean _bDeleted) throws WCMException {
        if (!this.isValidInstance()) {
            return false;
        }
        boolean bLockedByMe = false;
        try {
            if (this.isDeleted() == _bDeleted) {
                return true;
            }
            if (!this.canEdit(_currUser)) {
                return false;
            }
            bLockedByMe = true;
            this.setDeleted(_bDeleted);
            this.update(_currUser);
            return true;
        }
        catch (Exception ex) {
            if (bLockedByMe) {
                try {
                    this.cancelUpdate(_currUser);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new WCMException(1100, I18NMessage.get(Document.class, "Document.label25", "\u903b\u8f91\u5220\u9664\u6587\u6863\u5931\u8d25\uff08Document.logicalDelete\uff09"), ex);
        }
    }

    public void updateHitsCount(User _currUser) throws Exception {
        if (_currUser == null) {
            return;
        }
        HitsCount aHitsCount = new HitsCount();
        String sContintion = "ObjType=605  and ObjId=" + this.getId() + " and CrUser='" + _currUser.getName() + "'";
        if (!aHitsCount.checkExists(sContintion)) {
            try {
                HitsCounts aHitsCounts = new HitsCounts(_currUser, 1, 1);
                aHitsCount = (HitsCount)aHitsCounts.addNew();
                aHitsCount.setObjType(605);
                aHitsCount.setObjId(this.getId());
                aHitsCount.setCrUser(_currUser);
                aHitsCount.setProperty("CRTIME", CMyDateTime.now());
                aHitsCounts.update();
                aHitsCounts.clear();
                aHitsCount = null;
            }
            catch (Exception ex) {
                throw new WCMException(1100, I18NMessage.get(Document.class, "Document.label26", "\u63d2\u5165\u5f53\u524d\u7528\u6237\u7684\u70b9\u51fb\u8bb0\u5f55\u5931\u8d25\uff01"), ex);
            }
            try {
                String[] strSQL = new String[]{"update WCMDocument set HitsCount=HitsCount+1 where DocId=" + this.getId()};
                this.getDBManager().sqlExecuteUpdate(strSQL);
            }
            catch (Exception ex) {
                throw new WCMException(1100, I18NMessage.get(Document.class, "Document.label27", "\u66f4\u65b0\u6587\u6863\u7684\u70b9\u51fb\u6570\u5c5e\u6027\u5931\u8d25\uff01"), ex);
            }
        }
    }

    public void setMyDocId(int _id) {
        this.id = _id;
        this.bAddMode = false;
    }

    public String getPubHtmlContent() {
        if (!this.getProperties(true).containsKey("DOCPUBHTMLCON")) {
            try {
                this.loadTextsFromDB("DOCPUBHTMLCON");
            }
            catch (Exception e) {
                logger.error((Object)(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label29", "] DOCPUBHTMLCON \u5c5e\u6027\u5931\u8d25\uff01")));
                throw new RuntimeException(I18NMessage.get(Document.class, "Document.label15", "\u8f7d\u5165[") + this + I18NMessage.get(Document.class, "Document.label30", "] DOCPUBHTMLCON \u5c5e\u6027\u5931\u8d25\uff01\n") + CMyException.getStackTraceText(e));
            }
        }
        return this.getPropertyAsString("DOCPUBHTMLCON");
    }

    public boolean setPubHtmlContent(String _htmlContent) throws WCMException {
        return this.setProperty("DOCPUBHTMLCON", new CDBText(this.getDBManager().getDBTypeAsInt(), _htmlContent));
    }

    public String getHtmlContentWithImgFilter(String _sImgSrcPre, boolean _bRemoveExtraAttribute) throws WCMException {
        return this.getHtmlContentWithImgFilter(_sImgSrcPre, _bRemoveExtraAttribute, false);
    }

    public String getHtmlContentWithImgFilter(String _sImgSrcPre, boolean _bRemoveExtraAttribute, boolean _bFromPubHTMLContent) throws WCMException {
        if (this.getType() != 20) {
            return "";
        }
        if (this.m_oHTMLContent == null) {
            this.m_oHTMLContent = new HTMLContent(_bFromPubHTMLContent ? this.getPubHtmlContent() : this.getHtmlContent());
        }
        return this.m_oHTMLContent.parseHTMLContent(_sImgSrcPre);
    }

    public List getHTMLFiles() throws WCMException {
        if (this.getType() != 20) {
            return new ArrayList();
        }
        if (this.m_oHTMLContent == null) {
            this.m_oHTMLContent = new HTMLContent(this.getHtmlContent());
        }
        return this.m_oHTMLContent.getFiles();
    }

    public List getHTMLWCMFiles() throws WCMException {
        return this.getHTMLWCMFiles(false);
    }

    public List getHTMLWCMFiles(boolean _bFromPubHTMLContent) throws WCMException {
        if (this.getType() != 20 && this.getPropertyAsInt("DocFlag", 0) == 0) {
            return new ArrayList();
        }
        if (this.m_oHTMLContent == null) {
            String sContent;
            String string = sContent = _bFromPubHTMLContent ? this.getPubHtmlContent() : this.getHtmlContent();
            if (CMyString.isEmpty(sContent)) {
                sContent = this.getContent();
            }
            this.m_oHTMLContent = new HTMLContent(sContent);
        }
        return this.m_oHTMLContent.getWCMFiles();
    }

    @Override
    public void setId(int _nId) {
        this.id = _nId;
        this.m_bForceAdd = true;
    }

    @Override
    public boolean isValidInstance() {
        if (this.m_bForceAdd) {
            return true;
        }
        return !this.bAddMode && this.id > 0;
    }

    public boolean isSavePubFileByTime() {
        if (!m_bSavePubFileByTime || this.getCrTime() == null) {
            return false;
        }
        CMyDateTime dtStartPub = Document.getPubPathStartTime();
        return dtStartPub != null && dtStartPub.compareTo(this.getCrTime()) <= 0L;
    }

    public static CMyDateTime getPubPathStartTime() {
        if (m_dtPubPathStartTime == null) {
            String sDefaultPubStartTime;
            m_dtPubPathStartTime = new CMyDateTime();
            String sPubStartTime = sDefaultPubStartTime = "2004-05-01";
            if (ConfigServer.getServer().getInitProperty("PUBPATH_START_DATE") != null) {
                sPubStartTime = ConfigServer.getServer().getInitProperty("PUBPATH_START_DATE");
            }
            try {
                m_dtPubPathStartTime.setDateTimeWithString(sPubStartTime + " 00:00:00");
            }
            catch (Exception ex) {
                try {
                    m_dtPubPathStartTime.setDateTimeWithString(sDefaultPubStartTime + " 00:00:00");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return m_dtPubPathStartTime;
        }
        return (CMyDateTime)m_dtPubPathStartTime.clone();
    }

    public static void setPubPathStartTime(CMyDateTime _dtStart) {
        m_dtPubPathStartTime = (CMyDateTime)_dtStart.clone();
    }

    protected int getDocPro() {
        return this.getPropertyAsInt("DOCPRO", 0);
    }

    public boolean hasDocPro(int _nIndex) {
        CMyBitsValue aBitsValue = new CMyBitsValue(this.getDocPro());
        return aBitsValue.getBit(_nIndex);
    }

    public void setDocPro(int _nIndex, boolean _bValue) throws WCMException {
        CMyBitsValue aBitsValue = new CMyBitsValue(this.getDocPro());
        if (this.getNewProperty("DOCPRO") != null) {
            aBitsValue = new CMyBitsValue(this.getNewPropertyAsInt("DOCPRO", 0));
        }
        aBitsValue.setBit(_nIndex, _bValue);
        this.setProperty("DOCPRO", aBitsValue.getValueAsInt());
    }

    @Override
    public BaseObj cloneToNewWCMObj() throws WCMException {
        Document newObj = (Document)super.cloneToNewObj();
        newObj.setVersion(0);
        newObj.removeProperty("CRTIME");
        newObj.setProperty("DOCHTMLCON", new CDBText(this.getDBManager().getDBTypeAsInt(), HTMLContent.saveHtmlContent(this.getHtmlContent(), true, true)));
        return newObj;
    }

    public static Document findById(int _nId) throws WCMException {
        return Document.findById(_nId, "*");
    }

    public static Document findById(int _nId, String _sSelectFields) throws WCMException {
        return Document.findById(_nId, _sSelectFields, null);
    }

    public static Document findById(int _nId, String _sSelectFields, String _sTableName) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        Document currDocument = new Document();
        currDocument.setDbTableName(_sTableName);
        currDocument.id = _nId;
        if (currDocument.loadFromDB(_sSelectFields)) {
            return currDocument;
        }
        return null;
    }

    public static Document createNewInstance() throws WCMException {
        return (Document)BaseObj.createNewInstance(Document.class);
    }

    public static Document findByKey(Object _oKey) throws WCMException {
        return (Document)BaseObj.findByKey(Document.class, _oKey);
    }

    public static void main(String[] args) {
        try {
            Document currDocument = Document.findById(19873);
            System.out.println("currDocument\uff1a" + currDocument);
            if (currDocument != null) {
                System.out.println("currDocument\uff1a" + currDocument.getTitle());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isDoDelete() {
        return this.getPropertyAsInt("DOCSTATUS", 0) * this.getNewPropertyAsInt("DOCSTATUS", 0) < 0 && !this.isDeleted();
    }

    public boolean isDoRecover() {
        return this.getPropertyAsInt("DOCSTATUS", 0) * this.getNewPropertyAsInt("DOCSTATUS", 0) < 0 && this.isDeleted();
    }

    public boolean isDoMove() {
        return !this.isAddMode() && this.isChangeProperty("DOCCHANNEL");
    }

    public int getFromVersion() {
        return this.getPropertyAsInt("DOCFROMVERSION", 0);
    }

    public boolean setFromVersion(int _nFromVersion) throws WCMException {
        return this.setProperty("DOCFROMVERSION", _nFromVersion);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getTitle();
        }
        return this.getTitle() + I18NMessage.get(Document.class, "Document.label31", "[\u6587\u6863-") + this.getId() + "]";
    }

    @Override
    public int delete() throws WCMException {
        this.deleteHTMLContentFiles();
        return super.delete();
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        this.deleteHTMLContentFiles();
        int nRet = super.delete(_currUser);
        return nRet;
    }

    private void deleteHTMLContentFiles() throws WCMException {
        List listFiles = this.getHTMLWCMFiles();
        if (listFiles != null) {
            String sFile = null;
            for (int i = 0; i < listFiles.size(); ++i) {
                sFile = (String)listFiles.get(i);
                if (sFile == null || sFile.trim().length() <= 0) continue;
                try {
                    FilesMan.getFilesMan().deleteFile(sFile);
                    continue;
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(I18NMessage.get(Document.class, "Document.label32", "\u5220\u9664\u6587\u6863\u5305\u542b\u7684HTML\u6587\u4ef6[") + sFile + I18NMessage.get(Document.class, "Document.label33", "]\u65f6\u53d1\u751f\u5f02\u5e38\uff01")));
                }
            }
        }
    }

    @Override
    protected void updateOthersAfterModified() {
        super.updateOthersAfterModified();
        if (SYNCHRONIZE_PROPERTIES_TO_CHNLDOC) {
            try {
                this.synchroizeToChnlDoc();
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)I18NMessage.get(Document.class, "Document.label34", "\u540c\u6b65WCMDocument\u4fe1\u606f\u5230WCMChnlDoc\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)e);
            }
        }
    }

    private void synchroizeToChnlDoc() throws WCMException {
        String strSQL = this.makeUpdateChnlDocSQL();
        if (strSQL == null) {
            return;
        }
        DBManager dbMgr = DBManager.getDBManager();
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        try {
            oConn = dbMgr.getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            this.setSynChnlDocParameters(oPreStmt);
            oPreStmt.execute();
        }
        catch (SQLException ex) {
            throw new WCMException(I18NMessage.get(Document.class, "Document.label35", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(Document.class, "Document.label35", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setSynChnlDocParameters(PreparedStatement _oPreStmt) throws WCMException {
        String sFieldName = null;
        Object value = null;
        DBType currDbType = this.getDBManager().getDBType();
        try {
            int nParamIndex = 0;
            for (int i = 0; i < SYNCHRONIZED_FIELDS.length; ++i) {
                sFieldName = SYNCHRONIZED_FIELDS[i];
                if (!this.isChangeProperty(sFieldName)) continue;
                ++nParamIndex;
                value = this.getNewProperty(sFieldName);
                if (value == null) {
                    FieldInfo fi = this.getDBManager().getFieldInfo(DB_TABLE_NAME, sFieldName);
                    _oPreStmt.setNull(nParamIndex, fi.getDataType().getType());
                    continue;
                }
                if (value instanceof NullValue) {
                    _oPreStmt.setNull(nParamIndex, ((NullValue)value).getDataType());
                    continue;
                }
                if (value instanceof Long) {
                    _oPreStmt.setLong(nParamIndex, (Long)value);
                    continue;
                }
                if (value instanceof Double) {
                    _oPreStmt.setDouble(nParamIndex, (Double)value);
                    continue;
                }
                if (value instanceof Integer) {
                    _oPreStmt.setInt(nParamIndex, (Integer)value);
                    continue;
                }
                if (value instanceof String) {
                    value = currDbType.encodeStrToWrite((String)value);
                    int currDataType = this.getDBManager().getFieldInfo(this.getDbTableName(), sFieldName).getDataType().getType();
                    if (currDataType == 12) {
                        currDbType.setStringFieldValue(_oPreStmt, nParamIndex, (String)value);
                        continue;
                    }
                    _oPreStmt.setNull(nParamIndex, currDataType);
                    continue;
                }
                if (value instanceof CMyDateTime) {
                    _oPreStmt.setTimestamp(nParamIndex, ((CMyDateTime)value).toTimestamp());
                    continue;
                }
                if (value instanceof CDBText) {
                    if (!currDbType.canWriteTextDirectly()) continue;
                    _oPreStmt.setString(nParamIndex, currDbType.encodeStrToWrite(((CDBText)value).getText()));
                    continue;
                }
                throw new WCMException(1103, I18NMessage.get(Document.class, "Document.label36", "\u672a\u77e5\u7684\u5bf9\u8c61") + sFieldName + I18NMessage.get(Document.class, "Document.label37", "\u5c5e\u6027\u7c7b\u578b\uff1a(") + this.getClass().getName() + ".setParameters)");
            }
            _oPreStmt.setInt(++nParamIndex, this.getId());
        }
        catch (Exception e) {
            throw new WCMException(1001, I18NMessage.get(Document.class, "Document.label38", "\u8bbe\u7f6e\u5b57\u6bb5[") + sFieldName + I18NMessage.get(Document.class, "Document.label39", "]\u7684\u503c[") + value + I18NMessage.get(Document.class, "Document.label40", "]\u5931\u8d25\uff01"));
        }
    }

    private String makeUpdateChnlDocSQL() {
        String sSetValues = null;
        for (int i = 0; i < SYNCHRONIZED_FIELDS.length; ++i) {
            String sFieldName = SYNCHRONIZED_FIELDS[i];
            if (!this.isChangeProperty(sFieldName)) continue;
            sSetValues = sSetValues == null ? "" : sSetValues + ",";
            sSetValues = sSetValues + sFieldName + "=?";
        }
        if (sSetValues == null) {
            return null;
        }
        return "update WCMChnlDoc set " + sSetValues + " where DocId=?";
    }

    public boolean setOtherTableName(String _sOtherTableName) throws WCMException {
        return this.setProperty("OTHERTABLE", _sOtherTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOtherTableName() {
        if (this.m_sTableName != null && this.m_sTableName.length() > 0) {
            return this.m_sTableName;
        }
        Object oValue = this.getProperty("OTHERTABLE");
        if (oValue != null) {
            this.m_sTableName = oValue.toString().trim();
            if (this.m_sTableName.length() > 0) {
                if (this.id <= 0) {
                    Connection conn = null;
                    try {
                        conn = this.getDBManager().getConnection();
                        this.getNextId(conn, DB_TABLE_NAME, DB_ID_NAME);
                    }
                    catch (WCMException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            this.getDBManager().freeConnection(conn);
                        }
                        catch (Exception exception) {}
                    }
                }
                return this.m_sTableName;
            }
        }
        return null;
    }

    public void insertOtherTable(User _currUser, String _sTableName) throws WCMException {
        this.getProperties().put("CRUSER", _currUser.getName());
        this.loadTextsFromDB(false);
        this.getProperties().put("OTHERTABLE", "");
        this.setDbTableName(_sTableName);
        this.bAddMode = true;
        Connection oConn = null;
        Statement oPreStmt = null;
        String sInsertSQL = this.createInsertSQL();
        try {
            oConn = this.getDBManager().getConnection();
            oPreStmt = oConn.prepareStatement(sInsertSQL);
            this.setParameters((PreparedStatement)oPreStmt);
            oPreStmt.executeUpdate();
            if (this.sClobFields_toUpdate != null) {
                this.updateClobFields(oConn, true);
            }
            this.bAddMode = false;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(Document.class, "Document.label41", "\u6dfb\u52a0\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".insert).SQL:\n" + sInsertSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(Document.class, "Document.label41", "\u6dfb\u52a0\u5bf9\u8c61\u4fe1\u606f\u5230\u6570\u636e\u5e93\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".insert).", ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    public boolean setRandomSerial(String randomSerial) throws WCMException {
        if (!CMyString.isEmpty(randomSerial)) {
            randomSerial = this.isAddMode() ? randomSerial + "-" + this.getNextId() : randomSerial + "-" + this.getId();
            return this.setProperty("RANDOMSERIAL", randomSerial);
        }
        return true;
    }

    public String getRandomSerial() {
        return this.getPropertyAsString("RANDOMSERIAL");
    }

    public DocLevel getDocLevel() throws WCMException {
        int nDocLevelId = this.getDocLevleId();
        if (nDocLevelId == 0) {
            return DocLevel.findById(1);
        }
        return DocLevel.findById(nDocLevelId);
    }

    public boolean setDocLevel(DocLevel _docLevel) throws WCMException {
        if (_docLevel == null) {
            return this.setDocLevel(0);
        }
        return this.setDocLevel(_docLevel.getId());
    }

    public int getDocLevleId() {
        return this.getPropertyAsInt("DOCLEVEL", 0);
    }

    public boolean setDocLevel(int _nDocLevelId) throws WCMException {
        return this.setProperty("DOCLEVEL", _nDocLevelId);
    }

    public String getDocLevelName() throws WCMException {
        if (this.getDocId() == 0) {
            return "";
        }
        DocLevel docLevel = this.getDocLevel();
        if (docLevel == null) {
            return "\u672a\u77e5";
        }
        return docLevel.getLName();
    }

    public boolean hasImgInDocContent() throws WCMException {
        String sHtmlContent;
        if (this.isAddMode()) {
            this.setHtmlContent(HTMLContent.saveHtmlContent(this.getHtmlContent()));
        }
        if ((sHtmlContent = this.getHtmlContent()) == null || sHtmlContent.trim().equals("")) {
            return false;
        }
        String sReg = "(?is)<img\\b[^>]*\\bsrc=\"([^\"]+)?\"[^>]*?>";
        Pattern pattern = Pattern.compile(sReg);
        Matcher matcher = pattern.matcher(sHtmlContent);
        String sImageName = null;
        boolean bFind = false;
        while (matcher.find()) {
            sImageName = matcher.group(1);
            if (sImageName == null || sImageName.trim().length() == 0) continue;
            int nPos = sImageName.lastIndexOf("/");
            if (nPos < 0) {
                nPos = sImageName.lastIndexOf("\\");
            }
            if (nPos >= 0) {
                sImageName = sImageName.substring(nPos + 1);
            }
            if (!Document.validConPic(sImageName)) continue;
            bFind = true;
            break;
        }
        return bFind;
    }

    private static boolean validConPic(String sFileName) throws WCMException {
        String sSrcFilePathName;
        try {
            sSrcFilePathName = FilesMan.getFilesMan().mapFilePath(sFileName, 0) + sFileName;
        }
        catch (WCMException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u6839\u636e\u6587\u4ef6\u540d[" + sFileName + "]\u83b7\u53d6\u6587\u4ef6\u8def\u5f84\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
            }
            return false;
        }
        String sMinLimit = ConfigServer.getServer().getSysConfigValue("DOCCONTENTPIC_VALID_MIN_LIMIT", "600,400");
        int[] nMinLimit = CMyString.splitToInt(sMinLimit, ",");
        return FileHelper.validImageFile(sSrcFilePathName, nMinLimit[0], nMinLimit[1]);
    }

    private boolean isReplaceKeywordsFromSiteid(int _nSiteId) throws WCMException {
        boolean bReplaceKeywordsFromSiteid = true;
        String sNotReplaceKeywordsFromSiteids = ConfigServer.getServer().getSysConfigValue("NOT_REPLACE_KEYWORDS_FROM_SITEIDS", "");
        if (sNotReplaceKeywordsFromSiteids.length() > 0) {
            String[] sSiteIds = sNotReplaceKeywordsFromSiteids.split(",");
            int size = sSiteIds.length;
            for (int i = 0; i < size; ++i) {
                try {
                    int tmpSiteId = Integer.parseInt(sSiteIds[i]);
                    if (_nSiteId != tmpSiteId) continue;
                    bReplaceKeywordsFromSiteid = false;
                }
                catch (NumberFormatException e) {}
                break;
            }
        }
        return bReplaceKeywordsFromSiteid;
    }
}

