/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.IChildrenMgr;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseChannel
extends CMSObj {
    private static final long serialVersionUID = -3016299495370904156L;
    public static final int STATUS_NORM = 0;
    public static final int STATUS_DEL = -1;
    public static final int STATUS_PARENT_DEL = -2;
    public static final int TYPE_ALL = -1;

    public boolean isDeleted() {
        return this.getStatus() < 0;
    }

    public int getStatus() {
        return this.getPropertyAsInt("Status", 0);
    }

    public boolean setStatus(int _nStatus) throws WCMException {
        return this.setProperty("Status", _nStatus);
    }

    public boolean setDeleted(boolean _bSystemNotifyDelete) throws WCMException {
        return this.setStatus(_bSystemNotifyDelete ? -2 : -1);
    }

    public boolean restore(boolean _bSystemNotifyRestore) throws WCMException {
        if (_bSystemNotifyRestore && this.getStatus() != -2) {
            return false;
        }
        return this.setStatus(0);
    }

    public boolean setOperUser(User _opUser) throws WCMException {
        if (_opUser == null || !_opUser.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(BaseChannel.class, "BaseChannel.label1", "\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u65e0\u6548!"));
        }
        return this.setOperUser(_opUser.getName());
    }

    public boolean setOperUser(String _sUserName) throws WCMException {
        return this.setProperty("OperUser", _sUserName);
    }

    public boolean setOperTime() throws WCMException {
        return this.setProperty("OperTime", CMyDateTime.now());
    }

    public int getParentId() {
        return this.getPropertyAsInt("ParentId", 0);
    }

    public abstract boolean isSite();

    public abstract WebSite getSite() throws WCMException;

    public abstract int getSiteId();

    public abstract String getDesc();

    public String getDispDesc() {
        String sDesc = this.getDesc();
        if (sDesc == null || sDesc.length() == 0) {
            sDesc = this.getName();
        }
        return sDesc;
    }

    public abstract String getInfo();

    public abstract String getName();

    public abstract boolean setName(String var1) throws WCMException;

    public abstract boolean setParent(int var1) throws WCMException;

    public abstract int getOrder();

    public abstract BaseChannel getHost() throws WCMException;

    public List<Channel> getChildren(User _currUser, int _nType) throws WCMException {
        return this.getChildrenCacheMgr().listChildren(_currUser, this, _nType);
    }

    public List<Channel> getChildren(User _currUser, int[] _nArrayTypes) throws WCMException {
        return this.getChildrenCacheMgr().listChildren(_currUser, this, _nArrayTypes);
    }

    private IChildrenMgr getChildrenCacheMgr() {
        IChildrenMgr childrenMgr = (IChildrenMgr)DreamFactory.createObjectById("IChildrenMgr");
        return childrenMgr;
    }

    public List<Channel> getChildren(User _currUser) throws WCMException {
        return this.getChildren(_currUser, -1);
    }

    public List<Channel> getAllChildren(User _currUser) throws WCMException {
        String sWhere = "";
        sWhere = this.isSite() ? "ParentId=0 and SiteId=" + this.getId() : "ParentId=" + this.getId();
        WCMFilter aFilter = new WCMFilter("", sWhere, "ChnlOrder desc");
        Channels aChannels = Channels.openWCMObjs(_currUser, aFilter);
        int nChildrenCount = aChannels.size();
        ArrayList<Channel> aList = new ArrayList<Channel>(nChildrenCount);
        for (int i = 0; i < nChildrenCount; ++i) {
            Channel aChannel = (Channel)aChannels.getAt(i);
            if (aChannel == null) continue;
            aList.add(aChannel);
        }
        return aList;
    }

    public Channel getChildAt(int _nIndex) throws WCMException {
        return this.getChildrenCacheMgr().getChildAt(this, _nIndex);
    }

    public int getSiblingIndex() throws WCMException {
        return this.getChildrenCacheMgr().getSiblingIndex(this);
    }

    public int getChildrenSize(User _currUser) throws WCMException {
        return this.getChildrenCacheMgr().getChildrenSize(_currUser, this);
    }
}

