/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.auth;

import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.RightHostFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSubstanceImplBase;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.List;

public class ChannelRightHostImpl
extends ChannelSubstanceImplBase
implements IRightHost {
    private static final String[] RIGHT_TYPE_IDS = new String[]{"channel", "document", "template"};
    private static final String[] RIGHT_TYPE_NAMES = new String[]{I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label1", "\u680f\u76ee\u7c7b"), I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label2", "\u6587\u6863\u7c7b"), I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label3", "\u6a21\u677f\u7c7b")};

    public ChannelRightHostImpl() {
    }

    public ChannelRightHostImpl(int _nId) throws WCMException {
        super(_nId);
    }

    public ChannelRightHostImpl(CMSObj _cmsObj) {
        super(_cmsObj);
    }

    @Override
    public void validateCanDoSetRight(User _user) throws WCMException {
        if (this.m_oCurrChannel == null) {
            throw new WCMException(I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label4", "\u6ca1\u6709\u6307\u5b9a\u9891\u9053\uff01"));
        }
        if (this.m_oCurrChannel.isDeleted()) {
            throw new WCMException(I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label5", "\u6307\u5b9a\u9891\u9053[") + this.m_oCurrChannel.getName() + "][ID=" + this.m_oCurrChannel.getId() + I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label6", "]\u5df2\u7ecf\u88ab\u5220\u9664\uff01"));
        }
        int nRightIndex = 55;
        if (!AuthServer.hasRightOnSelf(_user, this.m_oCurrChannel, nRightIndex)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ChannelRightHostImpl.class, "ChannelRightHostImpl.label7", "\u7528\u6237[{0}]\u5bf9\u4e8e\u6307\u5b9a\u7684\u9891\u9053[{1}][ID={2}]\u4e0d\u80fd\u8bbe\u7f6e\u6743\u9650\uff01"), new String[]{_user.getName(), this.m_oCurrChannel.getName(), String.valueOf(this.m_oCurrChannel.getId())}));
        }
    }

    @Override
    public IRightHost[] getChildren() throws WCMException {
        List<Channel> lChannels = this.m_oCurrChannel.getChildren(null);
        if (lChannels == null || lChannels.isEmpty()) {
            return null;
        }
        IRightHost[] pRightHost = new IRightHost[lChannels.size()];
        int nSize = lChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = lChannels.get(i);
            pRightHost[i] = channel == null ? null : new ChannelRightHostImpl(channel);
        }
        return pRightHost;
    }

    @Override
    public String[] getRightTypeIds() {
        return RIGHT_TYPE_IDS;
    }

    @Override
    public String[] getRightTypeNames() {
        return RIGHT_TYPE_NAMES;
    }

    @Override
    public IRightHost getParent() throws WCMException {
        return RightHostFactory.makeRightHostFrom(this.m_oCurrChannel.getHost());
    }
}

