/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.IDocKeywordMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class DocumentLCListenerForRelDocs
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentLCListenerForRelDocs.class);
    private IDocKeywordMgr m_oDocKeywordMgr = (IDocKeywordMgr)DreamFactory.createObjectById("IDocKeywordMgr");

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForRelDocs.class, "DocumentLCListenerForRelDocs.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(DocumentLCListenerForRelDocs.class, "DocumentLCListenerForRelDocs.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        Document document = (Document)_oObjAdded;
        this.m_oDocKeywordMgr.addNewDocKeywords(document);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForRelDocs.class, "DocumentLCListenerForRelDocs.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(DocumentLCListenerForRelDocs.class, "DocumentLCListenerForRelDocs.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        Document document = (Document)_oObjDeleted;
        this.m_oDocKeywordMgr.removeDocKeywords(document);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForRelDocs.class, "DocumentLCListenerForRelDocs.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(DocumentLCListenerForRelDocs.class, "DocumentLCListenerForRelDocs.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        Document document = (Document)_oObjModified;
        if (!_oObjModified.isChangeProperty("DOCKEYWORDS")) {
            int nOldChnlId;
            Channel oldDocChannel;
            int nChannelId;
            Channel newDocChannel;
            if (_oObjModified.isChangeProperty("DocChannel") && (newDocChannel = Channel.findById(nChannelId = _oObjModified.getNewPropertyAsInt("DocChannel", 0))) != null && (oldDocChannel = Channel.findById(nOldChnlId = _oObjModified.getPropertyAsInt("DocChannel", 0))) != null && newDocChannel.getSiteId() != oldDocChannel.getSiteId()) {
                String[] sql = new String[]{"UPDATE WCMDocKeyword SET SiteId=? WHERE DocId=?"};
                int[] params = new int[]{newDocChannel.getSiteId(), _oObjModified.getId()};
                DBManager.getDBManager().sqlExecuteUpdate(sql, params);
            }
            if (_oObjModified.isChangeProperty("DocRelTime")) {
                String[] sql = new String[]{"UPDATE WCMDocKeyword SET DOCCRTIME=? WHERE DocId=?"};
                Object[] params = new Object[]{document.getNewProperty("DocRelTime"), _oObjModified.getKey()};
                DBManager.getDBManager().sqlExecuteUpdate(sql, params);
            }
            return;
        }
        this.m_oDocKeywordMgr.updateDocKeywords(document, document.getKeywords(), document.getNewPropertyAsString("DOCKEYWORDS"));
    }
}

