/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;

public class DocumentLCListenerForExternalFile
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private FilesMan m_filesman = FilesMan.getFilesMan();

    private void setDocFile(BaseObj _oObjAdded, String _sSrcFile) throws WCMException {
        String sNewExternalFile = this.m_filesman.getNextFileName("P0", CMyFile.extractFileExt(_sSrcFile), null, true);
        User currUser = ContextHelper.getLoginUser();
        Document document = (Document)_oObjAdded;
        try {
            CMyFile.copyFile(_sSrcFile, sNewExternalFile);
            document.canEdit(currUser);
            _oObjAdded.setProperty("DOCFILENAME", CMyFile.extractFileName(sNewExternalFile));
            document.update(currUser);
        }
        catch (CMyException e) {
            throw new WCMException(1100, I18NMessage.get(DocumentLCListenerForExternalFile.class, "DocumentLCListenerForExternalFile.label1", "\u5904\u7406\u6587\u4ef6\u5931\u8d25!"), e);
        }
        finally {
            String name = CMyFile.extractFileName(_sSrcFile);
            if (name.indexOf("U0") == 0) {
                CMyFile.deleteFile(_sSrcFile);
            }
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        String sDocFile;
        if (this.isListening(_oObjDeleted) && CMyFile.fileExists(sDocFile = this.getDocFile(_oObjDeleted))) {
            CMyFile.deleteFile(sDocFile);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (this.isListening(_oObjModified) && _oObjModified.isChangeProperty("DOCFILENAME")) {
            String sOldFile = this.getDocFile(_oObjModified);
            String sNewFile = _oObjModified.getNewPropertyAsString("DOCFILENAME");
            if (sNewFile.indexOf("U0") != 0) {
                return;
            }
            if (CMyFile.fileExists(sOldFile) && this.unUsedByDocBak(_oObjModified.getId(), sOldFile)) {
                CMyFile.deleteFile(sOldFile);
            }
            String sPath = this.m_filesman.mapFilePath(sNewFile, 0);
            this.setDocFile(_oObjModified, sPath + sNewFile);
        }
    }

    private boolean unUsedByDocBak(int _nDocId, String _sFile) throws WCMException {
        String sSQL = "SELECT COUNT(DocId) FROM WCMDOCBAK WHERE DocId=" + _nDocId + " AND DocFileName='" + CMyFile.extractFileName(_sFile) + "'";
        return DBManager.getDBManager().sqlExecuteIntQuery(sSQL) == 0;
    }

    private String getDocFile(BaseObj _listened) throws WCMException {
        String sExternalFile = _listened.getPropertyAsString("DOCFILENAME");
        if (sExternalFile == null || sExternalFile.trim().length() == 0) {
            return "";
        }
        String sPath = this.m_filesman.mapFilePath(sExternalFile, 0);
        return sPath + sExternalFile;
    }

    private boolean isListening(BaseObj _listened) {
        if (_listened != null && _listened instanceof Document) {
            return ((Document)_listened).getType() == 40;
        }
        return false;
    }
}

