/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.advisor.OptionGroup;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;

public class Option
extends CMSObj {
    public static final int OBJ_TYPE = 1705862168;
    public static final String DB_TABLE_NAME = "XWCMOPTION";
    public static final String DB_ID_NAME = "OPTIONID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1705862168;
    }

    public String getOptionName() {
        return this.getPropertyAsString("OPTIONNAME");
    }

    public boolean setOptionName(String _sOptionName) throws WCMException {
        return this.setProperty("OPTIONNAME", _sOptionName);
    }

    public String getOptionDesc() {
        return this.getPropertyAsString("OPTIONDESC");
    }

    public boolean setOptionDesc(String _sOptionDesc) throws WCMException {
        return this.setProperty("OPTIONDESC", _sOptionDesc);
    }

    public String getPicFileName() {
        return this.getPropertyAsString("PICTRUE");
    }

    public boolean setPicFileName(String _sPicFileName) throws WCMException {
        return this.setProperty("PICTRUE", _sPicFileName);
    }

    public String getLastOptions() {
        return this.getPropertyAsString("LASTOPTIONS");
    }

    public boolean setLastOptions(String _sLastOptions) throws WCMException {
        return this.setProperty("LASTOPTIONS", _sLastOptions);
    }

    public String getSearchCondition() {
        return this.getPropertyAsString("SEARCHCONDITION");
    }

    public boolean setSearchCondition(String _sSearchCondition) throws WCMException {
        return this.setProperty("SEARCHCONDITION", _sSearchCondition);
    }

    public String getNotAllowedSelectOptions() {
        return this.getPropertyAsString("NOTALLOWEDSELECTOPTIONS");
    }

    public boolean setNotAllowedSelectOptions(String _sNotAllowedSelectOptions) throws WCMException {
        return this.setProperty("NOTALLOWEDSELECTOPTIONS", _sNotAllowedSelectOptions);
    }

    public int getGroupId() {
        return this.getPropertyAsInt("GROUPID", 0);
    }

    public boolean setGroupId(int _nGroupId) throws WCMException {
        return this.setProperty("GROUPID", _nGroupId);
    }

    public int getStepId() {
        return this.getPropertyAsInt("STEPID", 0);
    }

    public boolean setStepId(int _nStepId) throws WCMException {
        return this.setProperty("STEPID", _nStepId);
    }

    public int getOrder() {
        return this.getPropertyAsInt("AORDER", 0);
    }

    public boolean setOrder(int _nAOrder) throws WCMException {
        return this.setProperty("AORDER", _nAOrder);
    }

    @Override
    public boolean isValid() throws WCMException {
        int nGroupId = 0;
        if (this.isAddMode()) {
            if (this.getProperty("OPTIONNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Option.class, "Option.label1", "\u5c5e\u6027OptionName\u6ca1\u6709\u8bbe\u7f6e(Option.isValid)"));
            }
            if (this.getProperty("GROUPID") == null) {
                throw new WCMException(1106, I18NMessage.get(Option.class, "Option.label2", "\u5c5e\u6027GroupId\u6ca1\u6709\u8bbe\u7f6e(Option.isValid)"));
            }
            nGroupId = this.getGroupId();
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Option.class, "Option.label3", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Option.isValid)"));
            }
            if (this.isChangeProperty("GROUPID")) {
                nGroupId = this.getNewPropertyAsInt("GROUPID", 0);
            }
            if (this.isChangeProperty("PICTRUE")) {
                FilesMan filesMan = FilesMan.getFilesMan();
                String sOriginalFileName = this.getPicFileName();
                if (!CMyString.isEmpty(sOriginalFileName)) {
                    String sDstFilePath = filesMan.mapFilePath(sOriginalFileName, 0) + sOriginalFileName;
                    CMyFile.deleteFile(sDstFilePath);
                }
            }
        }
        if (nGroupId > 0) {
            OptionGroup oGroup = OptionGroup.findById(nGroupId);
            if (oGroup == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nGroupId), WCMTypes.getLowerObjName(266112697)}));
            }
            this.setStepId(oGroup.getStepId());
        }
        this.changeOrder();
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    @Override
    public int delete() throws WCMException {
        this.deleteRelationFiles();
        return super.delete();
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        this.deleteRelationFiles();
        return super.delete(_currUser);
    }

    private void deleteRelationFiles() throws WCMException {
        String sImgFileName = this.getPicFileName();
        if (!CMyString.isEmpty(sImgFileName)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sDstFilePath = filesMan.mapFilePath(sImgFileName, 0) + sImgFileName;
            CMyFile.deleteFile(sDstFilePath);
        }
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nMoveBeginAt = 0;
        int nMoveEndAt = 0;
        int nMoveDirection = 0;
        if (this.isAddMode()) {
            nNewOrder = this.getOrder();
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
                this.setOrder(nNewOrder);
                return;
            }
            nMoveDirection = 1;
            nMoveEndAt = nMaxOrder;
            nMoveBeginAt = nNewOrder;
        } else {
            if (!this.isChangeProperty("AORDER")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("AORDER", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == this.getOrder()) {
                    nNewOrder = this.getOrder();
                } else {
                    nMoveDirection = -1;
                    nMoveEndAt = nMaxOrder;
                    nMoveBeginAt = this.getOrder() + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > this.getOrder()) {
                nMoveDirection = -1;
                nMoveEndAt = nNewOrder;
                nMoveBeginAt = this.getOrder() + 1;
            } else {
                nMoveDirection = 1;
                nMoveEndAt = this.getOrder() - 1;
                nMoveBeginAt = nNewOrder;
            }
        }
        String sRegionWhere = "AORDER>=" + nMoveBeginAt + " AND AORDER <= " + nMoveEndAt + " and GROUPID=" + this.getGroupId();
        String sMoveSql = "UPDATE XWCMOPTION SET AORDER = AORDER+(" + nMoveDirection + ") WHERE " + sRegionWhere;
        DBManager.getDBManager().sqlExecuteUpdate(sMoveSql);
        this.setOrder(nNewOrder);
    }

    private int getMaxOrder() throws WCMException {
        String SQL_QUERY_MAX_ORDER = "select max(AORDER) from XWCMOPTION where GROUPID=?";
        return DBManager.getDBManager().sqlExecuteIntQuery("select max(AORDER) from XWCMOPTION where GROUPID=?", new int[]{this.getGroupId()});
    }

    public static final Option findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Option)BaseObj.findById(Option.class, _nId);
    }

    public static final Option createNewInstance() throws WCMException {
        return (Option)BaseObj.createNewInstance(Option.class);
    }

    public static final Option findByKey(Object _oKey) throws WCMException {
        return (Option)BaseObj.findByKey(Option.class, _oKey);
    }
}

