/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.metadata.definition.ClassInfo;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class StatDocCountOfUserByMetaClass {
    public static final int MODAL_STAT_NORM = 1;
    public static final int MODAL_STAT_SNAP = 2;
    public int m_nStatModal = 2;
    private String m_sSQL = null;

    public StatDocCountOfUserByMetaClass(String _sStatSQL) {
        this.m_sSQL = _sStatSQL;
    }

    public HashMap stat(int _nRootClassInfoId, CMyDateTime _dtStartTime) throws Exception {
        DBType currDBType = DBManager.getDBManager().getDBType();
        String sStartTime = _dtStartTime.toString("yyyy-MM-dd 00:00:00");
        sStartTime = currDBType.sqlDate(sStartTime);
        String sEndTime = _dtStartTime.toString("yyyy-MM-dd 23:59:59");
        sEndTime = currDBType.sqlDate(sEndTime);
        HashMap hResult = this.queryData(_nRootClassInfoId, sStartTime, sEndTime);
        if (this.m_nStatModal == 2) {
            this.mergeChildCountToParent(hResult);
        }
        return hResult;
    }

    public HashMap stat(int _nRootClassInfoId, CMyDateTime _dtStartTime, CMyDateTime _dtEndTime) throws Exception {
        DBType currDBType = DBManager.getDBManager().getDBType();
        String sStartTime = currDBType.sqlDate(_dtStartTime.toString());
        String sEndTime = currDBType.sqlDate(_dtEndTime.toString());
        HashMap hResult = this.queryData(_nRootClassInfoId, sStartTime, sEndTime);
        if (this.m_nStatModal == 2) {
            this.mergeChildCountToParent(hResult);
        }
        return hResult;
    }

    public CMyDateTime createStatDataInTempTableByDay(CMyDateTime _dtStartTime, CMyDateTime _dtEndTime) throws Exception {
        return null;
    }

    private HashMap queryData(int _nRootClassInfoId, String _sStartTime, String _sEndTime) throws WCMException {
        HashMap<String, String> hParameters = new HashMap<String, String>();
        hParameters.put("ROOTID", String.valueOf(_nRootClassInfoId));
        hParameters.put("STARTTIME", _sStartTime);
        hParameters.put("ENDTIME", _sEndTime);
        String sSQL = CMyString.parsePageVariables(this.m_sSQL, hParameters);
        HashMap<Integer, HashMap<String, Integer>> hResult = new HashMap<Integer, HashMap<String, Integer>>(2000);
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = sSQL;
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            rsData = oStmt.executeQuery();
            while (rsData.next()) {
                int nDataCount = rsData.getInt(1);
                int nClassInfoId = rsData.getInt(2);
                String sCrUserName = rsData.getString(3);
                Integer iClassInfoKey = new Integer(nClassInfoId);
                HashMap<String, Integer> hCrUserDataCount = (HashMap<String, Integer>)hResult.get(iClassInfoKey);
                if (hCrUserDataCount == null) {
                    hCrUserDataCount = new HashMap<String, Integer>();
                    hResult.put(iClassInfoKey, hCrUserDataCount);
                }
                hCrUserDataCount.put(sCrUserName, new Integer(nDataCount));
                this.addDataCountOfRoot(hResult, nDataCount, sCrUserName);
            }
        }
        catch (SQLException ex) {
            throw new WCMException(I18NMessage.get(StatDocCountOfUserByMetaClass.class, "StatDocCountOfUserByMetaClass.label1", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(StatDocCountOfUserByMetaClass.class, "StatDocCountOfUserByMetaClass.label1", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        finally {
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
        }
        return hResult;
    }

    private void mergeChildCountToParent(HashMap _hResult) throws WCMException {
        HashMap hTemp = new HashMap();
        for (Integer iCurrChannel : _hResult.keySet()) {
            ClassInfo classInfo;
            int nClassInfoId = iCurrChannel;
            if (nClassInfoId == 0 || (classInfo = ClassInfo.findById(nClassInfoId)) == null) continue;
            HashMap hUserDataCountOnCurrChannel = (HashMap)_hResult.get(iCurrChannel);
            Object[] pUserNamesOnCurrChannel = hUserDataCountOnCurrChannel.keySet().toArray();
            for (ClassInfo parent = classInfo.getParent(); parent != null && !parent.isRoot(); parent = parent.getParent()) {
                this.addToParentClassInfo(parent, hTemp, hUserDataCountOnCurrChannel, pUserNamesOnCurrChannel);
            }
        }
        for (Object iTempChannelKey : hTemp.keySet()) {
            HashMap hTempUserDatas = (HashMap)hTemp.get(iTempChannelKey);
            HashMap hExistsDataMap = (HashMap)_hResult.get(iTempChannelKey);
            if (hExistsDataMap == null) {
                _hResult.put(iTempChannelKey, hTempUserDatas);
                continue;
            }
            for (Object sUserName : hTempUserDatas.keySet()) {
                Integer iMergeDataCount = (Integer)hTempUserDatas.get(sUserName);
                Integer iExistsDataCount = (Integer)hExistsDataMap.get(sUserName);
                int iFinalCount = iExistsDataCount == null ? 0 : iExistsDataCount;
                hExistsDataMap.put(sUserName, new Integer(iFinalCount += iMergeDataCount.intValue()));
            }
        }
    }

    private void addToParentClassInfo(ClassInfo _parent, HashMap _hResultTemp, HashMap _hUserDataCountOnCurrChannel, Object[] _pUserNamesOnCurrChannel) {
        Integer iParentKey = new Integer(_parent.getId());
        HashMap<String, Integer> hCrUserDataCountOnParent = (HashMap<String, Integer>)_hResultTemp.get(iParentKey);
        if (hCrUserDataCountOnParent == null) {
            hCrUserDataCountOnParent = new HashMap<String, Integer>();
            _hResultTemp.put(iParentKey, hCrUserDataCountOnParent);
        }
        for (int i = 0; i < _pUserNamesOnCurrChannel.length; ++i) {
            String sUserName = _pUserNamesOnCurrChannel[i].toString();
            int nCurrCount = (Integer)_hUserDataCountOnCurrChannel.get(sUserName);
            Integer iDataCountOnParent = (Integer)hCrUserDataCountOnParent.get(sUserName);
            int nDataCountOnParent = iDataCountOnParent == null ? 0 : iDataCountOnParent;
            hCrUserDataCountOnParent.put(sUserName, new Integer(nDataCountOnParent += nCurrCount));
        }
    }

    private void addDataCountOfRoot(HashMap _hResult, int _nDataCountOfChannel, String _sCrUserName) {
        Integer iDataCount;
        Integer iRootClassKey = new Integer(0);
        HashMap<String, Integer> hCrUserDataCountOnRootClassInfo = (HashMap<String, Integer>)_hResult.get(iRootClassKey);
        if (hCrUserDataCountOnRootClassInfo == null) {
            hCrUserDataCountOnRootClassInfo = new HashMap<String, Integer>();
            _hResult.put(iRootClassKey, hCrUserDataCountOnRootClassInfo);
        }
        int nDataCountOnSite = (iDataCount = (Integer)hCrUserDataCountOnRootClassInfo.get(_sCrUserName)) == null ? 0 : iDataCount;
        hCrUserDataCountOnRootClassInfo.put(_sCrUserName, new Integer(nDataCountOnSite += _nDataCountOfChannel));
    }
}

