/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.special;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.PageStyle;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.components.special.ISpecialMgr;
import com.trs.components.special.ISpecialServiceProvider;
import com.trs.components.special.Special;
import com.trs.components.special.Specials;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.context.MethodContext;
import javax.servlet.http.HttpServletRequest;

public class SpecialServiceProvider
implements ISpecialServiceProvider {
    private ISpecialMgr m_oSpecialMgr = (ISpecialMgr)DreamFactory.createObjectById("ISpecialMgr");

    @Override
    public void delete(MethodContext _context) throws Exception {
        User loginUser = ContextHelper.getLoginUser();
        Specials specials = Specials.findByIds(loginUser, _context.getObjectIds());
        boolean bDrop = _context.getValue("Drop", false);
        int nSize = specials.size();
        for (int i = 0; i < nSize; ++i) {
            Special special = (Special)specials.getAt(i);
            if (special == null) continue;
            if (bDrop) {
                if (!SpecialAuthServer.hasRight(loginUser, special, 3)) {
                    throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u4e13\u9898\u3010" + special.getSpecialName() + "\u3011\uff01");
                }
            } else if (!SpecialAuthServer.hasRight(loginUser, special, 2)) {
                throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5c06\u4e13\u9898\u3010" + special.getSpecialName() + "\u3011\u653e\u5165\u56de\u6536\u7ad9\uff01");
            }
            this.m_oSpecialMgr.delete(loginUser, special, bDrop);
        }
    }

    @Override
    public boolean existsSimilarName(MethodContext _context) throws Exception {
        String _specialName = _context.getValue("SpecialName");
        int _nObjectId = _context.getObjectId();
        return this.m_oSpecialMgr.existsSimilarName(_nObjectId, _specialName);
    }

    @Override
    public Object query(MethodContext _context) throws Exception {
        User loginUser = ContextHelper.getLoginUser();
        WCMFilter filter = new WCMFilter();
        int nStatus = _context.getValue("Status", 0);
        String sWhere = "STATUS=?";
        filter.addSearchValues(nStatus);
        if (!loginUser.isAdministrator() && _context.getValue("OnlyMine", false)) {
            sWhere = sWhere + " and CRUSER=?";
            filter.addSearchValues(loginUser.getName());
        }
        filter.setWhere(sWhere);
        filter.mergeWith(_context.getExtraWCMFilter());
        Specials specials = this.m_oSpecialMgr.query(loginUser, filter);
        for (int i = specials.size() - 1; i >= 0; --i) {
            Special currSpecial = (Special)specials.getAt(i);
            if (currSpecial == null || SpecialAuthServer.hasRight(loginUser, currSpecial, 4)) continue;
            specials.remove(currSpecial, false);
        }
        return specials;
    }

    @Override
    public int save(MethodContext _context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        Special special = null;
        String sSpecialName = _context.getValue("SpecialName");
        String sStyleName = _context.getValue("StyleName");
        int nObjectId = _context.getObjectId();
        if (nObjectId == 0) {
            special = new Special();
            if (this.m_oSpecialMgr.existsSimilarName(0, sSpecialName)) {
                throw new WCMException(1008, "\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a[" + sSpecialName + "]\u7684\u4e13\u9898\u3002");
            }
        } else {
            special = Special.findById(nObjectId);
            if (special == null) {
                throw new WCMException("\u6307\u5b9a\u7684\u4e13\u9898\u4e0d\u5b58\u5728\uff01[ObjectId=" + nObjectId + "]");
            }
        }
        if (special.isAddMode()) {
            if (!SpecialAuthServer.hasRight(loginUser, special, 1)) {
                throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u4e13\u9898\uff01");
            }
        } else if (!SpecialAuthServer.hasRight(loginUser, special, 2)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u4e13\u9898\u3010" + special.getSpecialName() + "\u3011");
        }
        String[] pLogicFields = new String[]{"ObjectId", "StyleName"};
        special = (Special)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _context, special, pLogicFields);
        HttpServletRequest req = _context.getServiceContext().getRequest();
        String sHost = "127.0.0.1";
        int nPort = 8080;
        if (req != null) {
            sHost = req.getServerName();
            nPort = req.getServerPort();
        }
        String special_SiteHttp = "http://" + sHost + ":" + nPort + "/pub/special";
        this.m_oSpecialMgr.save(loginUser, special, special_SiteHttp);
        PageStyle pageStyle = PageStyle.findByName(sStyleName);
        if (pageStyle == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u9875\u9762\u98ce\u683c\u4e0d\u5b58\u5728\uff01[StyleName=" + sStyleName + "]");
        }
        this.m_oSpecialMgr.setStyle(special, pageStyle);
        return special.getId();
    }

    @Override
    public boolean setStyle(MethodContext _context) throws Throwable {
        int nObjId = _context.getObjectId();
        String sSytleName = _context.getValue("StyleName");
        int nStyeId = _context.getValue("StyleId", 0);
        Special special = Special.findById(nObjId);
        if (special == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u4e13\u9898\u4e0d\u5b58\u5728\uff01[ObjectId=" + nObjId + "]");
        }
        PageStyle pageStyle = null;
        if (sSytleName != null && !sSytleName.trim().equals("")) {
            pageStyle = PageStyle.findByName(sSytleName);
        } else if (nStyeId != 0) {
            pageStyle = PageStyle.findById(nStyeId);
        }
        if (pageStyle == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u9875\u9762\u98ce\u683c\u4e0d\u5b58\u5728\uff01");
        }
        return this.m_oSpecialMgr.setStyle(special, pageStyle);
    }

    @Override
    public PageStyle getStyle(MethodContext _context) throws Exception {
        int nObjId = _context.getObjectId();
        Special special = Special.findById(nObjId);
        if (special == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u4e13\u9898\u4e0d\u5b58\u5728\uff01[ObjectId=" + nObjId + "]");
        }
        return this.m_oSpecialMgr.getStyle(special);
    }

    @Override
    public boolean createFrom(MethodContext _context) throws Throwable {
        int nObjId = _context.getObjectId();
        Special special = Special.findById(nObjId);
        if (special == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u4e13\u9898\u4e0d\u5b58\u5728\uff01[ObjectId=" + nObjId + "]");
        }
        if (!SpecialAuthServer.hasRight(ContextHelper.getLoginUser(), special, 1)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u4e13\u9898\uff01");
        }
        return this.m_oSpecialMgr.createFrom(special);
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        int nObjId = context.getObjectId();
        return Special.findById(nObjId);
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        String sObjIds = context.getObjectIds();
        return Specials.findByIds(loginUser, sObjIds);
    }

    @Override
    public void restore(MethodContext _context) throws Exception {
        User loginUser = ContextHelper.getLoginUser();
        String sObjIds = _context.getObjectIds();
        Specials oSpecials = Specials.findByIds(loginUser, sObjIds);
        int nSize = oSpecials.size();
        for (int i = 0; i < nSize; ++i) {
            Special oCurrSpecial = (Special)oSpecials.getAt(i);
            if (oCurrSpecial == null) continue;
            if (!SpecialAuthServer.hasRight(loginUser, oCurrSpecial, 2)) {
                throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u6062\u590d\u56de\u6536\u7ad9\u4e2d\u7684\u4e13\u9898\uff01");
            }
            this.m_oSpecialMgr.restore(loginUser, oCurrSpecial);
        }
    }

    @Override
    public Specials findByChnlIds(MethodContext context) throws Exception {
        String sChnlIds = context.getValue("ChannelIds");
        return this.m_oSpecialMgr.findSpecialsByChnlIds(ContextHelper.getLoginUser(), sChnlIds);
    }
}

