/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.center.xml.MetaViewDataExporter;
import com.trs.components.metadata.center.xml.MetaViewDataImporter;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDataDefHelper;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.service.ViewRangeConstants;
import com.trs.components.metadata.service.WCMFilterMakerForContainsChildren;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaDataCenterServiceProviderForAgri
implements ISelfDefinedServiceProvider {
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private IMetaDataDefMgr m_oMetaDataDefMgr = null;
    private Logger logger = Logger.getLogger(MetaDataCenterServiceProviderForAgri.class);
    private AppendixMgr m_oAppendixMgr = null;
    private IClassInfoMgr m_oClassInfoMgr = null;

    public MetaDataCenterServiceProviderForAgri() {
        this.m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        this.m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
    }

    public MetaViewData saveMetaViewData(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = null;
        channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
        if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
            throw new WCMException(1002, "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[" + channel.getName() + "][ID=" + channel.getId() + "]\u4e0b\u65b0\u5efa\u8bb0\u5f55\uff01");
        }
        MetaView view = null;
        MetaViewData oMetaViewData = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            view = this.findViewById(_methodContext.getValue("ViewId", 0));
            oMetaViewData = new MetaViewData(view);
        } else {
            oMetaViewData = MetaViewData.findById(nObjectId);
            if (oMetaViewData == null) {
                throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5728\u6307\u5b9a\u89c6\u56fe\u4e0b\u63d0\u4ea4\u7684\u6570\u636e\uff01[Id=" + nObjectId + "]");
            }
            view = oMetaViewData.getMetaView();
            oMetaViewData.validCanEditAndLock(loginUser);
        }
        MetaDataCenterServiceProviderForAgri.setViewDataProperties(_methodContext, oMetaViewData);
        switch (view.getId()) {
            case 40: {
                this.synIndexIdOnSaveDeptCode(oMetaViewData);
                break;
            }
            case 39: {
                String sPubDate;
                if (!oMetaViewData.isAddMode() || (sPubDate = oMetaViewData.getPropertyAsString("PubDate")) == null || sPubDate.length() <= 0) break;
                List<Channel> lChildren = channel.getHost().getChildren(null);
                String sTemp = "00" + (lChildren.indexOf(channel) + 1);
                String sChannelIndex = sTemp.substring(sTemp.length() - 2);
                String sIndexId = "07B" + sChannelIndex + this.makeClassCode(oMetaViewData, "themecat") + this.makeClassCode(oMetaViewData, "subcat") + _methodContext.getValue("PubDate").substring(0, 4) + this.makeId(oMetaViewData);
                oMetaViewData.setProperty("IdxID", sIndexId);
                break;
            }
        }
        oMetaViewData.save(loginUser);
        return oMetaViewData;
    }

    private String makeClassCode(MetaViewData oMetaViewData, String _sClassFieldName) throws WCMException {
        String sIds = oMetaViewData.getPropertyAsString(_sClassFieldName);
        if (CMyString.isEmpty(sIds)) {
            return "00";
        }
        ClassInfos classInfos = ClassInfos.findByIds(null, sIds);
        if (classInfos.isEmpty()) {
            return "00";
        }
        ClassInfo classInfo = (ClassInfo)classInfos.getAt(0);
        ClassInfo parent = ClassInfo.findById(classInfo.getParentId());
        ClassInfos children = this.m_oClassInfoMgr.queryChildren(null, parent, null);
        int nIndex = children.indexOf(classInfo.getId()) + 1;
        String sIndex = "00" + nIndex;
        return sIndex.substring(sIndex.length() - 2);
    }

    private void synIndexIdOnSaveDeptCode(MetaViewData _oMetaViewData) throws WCMException {
        String sDName = _oMetaViewData.getPropertyAsString("DName");
        String sDCode = _oMetaViewData.getPropertyAsString("DCode");
        String[] sOldCode = new String[]{"00000000", null};
        if (!_oMetaViewData.isAddMode()) {
            boolean bChangeNameOrCode = false;
            if (_oMetaViewData.isChangeProperty("DName")) {
                sDName = _oMetaViewData.getNewPropertyAsString("DName");
                bChangeNameOrCode = true;
            }
            if (_oMetaViewData.isChangeProperty("DCode")) {
                sOldCode[1] = sDCode;
                sDCode = _oMetaViewData.getNewPropertyAsString("DCode");
                bChangeNameOrCode = true;
            }
            if (!bChangeNameOrCode) {
                return;
            }
        }
        String[] pUpdateSQL = new String[]{"update WCMMetaTableGovInfo set idxId=replace(idxId, ?, ?) where Publisher=?"};
        for (int i = 0; i < sOldCode.length; ++i) {
            if (sOldCode[i] == null) continue;
            String[] pParameters = new String[]{sOldCode[i], sDCode, sDName};
            DBManager.getDBManager().sqlExecuteUpdate(pUpdateSQL, pParameters);
        }
    }

    public MetaViewData saveMetaViewDataOfGov(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaView view = this.findViewById(_methodContext.getValue("ViewId", 0));
        MetaViewData oMetaViewData = new MetaViewData(view);
        MetaDataCenterServiceProviderForAgri.setViewDataProperties(_methodContext, oMetaViewData);
        int nChannelId = this.makeChannelId(_methodContext);
        if (nChannelId <= 0) {
            throw new WCMException("\u6307\u5b9a\u7684DocChannel\u4fe1\u606f\u6709\u8bef\uff01[" + _methodContext.getValue("DocChannel") + "]");
        }
        oMetaViewData.setProperty("ChannelId", nChannelId);
        this.dowithClassFieldValue(_methodContext, view, oMetaViewData, "themecat");
        this.dowithClassFieldValue(_methodContext, view, oMetaViewData, "subcat");
        String sPubDate = _methodContext.getValue("PubDate");
        if (sPubDate != null && sPubDate.length() > 0) {
            String sIndexId = "07B" + _methodContext.getValue("DocChannel") + _methodContext.getValue("themecat") + _methodContext.getValue("subcat") + _methodContext.getValue("PubDate").substring(0, 4) + this.makeId(oMetaViewData);
            oMetaViewData.setProperty("IdxID", sIndexId);
        }
        oMetaViewData.setProperty("Content", _methodContext.getValue("Content"));
        oMetaViewData.save(loginUser);
        return oMetaViewData;
    }

    private void dowithClassFieldValue(MethodContext _methodContext, MetaView view, MetaViewData oMetaViewData, String sFieldName) throws WCMException {
        IMetaDataDefCacheMgr oCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        MetaViewField viewField = oCacheMgr.getMetaViewField(view.getId(), sFieldName);
        if (viewField == null || viewField.getType() != 10) {
            throw new WCMException("\u7cfb\u7edf\u914d\u7f6e\u9519\u8bef\uff0c\u6307\u5b9a\u5b57\u6bb5\u4e0d\u662f\u5206\u7c7b\u5b57\u6bb5\uff01[\u5b57\u6bb5\u540d\u79f0=" + sFieldName + "]");
        }
        ClassInfos classInfos = this.m_oClassInfoMgr.queryChildren(null, ClassInfo.findById(viewField.getClassId()), null);
        int nChildIndex = MetaDataCenterServiceProviderForAgri.convertToInt(_methodContext.getValue(sFieldName));
        int nClassInfoId = classInfos.getIdAt(nChildIndex - 1);
        oMetaViewData.setProperty(sFieldName, String.valueOf(nClassInfoId));
    }

    private void synIndexIdOnSaveGovInfo(MetaViewData _oMetaViewData) throws WCMException {
        String sPublisher = _oMetaViewData.getPropertyAsString("Publisher");
        String sPubDate = _oMetaViewData.getPropertyAsString("PubDate");
        String sIdxId = null;
        if (!_oMetaViewData.isAddMode()) {
            sIdxId = _oMetaViewData.getPropertyAsString("IdxID");
            boolean bNeedSynIndexId = false;
            if (_oMetaViewData.isChangeProperty("Publisher")) {
                sPublisher = _oMetaViewData.getNewPropertyAsString("Publisher");
                bNeedSynIndexId = true;
            }
            if (_oMetaViewData.isChangeProperty("PubDate")) {
                sPubDate = _oMetaViewData.getNewPropertyAsString("PubDate");
                bNeedSynIndexId = true;
                sIdxId = null;
            }
            if (!bNeedSynIndexId) {
                return;
            }
        }
        if (!(sPublisher != null && (sPublisher = sPublisher.trim()).length() != 0 || sPubDate != null && (sPubDate = sPubDate.trim()).length() != 0)) {
            return;
        }
        String sDeptCode = MetaDataCenterServiceProviderForAgri.queryDeptCode(sPublisher);
        String sIdxID = sDeptCode + "/" + sPubDate.substring(0, 4) + "-" + this.makeId(_oMetaViewData);
        this.logger.debug((Object)("Index Id:" + sIdxID));
        _oMetaViewData.setProperty("IdxID", sIdxID);
    }

    private String makeId(MetaViewData _oMetaViewData) throws WCMException {
        String sIdxId = null;
        String sPubDate = _oMetaViewData.getPropertyAsString("PubDate");
        if (!_oMetaViewData.isAddMode()) {
            sIdxId = _oMetaViewData.getPropertyAsString("IdxID");
            if (_oMetaViewData.isChangeProperty("PubDate")) {
                sPubDate = _oMetaViewData.getNewPropertyAsString("PubDate");
                sIdxId = null;
            }
        }
        String sId = null;
        if (sIdxId == null) {
            String sDate = sPubDate.substring(0, 4);
            try {
                WCMFilter filter = new WCMFilter(_oMetaViewData.getDbTableName(), "PubDate>=? and PubDate<=?", "", "count(*)");
                CMyDateTime dtStartTime = new CMyDateTime();
                dtStartTime.setDateTimeWithString(sDate + "-01-01 00:00:00");
                filter.addSearchValues(dtStartTime);
                CMyDateTime dtEndTime = new CMyDateTime();
                dtEndTime.setDateTimeWithString(sDate + "-12-31 23:59:59");
                filter.addSearchValues(dtEndTime);
                int nCount = DBManager.getDBManager().sqlExecuteCountQuery(filter) + 1;
                sId = "00000" + nCount;
                sId = sId.substring(sId.length() - 5);
            }
            catch (Exception e) {
                throw new WCMException("\u8ba1\u7b97\u6d41\u6c34\u53f7\u5931\u8d25!", e);
            }
        } else {
            sId = sIdxId.substring(sIdxId.length() - 5);
        }
        return sId;
    }

    private int makeChannelId(MethodContext _methodContext) throws WCMException {
        int nPos = MetaDataCenterServiceProviderForAgri.convertToInt(_methodContext.getValue("DocChannel"));
        int nSiteId = 3;
        WebSite site = WebSite.findById(nSiteId);
        if (site == null) {
            this.logger.error((Object)("\u6307\u5b9a\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01[Id=" + nSiteId + "]"));
            return 0;
        }
        Channel channel = site.getChildAt(nPos - 1);
        if (channel == null) {
            this.logger.error((Object)("\u6307\u5b9a\u4f4d\u7f6e[" + nPos + "]\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
            return 0;
        }
        return channel.getId();
    }

    private static int convertToInt(String _sValue) {
        if (_sValue.charAt(0) == '0') {
            _sValue = _sValue.substring(1);
        }
        return Integer.parseInt(_sValue);
    }

    public Reports importMetaViewDatas(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = null;
        MetaView view = null;
        channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
        if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
            throw new WCMException(1002, "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[" + channel.getName() + "][ID=" + channel.getId() + "]\u4e0b\u65b0\u5efa\u6587\u6863\uff01");
        }
        view = this.findViewById(_methodContext.getValue("ViewId", 0));
        String sXSLFile = null;
        sXSLFile = _methodContext.getValue("XMLSource", 3) == 3 ? MetaDataDefHelper.getViewApplicationPath(view.getId()) + "data.xsl" : _methodContext.getValue("XSLFile");
        MetaViewDataImporter importer = new MetaViewDataImporter(loginUser, view, channel);
        return importer.importFromFile(1, _methodContext.getValue("ImportFile"), sXSLFile);
    }

    public MetaViewDatas queryViewDatas(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = null;
        MetaView view = null;
        int nViewId = _methodContext.getValue("ViewId", 0);
        if (nViewId > 0) {
            view = this.findViewById(nViewId);
        } else {
            channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
            view = this.findViewByChannel(channel);
        }
        Channels channels = new Channels(null, 1, 1);
        if (channel != null) {
            int queryType = _methodContext.getValue("_queryType_", 0);
            if (queryType == ViewRangeConstants.SAME_VIEW_CONTAIN_CHILDREN) {
                WCMFilterMakerForContainsChildren maker = new WCMFilterMakerForContainsChildren(channel);
                maker.execute(loginUser);
                channels = maker.getCurrChannels();
            } else if (queryType == ViewRangeConstants.SAME_VIEW_CONTAIN_ALL) {
                channels = this.m_oMetaViewEmployerMgr.getEmployers(view, null);
            } else {
                channels.addElement(channel);
            }
        } else {
            channels = this.m_oMetaViewEmployerMgr.getEmployers(view, null);
        }
        for (int i = channels.size() - 1; i >= 0; --i) {
            Channel oChannel = (Channel)channels.getAt(i);
            if (oChannel == null || AuthServer.hasRight(loginUser, (CMSObj)oChannel, 30)) continue;
            channels.remove(oChannel, false);
        }
        MetaViewDatas viewDatas = new MetaViewDatas(view);
        WCMFilter filter = this.getQueryFilter(_methodContext, loginUser, view);
        viewDatas.setSelectFields(_methodContext.getValue("ChnlDocSelectFields"), filter.getSelect());
        filter.setSelect(null);
        String sqlWhere = _methodContext.getValue("_sqlWhere_");
        if (!CMyString.isEmpty(sqlWhere)) {
            if (filter.getWhere().length() > 0) {
                boolean isOr = _methodContext.getValue("IsOr", true);
                filter.setWhere(filter.getWhere() + (isOr ? " or " : " and ") + "(" + sqlWhere + ")");
            } else {
                filter.setWhere("(" + sqlWhere + ")");
            }
        }
        this.logger.debug((Object)filter);
        viewDatas.setPageSize(_methodContext.getPageSize());
        viewDatas.setCurrPage(_methodContext.getPageIndex());
        viewDatas.open(channels, filter);
        return viewDatas;
    }

    private WCMFilter getQueryFilter(MethodContext _methodContext, User _loginUser, MetaView _view) throws WCMException, CMyException {
        if (_methodContext.getValue("AdvSearch", 0) == 1) {
            WCMFilter filter = _methodContext.getExtraWCMFilter();
            return filter;
        }
        MetaViewFields viewFields = this.m_oMetaDataDefMgr.getViewFields(_loginUser, _view, new WCMFilter("", "InOutline=1 or SearchField=1", ""));
        boolean bMultiTable = _view.isMultiTable();
        WCMFilter filter = new WCMFilter("", "", "");
        StringBuffer sbSelectFields = new StringBuffer((viewFields.size() + 1) * 10);
        StringBuffer sbWhereFields = new StringBuffer(viewFields.size() * 10);
        sbSelectFields.append("MetaDataId");
        String sTrueTableName = _view.getTrueTableName();
        int nSize = viewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField field = (MetaViewField)viewFields.getAt(i);
            if (field == null) continue;
            if (field.isInOutline()) {
                sbSelectFields.append(",");
                if (bMultiTable || field.getDBName().equalsIgnoreCase(field.getName())) {
                    sbSelectFields.append(field.getName());
                } else {
                    sbSelectFields.append(field.getDBName() + " " + field.getName());
                }
            }
            if (!field.isSearchField()) continue;
            boolean isMultiValue = false;
            String sFieldName = sTrueTableName + "." + (bMultiTable ? field.getName() : field.getDBName());
            String sSearchValue = _methodContext.getValue(field.getName());
            if (!_methodContext.getValue("_isAdvanceSearch_", false)) {
                sSearchValue = this.getIdsFromDescs(field, sSearchValue);
            }
            if (field.getType() == 9 || field.getType() == 10) {
                isMultiValue = true;
            }
            this.makeFilter(filter, sbWhereFields, sFieldName, field.getDBType(), sSearchValue, _methodContext.getValue("IsOr", true), _methodContext, isMultiValue);
        }
        filter.setSelect(sbSelectFields.toString());
        if (sbWhereFields.length() > 0) {
            filter.setWhere(sbWhereFields.toString());
        }
        filter.mergeWith(_methodContext.getExtraWCMFilter());
        return filter;
    }

    private String getIdsFromDescs(MetaViewField _field, String _sSearchValue) throws WCMException {
        if (CMyString.isEmpty(_sSearchValue)) {
            return _sSearchValue;
        }
        String[] aSearchValue = null;
        boolean isOr = false;
        if (_sSearchValue.indexOf(124) >= 0) {
            aSearchValue = _sSearchValue.split("\\|");
            isOr = true;
        } else {
            aSearchValue = _sSearchValue.split("\\s");
            isOr = false;
        }
        switch (MetaDataConstants.formatOfEnumValue(_field.getType())) {
            case -1: {
                char lastChar;
                StringBuffer sbSearchValue = new StringBuffer(100);
                HashMap hmEnumValue = _field.getEnmValueMap(false);
                for (int i = 0; i < aSearchValue.length; ++i) {
                    String sId = (String)hmEnumValue.get(aSearchValue[i]);
                    if (sId == null) continue;
                    sbSearchValue.append(sId);
                    sbSearchValue.append(isOr ? "|" : " ");
                }
                if (sbSearchValue.length() > 0 && ((lastChar = sbSearchValue.charAt(sbSearchValue.length() - 1)) == '|' || lastChar == ' ')) {
                    sbSearchValue.setLength(sbSearchValue.length() - 1);
                }
                _sSearchValue = sbSearchValue.toString();
                break;
            }
            case 10: {
                WCMFilter filter = new WCMFilter();
                StringBuffer sbWhere = new StringBuffer(100);
                sbWhere.append("(");
                sbWhere.append("ClassInfoId=" + _field.getClassId());
                sbWhere.append(" or RootId=" + _field.getClassId());
                sbWhere.append(")");
                if (aSearchValue.length > 0) {
                    sbWhere.append(" and (");
                }
                for (int i = 0; i < aSearchValue.length; ++i) {
                    sbWhere.append(" (CName like ?) ");
                    filter.addSearchValues(aSearchValue[i].trim());
                    if (i >= aSearchValue.length - 1) continue;
                    sbWhere.append("or");
                }
                sbWhere.append(")");
                filter.setWhere(sbWhere.toString());
                ClassInfos classInfos = ClassInfos.openWCMObjs(null, filter);
                _sSearchValue = classInfos.getIdListAsString(isOr ? (char)'|' : ' ');
                break;
            }
        }
        return _sSearchValue;
    }

    private void makeFilter(WCMFilter _filter, StringBuffer _sbWhereFields, String _sSearchName, int _nSearchType, String _sSearchValue, boolean _bIsOr, MethodContext _methodContext, boolean _bIsMultiValue) throws CMyException {
        if (CMyString.isEmpty(_sSearchValue) && _nSearchType != 93) {
            return;
        }
        if (_nSearchType != 93) {
            if (_sbWhereFields.length() > 0) {
                _sbWhereFields.append(_bIsOr ? " or " : " and ");
            }
            String[] aSearchValue = null;
            boolean isOr = false;
            if (_sSearchValue.indexOf(124) >= 0) {
                aSearchValue = _sSearchValue.split("\\|");
                isOr = true;
            } else {
                aSearchValue = _sSearchValue.split("\\s");
                isOr = false;
            }
            _sbWhereFields.append("(");
            if (_bIsMultiValue) {
                _sSearchName = DBManager.getDBManager().getDBType().sqlConcatStr("','", _sSearchName, "','");
            }
            for (int j = 0; j < aSearchValue.length; ++j) {
                aSearchValue[j] = aSearchValue[j].trim();
                if (_bIsMultiValue) {
                    aSearchValue[j] = "," + aSearchValue[j] + ",";
                }
                this.makeFilterOfItem(_filter, _sbWhereFields, _sSearchName, _nSearchType, aSearchValue[j], _methodContext, _bIsOr);
                if (j >= aSearchValue.length - 1) continue;
                _sbWhereFields.append(isOr ? " or " : " and ");
            }
            _sbWhereFields.append(")");
        } else {
            this.makeFilterOfItem(_filter, _sbWhereFields, _sSearchName, _nSearchType, _sSearchValue, _methodContext, _bIsOr);
        }
    }

    private void makeFilterOfItem(WCMFilter _filter, StringBuffer _sbWhereFields, String _sSearchName, int _nSearchType, String _sSearchValue, MethodContext _methodContext, boolean _bIsOr) throws CMyException {
        if (CMyString.isEmpty(_sSearchValue) && _nSearchType != 93) {
            return;
        }
        switch (_nSearchType) {
            case 12: {
                _sbWhereFields.append(_sSearchName);
                if (_sSearchValue.startsWith("-")) {
                    _sbWhereFields.append(" not");
                    _sSearchValue = _sSearchValue.substring(1);
                }
                _sbWhereFields.append(" like ?");
                _filter.addSearchValues("%" + _sSearchValue + "%");
                break;
            }
            case 4: {
                _sbWhereFields.append(_sSearchName);
                if (_sSearchValue.startsWith("-")) {
                    _sbWhereFields.append(" !");
                }
                _sbWhereFields.append("=?");
                _filter.addSearchValues(Integer.parseInt(_sSearchValue));
                break;
            }
            case 93: {
                boolean isAdvanceSearch;
                String sEndTimeValue;
                String sDateEndSuffix;
                String sStartTimeValue;
                String sFieldName = _sSearchName.substring(_sSearchName.indexOf(".") + 1);
                String sDateStartSuffix = _methodContext.getValue("_dateStartSuffix_");
                boolean hasStart = false;
                if (sDateStartSuffix != null && !CMyString.isEmpty(sStartTimeValue = _methodContext.getValue(sFieldName + sDateStartSuffix))) {
                    hasStart = true;
                    if (_sbWhereFields.length() > 0) {
                        _sbWhereFields.append(_bIsOr ? " or " : " and ");
                    }
                    _sbWhereFields.append("(");
                    this.setFilterOfDate(_filter, _sbWhereFields, _sSearchName, sStartTimeValue, ">=?", _bIsOr);
                }
                if ((sDateEndSuffix = _methodContext.getValue("_dateEndSuffix_")) != null && !CMyString.isEmpty(sEndTimeValue = _methodContext.getValue(sFieldName + sDateEndSuffix))) {
                    if (hasStart) {
                        _sbWhereFields.append(" and ");
                    } else if (_sbWhereFields.length() > 0) {
                        _sbWhereFields.append(_bIsOr ? " or " : " and ");
                    }
                    this.setFilterOfDate(_filter, _sbWhereFields, _sSearchName, sEndTimeValue, "<=?", _bIsOr);
                }
                if (hasStart) {
                    _sbWhereFields.append(")");
                }
                if ((isAdvanceSearch = _methodContext.getValue("_isAdvanceSearch_", false)) || CMyString.isEmpty(_sSearchValue)) break;
                if (_sbWhereFields.length() > 0) {
                    _sbWhereFields.append(_bIsOr ? " or " : " and ");
                }
                this.setFilterOfDate(_filter, _sbWhereFields, _sSearchName, _sSearchValue, "=?", _bIsOr);
                break;
            }
        }
    }

    private void setFilterOfDate(WCMFilter _filter, StringBuffer _sbWhereFields, String _sFieldName, String _sFieldValue, String _sOperator, boolean _bIsOr) throws CMyException {
        if (!CMyString.isEmpty(_sFieldValue)) {
            _sbWhereFields.append(_sFieldName);
            _sbWhereFields.append(_sOperator);
            CMyDateTime dtTemp = new CMyDateTime();
            dtTemp.setDateTimeWithString(_sFieldValue);
            _filter.addSearchValues(dtTemp);
        }
    }

    public MetaViewData findViewDataById(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methodContext.getObjectId();
        int nViewId = _methodContext.getValue("ViewId", 0);
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        MetaViewData oMetaViewData = null;
        if (nObjectId == 0) {
            MetaView view = null;
            if (nViewId > 0) {
                view = this.findViewById(nViewId);
            } else {
                Channel channel = null;
                channel = this.findChannelById(nChannelId);
                view = this.findViewByChannel(channel);
            }
            oMetaViewData = new MetaViewData(view);
        } else {
            oMetaViewData = MetaViewData.findById(nObjectId);
            if (oMetaViewData == null) {
                throw new WCMException(200006, "\u6307\u5b9a\u7684\u6307\u5b9a\u89c6\u56fe\u6570\u636e\u7684\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=" + nObjectId + "]");
            }
            if (nViewId > 0) {
                if (!loginUser.isAdministrator()) {
                    throw new WCMException(1002, "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u67e5\u770b\u89c6\u56fe\u4e0b\u7684\u6570\u636e\uff01");
                }
            } else {
                Channel channel = null;
                channel = this.findChannelById(nChannelId);
                this.validateRight(loginUser, oMetaViewData, channel, 34, "\u67e5\u770b");
            }
        }
        return oMetaViewData;
    }

    private void validateRight(User _currUser, MetaViewData _metaViewData, Channel _channel, int _rightIndex, String _sDesc) throws WCMException {
        if (_currUser.getName().equalsIgnoreCase(_metaViewData.getCrUserName())) {
            return;
        }
        if (!AuthServer.hasRight(_currUser, (CMSObj)_channel, 34)) {
            throw new WCMException(1002, "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[" + _channel.getName() + "][ID=" + _channel.getId() + "]\u4e0b" + _sDesc + "\u6570\u636e\uff01");
        }
    }

    public Reports deleteViewDatas(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sDeletedIds = _methodContext.getObjectIds();
        Reports reports = new Reports("\u5220\u9664\u89c6\u56fe\u6570\u636e");
        int[] pObjecteds = CMyString.splitToInt(sDeletedIds, ",");
        for (int i = 0; i < pObjecteds.length; ++i) {
            MetaViewData oMetaViewData = MetaViewData.findById(pObjecteds[i]);
            if (oMetaViewData == null) continue;
            try {
                this.validateRight(loginUser, oMetaViewData, 33);
                oMetaViewData.delete(loginUser);
                reports.addSucessedReport("\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=" + pObjecteds[i] + "]\u6210\u529f\uff01");
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport("\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=" + pObjecteds[i] + "]\u5931\u8d25\uff01", e);
            }
        }
        return reports;
    }

    public Reports copy(MethodContext _methodContext) throws Throwable {
        int i;
        Reports reports = new Reports("\u590d\u5236\u6587\u6863");
        User loginUser = this.getLoginUser();
        Channels toChannels = Channels.findByIds(loginUser, _methodContext.getValue("ToChannelIds"));
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        if (!loginUser.isAdministrator()) {
            for (i = chnlDocs.size(); i >= 0; --i) {
                Channel srcChannel;
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnlDoc == null || AuthServer.hasRight(loginUser, (CMSObj)(srcChannel = chnlDoc.getChannel()), 34)) continue;
                reports.addFailedReport("\u590d\u5236\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u67e5\u770b\u680f\u76ee[ID=" + srcChannel.getId() + ",Name=" + srcChannel.getDispDesc() + "]\u4e0b\u7684\u6587\u6863", null);
                chnlDocs.remove(i);
            }
        }
        int nSize = toChannels.size();
        for (i = 0; i < nSize; ++i) {
            Channel channel = (Channel)toChannels.getAt(i);
            if (channel == null) continue;
            if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
                reports.addFailedReport("\u590d\u5236\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee[ID=" + channel.getId() + ",Name=" + channel.getDispDesc() + "]\u4e0b\u521b\u5efa\u6587\u6863", null);
                continue;
            }
            MetaView toMetaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel);
            int nSizeInner = chnlDocs.size();
            for (int j = 0; j < nSizeInner; ++j) {
                ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(j);
                int srcViewId = chnlDoc.getPropertyAsInt("docKind", 0);
                if (chnlDoc == null || srcViewId == 0) continue;
                if (toMetaView.getId() != srcViewId) {
                    reports.addFailedReport("\u590d\u5236\u5931\u8d25:\u680f\u76ee[ID=" + channel.getId() + ",Name=" + channel.getDispDesc() + "]\u4f7f\u7528\u7684\u89c6\u56fe\uff3bID=" + toMetaView.getId() + ",Name=" + toMetaView.getDesc() + "]\u548c\u5f53\u524d\u680f\u76ee\u89c6\u56fe[ID=" + srcViewId + "]\u4e0d\u4e00\u81f4", null);
                    continue;
                }
                this.copy(chnlDoc, channel, reports, loginUser);
            }
        }
        return reports;
    }

    private void copy(ChnlDoc _fromChnlDoc, Channel _toChannel, Reports _reports, User _currUser) throws Throwable {
        if (_fromChnlDoc == null) {
            return;
        }
        MetaViewData metaViewData = MetaViewData.findById(_fromChnlDoc.getDocId());
        MetaViewData newMetaViewData = (MetaViewData)metaViewData.cloneToNewObj();
        newMetaViewData.setMetaView(metaViewData.getMetaView());
        newMetaViewData.setProperty("channelId", _toChannel.getId());
        newMetaViewData.save(_currUser);
        if (metaViewData.getId() != newMetaViewData.getId()) {
            this.m_oAppendixMgr.copyAppendixes(Document.findById(metaViewData.getId()), Document.findById(newMetaViewData.getId()));
        }
        _reports.addSucessedReport("\u6210\u529f\u590d\u5236\u8bb0\u5f55[" + metaViewData.getTitle() + "]\u5230\u680f\u76ee[" + _toChannel.getDispDesc() + "]\uff01");
    }

    private void validateRight(User _loginUser, MetaViewData _oMetaViewData, int _nRightIndex) throws WCMException {
        Channel channel;
        if (_loginUser.isAdministrator() || _loginUser.getName().equalsIgnoreCase(_oMetaViewData.getCrUserName())) {
            return;
        }
        int nChannelId = _oMetaViewData.getChannelId();
        if (nChannelId <= 0) {
            nChannelId = _oMetaViewData.getPropertyAsInt("ChannelId", 0);
        }
        if (!AuthServer.hasRight(_loginUser, (CMSObj)(channel = this.findChannelById(nChannelId)), _nRightIndex)) {
            throw new WCMException(1002, "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u89c6\u56fe\u6570\u636e[ID=" + _oMetaViewData.getId() + "]\uff01");
        }
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private Channel findChannelById(int _nObjectId) throws WCMException {
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(200006, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=" + _nObjectId + "]\uff01");
        }
        return channel;
    }

    private MetaView findViewById(int _nViewId) throws WCMException {
        MetaView view = MetaView.findById(_nViewId);
        if (view == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=" + _nViewId + "]");
        }
        return view;
    }

    private MetaView findViewByChannel(Channel _channel) throws WCMException {
        MetaView view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(_channel);
        if (view == null) {
            throw new WCMException("\u6307\u5b9a\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u89c6\u56fe\uff01[\u680f\u76ee\u4fe1\u606f=" + _channel + "]");
        }
        return view;
    }

    public static MetaViewData setViewDataProperties(MethodContext _methodContext, MetaViewData _oViewData) throws WCMException {
        Map mapParams = _methodContext.getParams();
        for (String sParamName : mapParams.keySet()) {
            Object value = mapParams.get(sParamName);
            if (value instanceof String) {
                _oViewData.setProperty(sParamName, value.toString().trim());
                continue;
            }
            if (value instanceof String[]) {
                String[] pValues = (String[])value;
                _oViewData.setProperty(sParamName, pValues == null || pValues.length == 0 ? null : pValues[0].trim());
                continue;
            }
            _oViewData.setProperty(sParamName, value);
        }
        return _oViewData;
    }

    private String convertToClassIds(int _nRootId, String _sClassNames) throws WCMException {
        if (CMyString.isEmpty(_sClassNames)) {
            return "";
        }
        WCMFilter filter = new WCMFilter("", "", "", String.valueOf("CLASSINFOID"));
        String[] pValues = _sClassNames.split(";");
        StringBuffer sbWhere = new StringBuffer(pValues.length * 2 + 20);
        sbWhere.append("RootId=? and CName in(");
        filter.addSearchValues(_nRootId);
        boolean bHasClassName = false;
        for (int i = 0; i < pValues.length; ++i) {
            pValues[i] = pValues[i].trim();
            if (pValues[i].length() == 0) continue;
            int nPos = pValues[i].lastIndexOf(92);
            if (nPos >= 0) {
                String[] pClassNamePath = pValues[i].split("\\\\");
                int nParentId = _nRootId;
                for (int j = 0; j < pClassNamePath.length && (CMyString.isEmpty(pClassNamePath[j]) || (nParentId = this.queryClassId(nParentId, pClassNamePath[j])) != 0); ++j) {
                }
                if (nParentId <= 0) continue;
                return String.valueOf(nParentId);
            }
            bHasClassName = true;
            sbWhere.append("?,");
            filter.addSearchValues(pValues[i]);
        }
        if (!bHasClassName) {
            return "";
        }
        sbWhere.setLength(sbWhere.length() - 1);
        sbWhere.append(")");
        filter.setWhere(sbWhere.toString());
        filter.setMaxRowNumber(pValues.length);
        StringBuffer sbClassIds = new StringBuffer(pValues.length * 2);
        ClassInfos infos = ClassInfos.openWCMObjs(null, filter);
        if (infos == null || infos.isEmpty()) {
            return "";
        }
        sbClassIds.append(infos.getIdAt(0));
        return sbClassIds.toString();
    }

    private int queryClassId(int _nParentId, String _sClassName) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=? and CName=?", "", String.valueOf("CLASSINFOID"));
        filter.setMaxRowNumber(1);
        filter.addSearchValues(_nParentId);
        filter.addSearchValues(_sClassName);
        ClassInfos infos = ClassInfos.openWCMObjs(null, filter);
        if (infos == null || infos.isEmpty()) {
            return 0;
        }
        return infos.getIdAt(0);
    }

    private static String queryDeptCode(String _sDeptName) throws WCMException {
        String sResult = null;
        Connection conn = DBManager.getDBManager().getConnection();
        PreparedStatement preStm = null;
        ResultSet rsData = null;
        try {
            preStm = conn.prepareStatement("select DCode from WCMMetaTableDeptCode where DName=?");
            preStm.setString(1, _sDeptName);
            preStm.setMaxRows(1);
            rsData = preStm.executeQuery();
            sResult = rsData.next() ? rsData.getString(1) : "00000000";
            rsData.close();
            rsData = null;
            preStm.close();
            preStm = null;
        }
        catch (Exception e) {
            throw new WCMException("\u83b7\u53d6\u7ec4\u7ec7\u7ed3\u6784\u7f16\u7801\u5931\u8d25\uff01", e);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (preStm != null) {
                try {
                    preStm.close();
                }
                catch (Exception exception) {}
            }
            DBManager.getDBManager().freeConnection(conn);
        }
        return sResult;
    }

    private WCMFilter getFilter(ClassInfo _oClassInfo, MetaView _metaView, MethodContext _methodContext) throws WCMException {
        if (_metaView == null) {
            return null;
        }
        boolean _bContainChildClassInfo = _methodContext.getValue("withChildren", false);
        WCMFilter filter = new WCMFilter("", "", "MetaDataId desc");
        StringBuffer sbWhere = new StringBuffer(300);
        sbWhere.append("exists(select XWCMClassInfoView.MetaDataId");
        sbWhere.append(" from XWCMClassInfoView");
        sbWhere.append(" where XWCMClassInfoView.ViewId = ?");
        filter.addSearchValues(_metaView.getId());
        if (_oClassInfo != null) {
            User loginUser;
            String sChildClassInfoIds;
            String sClassInfoIds = String.valueOf(_oClassInfo.getId());
            if (_bContainChildClassInfo && (sChildClassInfoIds = this.m_oClassInfoMgr.queryChildrenWithAllLevel(loginUser = this.getLoginUser(), _oClassInfo, null)) != null && sChildClassInfoIds.length() > 0) {
                sClassInfoIds = sClassInfoIds + "," + sChildClassInfoIds;
            }
            sbWhere.append(" and XWCMClassInfoView.ClassInfoId in (");
            String[] aClassInfoIds = sClassInfoIds.split(",");
            for (int i = 0; i < aClassInfoIds.length; ++i) {
                sbWhere.append("?,");
                filter.addSearchValues(aClassInfoIds[i]);
            }
            sbWhere.setCharAt(sbWhere.length() - 1, ')');
        }
        String sTableName = _metaView.getTrueTableName();
        sbWhere.append(" and XWCMClassInfoView.MetaDataId=" + sTableName + ".MetaDataId)");
        filter.setWhere(sbWhere.toString());
        return filter;
    }

    public MetaViewDatas queryObjectsOfView(MethodContext _methodContext) throws Throwable {
        int viewId = _methodContext.getValue("viewId", 0);
        if (viewId == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u89c6\u56fe\u7684id[viewId]");
        }
        MetaView metaView = MetaView.findById(viewId);
        if (metaView == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89c6\u56fe[id=" + viewId + "]\u4e0d\u5b58\u5728");
        }
        int classInfoId = _methodContext.getValue("classInfoId", 0);
        ClassInfo classInfo = ClassInfo.findById(classInfoId);
        MetaViewDatas objs = new MetaViewDatas(metaView);
        WCMFilter filterOfWhere = this.getQueryFilter(_methodContext, this.getLoginUser(), metaView);
        filterOfWhere.setSelect("");
        this.logger.debug((Object)("filterOfWhere:" + filterOfWhere));
        WCMFilter filter = this.getFilter(classInfo, metaView, _methodContext);
        this.logger.debug((Object)("filter before merge:" + filter));
        filter.mergeWith(filterOfWhere);
        this.logger.debug((Object)("filter after merge:" + filter));
        objs.open(filter);
        return objs;
    }

    public String queryObjectsCountOfView(MethodContext _methodContext) throws Throwable {
        int viewId = _methodContext.getValue("viewId", 0);
        if (viewId == 0) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u89c6\u56fe\u7684id[viewId]");
        }
        MetaView metaView = MetaView.findById(viewId);
        if (metaView == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89c6\u56fe[id=" + viewId + "]\u4e0d\u5b58\u5728");
        }
        WCMFilter filterOfWhere = this.getQueryFilter(_methodContext, this.getLoginUser(), metaView);
        filterOfWhere.setSelect("");
        this.logger.debug((Object)("filterOfWhere:" + filterOfWhere));
        User loginUser = this.getLoginUser();
        HashMap<String, Integer> oCountWithChild = new HashMap<String, Integer>();
        ClassInfos oClassInfos = null;
        String sClassInfoIds = _methodContext.getValue("classInfoIds");
        if (sClassInfoIds != null) {
            oClassInfos = ClassInfos.findByIds(loginUser, sClassInfoIds);
        } else {
            ClassInfo _oClassInfo = null;
            String sClassInfoId = _methodContext.getValue("classInfoId");
            if (sClassInfoId != null) {
                _oClassInfo = ClassInfo.findById(Integer.parseInt(sClassInfoId));
            }
            if (_oClassInfo == null) {
                oCountWithChild.put("0", new Integer(this.queryObjectsCountOfClassInfo(metaView, null, filterOfWhere)));
            }
            oClassInfos = this.m_oClassInfoMgr.queryChildren(loginUser, _oClassInfo, null);
        }
        int nSize = oClassInfos.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo oClassInfo = (ClassInfo)oClassInfos.getAt(i);
            if (oClassInfo == null) continue;
            oCountWithChild.put(String.valueOf(oClassInfo.getId()), new Integer(this.queryObjectsCountOfClassInfo(metaView, oClassInfo, filterOfWhere)));
        }
        if (oCountWithChild.size() == 0) {
            oCountWithChild.put("NoObject", new Integer(0));
        }
        _methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(oCountWithChild, 0);
    }

    public int queryObjectsCountOfClassInfo(MetaView _metaView, ClassInfo _classInfo, WCMFilter _filter) throws WCMException {
        if (_metaView == null) {
            return 0;
        }
        boolean _bContainChildClassInfo = true;
        WCMFilter filter = new WCMFilter("", "", "");
        StringBuffer sbWhere = new StringBuffer(300);
        sbWhere.append("exists(select XWCMClassInfoView.MetaDataId");
        sbWhere.append(" from XWCMClassInfoView");
        sbWhere.append(" where XWCMClassInfoView.ViewId = ?");
        filter.addSearchValues(_metaView.getId());
        if (_classInfo != null) {
            User loginUser;
            String sChildClassInfoIds;
            String sClassInfoIds = String.valueOf(_classInfo.getId());
            if (_bContainChildClassInfo && (sChildClassInfoIds = this.m_oClassInfoMgr.queryChildrenWithAllLevel(loginUser = this.getLoginUser(), _classInfo, null)) != null && sChildClassInfoIds.length() > 0) {
                sClassInfoIds = sClassInfoIds + "," + sChildClassInfoIds;
            }
            sbWhere.append(" and XWCMClassInfoView.ClassInfoId in (");
            String[] aClassInfoIds = sClassInfoIds.split(",");
            for (int i = 0; i < aClassInfoIds.length; ++i) {
                sbWhere.append("?,");
                filter.addSearchValues(aClassInfoIds[i]);
            }
            sbWhere.setCharAt(sbWhere.length() - 1, ')');
        }
        String sTableName = _metaView.getTrueTableName();
        sbWhere.append(" and XWCMClassInfoView.MetaDataId=" + sTableName + ".MetaDataId)");
        filter.setWhere(sbWhere.toString());
        filter.mergeWith(_filter);
        filter.setSelect("count(*)");
        filter.setFrom(sTableName);
        return DBManager.getDBManager().sqlExecuteIntQuery(filter);
    }

    public String exportViewDatas(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sViewDataIds = _methodContext.getObjectIds();
        Channel channel = null;
        MetaView view = null;
        int nViewId = _methodContext.getValue("ViewId", 0);
        if (nViewId > 0) {
            view = this.findViewById(nViewId);
        } else {
            channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
            view = this.findViewByChannel(channel);
        }
        MetaViewDatas viewDatas = new MetaViewDatas(view);
        int[] pObjecteds = CMyString.splitToInt(sViewDataIds, ",");
        viewDatas.setMaxBufferSize(pObjecteds.length);
        for (int i = 0; i < pObjecteds.length; ++i) {
            MetaViewData viewData = new MetaViewData(view);
            if (!viewData.loadById(pObjecteds[i], "*")) continue;
            viewData.setMetaDataId(pObjecteds[i]);
            Document document = Document.findById(pObjecteds[i], "DocTitle,DocContent");
            viewData.getProperties().put("DOCTITLE", document.getTitle());
            viewData.getProperties().put("DOCCONTENT", document.getContent());
            viewDatas.addElement(viewData);
        }
        MetaViewDataExporter exporter = new MetaViewDataExporter(view);
        return exporter.exportToZip(viewDatas);
    }
}

