/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.WidgetPathHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.store.FileService;

public class AdjustJsLCListenerWidget
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (!(objModified instanceof Widget)) {
            return;
        }
        Widget widget = (Widget)objModified;
        try {
            String sOldName = widget.getWname();
            String sNewName = widget.getNewPropertyAsString("WNAME");
            if (!sOldName.equals(sNewName)) {
                String sIdentityName = widget.getIdentityFlag(sOldName);
                String sRelateJsPath = WidgetPathHelper.getPath();
                FileService file = new FileService(sRelateJsPath + sIdentityName + ".js");
                if (file.exists()) {
                    String sNewIdentityName = widget.getIdentityFlag(sNewName);
                    FileService newFile = new FileService(sRelateJsPath + sNewIdentityName + ".js");
                    file.renameTo(newFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        if (!(objDeleted instanceof Widget)) {
            return;
        }
        Widget widget = (Widget)objDeleted;
        try {
            String sIdentityName = widget.getIdentityFlag(widget.getWname());
            String sRelateJsPath = WidgetPathHelper.getPath();
            FileService file = new FileService(sRelateJsPath + sIdentityName + ".js");
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

